/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.f;

import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.SPEZIELLE_VERSORGUNGSBEREICHE)
public class h {
    private static final g a = new g("01", "02", "03");

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="HIV Betreuungsziffer (30920) bei entsprechender Qualifikation abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="30920")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasDiagnoseBeginntMit("B24", "G", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("30920", c2.c);
    }

    @Rule(name="HIV Betreuungsziffer (30920) in Vorquartal ohne 30920 im aktuellen Quartal m\u00f6glich ", action=ActionType.NACHTRAGEN, gnr="30920")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung("30920", Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("30920", c2.c);
    }

    @Rule(name="HIV Betreuungsziffer {gnr} ohne Leitdiagnose B24 (Gesichert) ", action=ActionType.UEBERPRUEFEN, gnr="30920|30922|30924")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnoseBeginntMit("B24", "G", c2.c);
    }

    @Rule(name="HIV Zuschlag 30922 m\u00f6glich ", action=ActionType.NACHTRAGEN, gnr="30922")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        action.setAPK(patient.getAPK(true, c2.c, 2L, a));
        return patient.hasLeistung("30920", c2.c) && patient.getAPKCount(true, c2.c, a) == 2L && !patient.hasLeistung("30922", c2.c);
    }

    @Rule(name="HIV Zuschlag 30922 entfernen, da nur ein Arzt-Patienten-Kontakt ", action=ActionType.ENTFERNEN, gnr="30922")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung("30922", c2.c) && patient.getAPKCount(true, c2.c, a) < 2L;
    }

    @Rule(name="HIV Zuschlag 30924 entfernen, da weniger als 3 Arzt-Patienten-Kontakte", action=ActionType.ENTFERNEN, gnr="30924")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung("30924", c2.c) && patient.getAPKCount(true, c2.c, a) <= 2L;
    }

    @Rule(name="allergologisch-diagnostischer Komplex von Allergien vom Sp\u00e4ttyp (Typ IV) (30110) ist nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30110")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung("30110", c2.c) && patient.getLeistungCount("30110", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="allergologisch-diagnostischer Komplex von Allergien vom Sp\u00e4ttyp (Typ IV) (30110) im Behandlungsfall nicht neben der 30111 abrechenbar", action=ActionType.ENTFERNEN, gnr="30111")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung("30110", c2.c) && patient.hasLeistung("30111", c2.c);
    }

    @Rule(name="allergologisch-diagnostischer Komplex von Allergie vom Soforttyp (Typ I) (30111) ist nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30111")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung("30111", c2.c) && patient.getLeistungCount("30111", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="rhinomanometrischer Provokationstest (30120) h\u00f6chstens 2 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="30120", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30120", c2.c, date) > 2;
    }

    @Rule(name="rhinomanometrischer Provokationstest (30120) im Behandlungsfall nicht neben der 13250, 13258 abrechenbar", action=ActionType.ENTFERNEN, gnr="30120")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung("30120", c2.c) && patient.hasLeistung("13250|13258", c2.c);
    }

    @Rule(name="subkutaner Provokationstest (30121) im Behandlungsfall h\u00f6chstens 5 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="30121")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.getLeistungCount("30121", c2.c) > 5;
    }

    @Rule(name="subkutaner Provokationstest (30121) im Behandlungsfall nicht neben der 13250, 13258 abrechenbar", action=ActionType.ENTFERNEN, gnr="30121")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung("30121", c2.c) && patient.hasLeistung("13250|13258", c2.c);
    }

    @Rule(name="bronchialer Provokationstest (30122) am Behandlungstag nicht neben der 13651 abrechenbar", action=ActionType.ENTFERNEN, gnr="13651", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30122", c2.c, date) && patient.hasLeistung("13651", c2.c, date);
    }

    @Rule(name="bronchialer Provokationstest (30122) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="13250|13258")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung("30122", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="oraler Provokationstest (30123) im Behandlungsfall nicht neben der 13250, 13258 abrechenbar", action=ActionType.ENTFERNEN, gnr="30123")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung("30123", c2.c) && patient.hasLeistung("13250|13258", c2.c);
    }

    @Rule(name="Zuschlag Hyposensibilisierungsbehandlung (30131) am Behandlungstag h\u00f6chstens 4 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="30131", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30131", c2.c, date) > 4;
    }

    @Rule(name="manualmedizinischer Eingriff an den Extremit\u00e4ten (30200) im Behandlungsfall h\u00f6chstens 2 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="30200")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.getLeistungCount("30200", c2.c) > 2;
    }

    @Rule(name="manualmedizinischer Eingriff an den Extremit\u00e4ten (30200) am Behandlungstag nicht neben der 30201 abrechenbar", action=ActionType.ENTFERNEN, gnr="30200", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30200", c2.c, date) && patient.hasLeistung("30201", c2.c, date);
    }

    @Rule(name="sensomotorische Einzel\u00fcbungsbehandlung (30300) am Behandlungstag nicht neben der 04355, 04356, 14220, 14221, 14310, 14311, 16220, 21220, 21221, 30301, 30400, 30401, 30402, 30410, 30411, 30420, 30421, 30430, 30431 abrechenbar", action=ActionType.ENTFERNEN, gnr="30300", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30300", c2.c, date) && patient.hasLeistung("04355|04356|14220|14221|14310|14311|16220|21220|21221|30301|30400|30401|30402|30410|30411|30420|30421|30430|30431", c2.c, date);
    }

    @Rule(name="sensomotorische Gruppen\u00fcbungsbehandlung (30301) am Behandlungstag nicht neben der 04355, 04356, 14220, 14221, 14310, 14311, 16220, 21220, 21221, 30300, 30400, 30401, 30402, 30410, 30411, 30420, 30421, 30430, 30431, 30402A, 30400A, 30401A, 30420A, 30410A, 30411A, 30431A, 30421A, 30430A abrechenbar", action=ActionType.ENTFERNEN, gnr="30301", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30301", c2.c, date) && patient.hasLeistung("04355|04356|14220|14221|14310|14311|16220|21220|21221|30300|30400|30401|30402|30410|30411|30420|30421|30430|30431|30402A|30400A|30401A|30420A|30410A|30411A|30431A|30421A|30430A", c2.c, date);
    }

    @Rule(name="Massagetherapie (30400) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="30400", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30400|30400A", c2.c, date) > 1;
    }

    @Rule(name="Massagetherapie (30400) am Behandlungstag nicht neben der 30300, 30301, 30401, 30402, 30410, 30411, 30420, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30400", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30400|30400A", c2.c, date) && patient.hasLeistung("30300|30301|30401|30402|30410|30411|30420|30421|30401A|30402A|30410A|30411A|30420A|30421A", c2.c, date);
    }

    @Rule(name="intermittierende apparative Kompressionstherapie (30401) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="30401")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung("30401|30401A", c2.c) && !patient.hasDiagnoseBeginntMit("I70.20|I70.21|R60.0|I83.0|I87.0|I87.2|I89.0|L97|M43.0|Q27.8|Q82.0|T93", "G", c2.c);
    }

    @Rule(name="intermittierende apparative Kompressionstherapie (30401) am Behandlungstag nicht neben der 30300, 30301, 30400, 30402, 30410, 30411, 30420, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30401", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30401|30401A", c2.c, date) && patient.hasLeistung("30300|30301|30400|30402|30410|30411|30420|30421|30400A|30402A|30410A|30411A|30420A|30421A", c2.c, date);
    }

    @Rule(name="Unterwasserdruckstrahlmassage (30402) am Behandlungstag nicht neben der 30300, 30301, 30400, 30401, 30410, 30411, 30420, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30402", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30402|30402A", c2.c, date) && patient.hasLeistung("30300|30301|30400|30401|30410|30411|30420|30421|30400A|30401A|30410A|30411A|30420A|30421A", c2.c, date);
    }

    @Rule(name="Atemgymnastik (Einzelbehandlung) (30410) am Behandlungstag nicht neben der 30300, 30301, 30400, 30401, 30402, 30411, 30420, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30410", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30410|30410A", c2.c, date) && patient.hasLeistung("30300|30301|30400|30401|30402|30411|30420|30421|30400A|30401A|30402A|30411A|30420A|30421A", c2.c, date);
    }

    @Rule(name="Atemgymnastik (Gruppenbehandlung) (30411) am Behandlungstag nicht neben der 30300, 30301, 30400, 30401, 30402, 30410, 30420, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30411", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30411|30411A", c2.c, date) && patient.hasLeistung("30300|30301|30400|30401|30402|30410|30420|30421|30400A|30401A|30402A|30410A|30420A|30421A", c2.c, date);
    }

    @Rule(name="Krankengymnastik (Einzelbehandlung) 30420 am Behandlungstag nicht neben der 08310, 26313, 30300, 30301, 30400, 30401, 30402, 30410, 30411, 30421 abrechenbar", action=ActionType.ENTFERNEN, gnr="30420", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30420|30420A", c2.c, date) && patient.hasLeistung("08310|26313|30300|30301|30400|30401|30402|30410|30411|30421|30400A|30401A|30402A|30410A|30411A|30421A", c2.c, date);
    }

    @Rule(name="Krankengymnastik (Gruppenbehandlung) 30421 am Behandlungstag nicht neben der 08310, 26313, 30300, 30301, 30400, 30401, 30402, 30410, 30411, 30420 abrechenbar", action=ActionType.ENTFERNEN, gnr="30421", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30421|30421A", c2.c, date) && patient.hasLeistung("08310|26313|30300|30301|30400|30401|30402|30410|30411|30420|30400A|30401A|30402A|30410A|30411A|30420A", c2.c, date);
    }

    @Rule(name="selektive Phototherapie (30430) am Behandlungstag nicht neben der 30300, 30301, 10350 abrechenbar", action=ActionType.ENTFERNEN, gnr="30430", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30430|30430A", c2.c, date) && patient.hasLeistung("30300|30301|10350", c2.c, date);
    }

    @Rule(name="Zuschlag zur selektiven Phototherapie (30431) am Behandlungstag nicht neben der 30300, 30301, 10350 abrechenbar", action=ActionType.ENTFERNEN, gnr="30431", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30431|30431A", c2.c, date) && patient.hasLeistung("30300|30301|10350", c2.c, date);
    }

    @Rule(name="phlebologischer Basiskomplex (30500) am Behandlungstag nicht neben der 02300, 02301, 02302, 02311, 10340, 10341, 10342 abrechenbar", action=ActionType.ENTFERNEN, gnr="30500", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30500", c2.c, date) && patient.hasLeistung("02300|02301|02302|02311|10340|10341|10342", c2.c, date);
    }

    @Rule(name="phlebologischer Basiskomplex (30500) im Behandlungsfall nicht neben der 03040, 03220, 03220H, 03221, 03221H, 04040, 04220, 04220H, 04221, 04211H, 13300, 13545, 33061, 36882 abrechenbar", action=ActionType.ENTFERNEN, gnr="30500")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung("30500", c2.c) && patient.hasLeistung("03040|03220|03220H|03221|03221H|04040|04220|04220H|04221|04211H|13300|13545|33061|36882", c2.c);
    }

    @Rule(name="phlebologischer Basiskomplex (30500) h\u00f6chstens ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30500")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.getLeistungCount("30500", c2.c) > 1;
    }

    @Rule(name="Ver\u00f6dung von Varizen (30501) h\u00f6chstens 10 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30501")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.getLeistungCount("30501", c2.c) > 10;
    }

    @Rule(name="Ver\u00f6dung von Varizen (30501) am Behandlungstag nicht neben der 02300, 02301, 02302, 02311, 02313, 10340, 10341, 10342 abrechenbar", action=ActionType.ENTFERNEN, gnr="30501", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30501", c2.c, date) && patient.hasLeistung("02300|02301|02302|02311|02313|10340|10341|10342", c2.c, date);
    }

    @Rule(name="Ver\u00f6dung von Varizen (30501) im Behandlungsfall nicht neben der 03040, 03220, 03220H, 03221, 03221H, 04040, 04220, 04220H, 04221, 04211H abrechenbar", action=ActionType.ENTFERNEN, gnr="30501")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung("30501", c2.c) && patient.hasLeistung("03040|03220|03220H|03221|03221H|04040|04220|04220H|04221|04211H", c2.c);
    }

    @Rule(name="Zusatzpauschale Prokto-/Rektoskopie (30600) am Behandlungstag nicht neben der 03331, 04331, 04516, 08333, 10340, 10341, 10342, 13250, 13257, 26350, 26351, 26352 abrechenbar", action=ActionType.ENTFERNEN, gnr="30600", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30600", c2.c, date) && patient.hasLeistung("03331|04331|04516|08333|10340|10341|10342|13250|13257|26350|26351|26352", c2.c, date);
    }

    @Rule(name="Zusatzpauschale Prokto-/Rektoskopie (30600) im Behandlungsfall nicht neben der 13260 abrechenbar", action=ActionType.ENTFERNEN, gnr="30600")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung("30600", c2.c) && patient.hasLeistung("13260", c2.c);
    }

    @Rule(name="Zuschlag zur 30600 f\u00fcr die Polypentfernung(en) (30601) am Behandlungstag nicht neben der 02300, 02301, 02302, 08334, 10340, 10341, 10342, 26350, 26351, 26352 abrechenbar", action=ActionType.ENTFERNEN, gnr="30601", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30601", c2.c, date) && patient.hasLeistung("02300|02301|02302|08334|10340|10341|10342|26350|26351|26352", c2.c, date);
    }

    @Rule(name="Zuschlag zur 30600 f\u00fcr die Polypentfernung(en) (30601) im Behandlungsfall nicht neben der 13260 abrechenbar", action=ActionType.ENTFERNEN, gnr="30601")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung("30601", c2.c) && patient.hasLeistung("13260", c2.c);
    }

    @Rule(name="Behandlung(en) von H\u00e4morrhoiden (30610) am Behandlungstag nicht neben der 02300, 02301, 02302, 10340, 10341, 10342, 26350, 26351, 26352 abrechenbar", action=ActionType.ENTFERNEN, gnr="30610", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30610", c2.c, date) && patient.hasLeistung("02300|02301|02302|10340|10341|10342|26350|26351|26352", c2.c, date);
    }

    @Rule(name="Entfernung von H\u00e4morrhoiden (30611) am Behandlungstag nicht neben der 02300, 02301, 02302, 10340, 10341, 10342, 26350, 26351, 26352 abrechenbar", action=ActionType.ENTFERNEN, gnr="30611", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30611", c2.c, date) && patient.hasLeistung("02300|02301|02302|10340|10341|10342|26350|26351|26352", c2.c, date);
    }

    @Rule(name="Erstverordnung Soziotherapie (30810) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30810")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung("30810", c2.c) && patient.getLeistungCount("30810", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Erstverordnung Soziotherapie (30810) am Behandlungstag nicht neben der 30811 abrechenbar", action=ActionType.ENTFERNEN, gnr="30811", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30810", c2.c, date) && patient.hasLeistung("30811", c2.c, date);
    }

    @Rule(name="\u00dcberpr\u00fcfung der Indikation zur Folgeverordnung Soziotherapie (30811) im Behandlungsfall h\u00f6chstens 2 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="30811")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.getLeistungCount("30811", c2.c) > 2;
    }

    @Rule(name="kardiorespiratorische Polygraphie (30900) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="04434|04435|14320|14321|16310|16311|21310|21311", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30900", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="kardiorespiratorische Polygraphie (30900) am Behandlungstag nicht neben der 30901 abrechenbar", action=ActionType.ENTFERNEN, gnr="30900", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30900", c2.c, date) && patient.hasLeistung("30901", c2.c, date);
    }

    @Rule(name="kardiorespiratorische Polygraphie (30900) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="03040|03220|03220H|03221|03221H|04040|04220|04220H|04221|04221H")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung("30900", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="kardiorespiratorische Polysomnographie (30901) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="04434|04435|14320|14321|16310|16311|21310|21311|30900", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30901", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="kardiorespiratorische Polysomnographie (30901) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="03040|03220|03220H|03221|03221H|04040|04220|04220H|04221|04221H")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung("30901", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="krankheitspezifische neuropsychologische Diagnostik mittels Testverfahren (30930) am Behandlungstag nicht neben der 01205, 01207, 01210, 01212, 01214, 01216, 01218, 04355, 04356, 14220, 14221, 14222, 14310, 14311, 16220, 21220, 21221, 22220, 22221, 22222, 23220, 30702 abrechenbar", action=ActionType.ENTFERNEN, gnr="30930", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30930", c2.c, date) && patient.hasLeistung("01205|01207|01210|01212|01214|01216|01218|04355|04356|14220|14221|14222|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702", c2.c, date);
    }

    @Rule(name="probatorische Sitzung (30931) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01205|01207|01210|01212|01214|01216|01218|04355|04356|14220|14221|14222|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702|30932|30933", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30931", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="neuropsychologische Therapie (Einzelbehandlung) (30932) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01205|01207|01210|01212|01214|01216|01218|04355|04356|14220|14221|14222|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702|30931", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30932", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="neuropsychologische Therapie (Gruppenbehandlung) (30933) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01205|01207|01210|01212|01214|01216|01218|04355|04356|14220|14221|14222|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702|30931", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30933", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Erstellung eines Therapieplans (30934) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30934")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung("30934", c2.c) && patient.getLeistungCount("30934", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Erstellung eines Therapieplans (30934) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="04355|04356", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30934", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Bericht bei Therapieverl\u00e4ngerung im Einzelfall (30935) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30935")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung("30935", c2.c) && patient.getLeistungCount("30935", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Bericht bei Therapieverl\u00e4ngerung im Einzelfall (30935) am Behandlungstag nicht neben der 04355, 04356 abrechenbar", action=ActionType.ENTFERNEN, gnr="30935", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30935", c2.c, date) && patient.hasLeistung("04355|04356", c2.c, date);
    }

    @Rule(name="Erhebung des MRSA-Status eines Risikopatienten (30940) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30940")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.getLeistungCount("30940", c2.c) > 1;
    }

    @Rule(name="Behandlung und Betreuung eines Risikopatienten (30942) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30942")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.getLeistungCount("30942", c2.c) > 1;
    }

    @Rule(name="Abkl\u00e4rungs-Diagnostik einer Kontaktperson nach erfolgloser Sanierung eines MRSA-Tr\u00e4gers (30946) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30946")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.getLeistungCount("30946", c2.c) > 1;
    }

    @Rule(name="Teilnahme an einer MRSA-Fall- und/oder regionalen Netzwerkkonferenz (30948) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30948")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.getLeistungCount("30948", c2.c) > 1;
    }

    @Rule(name="Best\u00e4tigung einer MRSA-Besiedelung durch Abstriche (30950) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="30950", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30950", c2.c, date) > 1;
    }

    @Rule(name="Best\u00e4tigung einer MRSA-Besiedelung durch Abstriche (30950) nur zwei Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30950")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.getLeistungCount("30950", c2.c) > 2;
    }

    @Rule(name="Ausschluss einer MRSA-Besiedelung durch Abstriche (30952) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="30952", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30952", c2.c, date) > 1;
    }

    @Rule(name="Ausschluss einer MRSA-Besiedelung durch Abstriche (30952) nur zwei Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30952")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.getLeistungCount("30952", c2.c) > 2;
    }

    @Rule(name="gezielter MRSA-Nachweis auf chromogenem Selektivn\u00e4hrboden (30954) am Behandlungstag nicht neben der 32837 abrechenbar", action=ActionType.ENTFERNEN, gnr="30954", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30954", c2.c, date) && patient.hasLeistung("32837", c2.c, date);
    }

    @Rule(name="gezielter MRSA-Nachweis auf chromogenem Selektivn\u00e4hrboden (30954) nur neben der 30950, 30952 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="30954")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung("30954", c2.c) && !patient.hasLeistung("30950|30952", c2.c);
    }

    @Rule(name="Nachweis der Koagulase und/oder des Clumpingfaktors zur Erregeridentifikation nur bei positivem Nachweis gem\u00e4\u00df 30954 (30956) nur neben der 30950, 30952 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="30956")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung("30956", c2.c) && !patient.hasLeistung("30950|30952", c2.c);
    }

    @Rule(name="Nachweis der Koagulase und/oder des Clumpingfaktors zur Erregeridentifikation nur bei positivem Nachweis gem\u00e4\u00df 30954 (30956) am Behandlungstag nicht neben der 32837 abrechenbar", action=ActionType.ENTFERNEN, gnr="30956", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30956", c2.c, date) && patient.hasLeistung("32837", c2.c, date);
    }

    @Rule(name="spezialisierte geriatrische Diagnostik und Versorgung erst ab Beginn des 71. Lebensjahrs abrechenbar", action=ActionType.ENTFERNEN, gnr="30980|30981|30984|30985|30986|30988")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getAlterAnTag(patient.getLeistung(string, 1L, c2.c).getDatum()) < 70;
    }

    @Rule(name="Abkl\u00e4rung vor der Durchf\u00fchrung eines weiterf\u00fchrenden geriatrischen Assessments durch einen Arzt gem\u00e4\u00df Nr. 1 der Pr\u00e4ambel des Abschnitts 30.13 (30980) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30980")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung("30980", c2.c) && patient.getLeistungCount("30980", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Abkl\u00e4rung vor der Durchf\u00fchrung eines weiterf\u00fchrenden geriatrischen Assessments durch einen Arzt gem\u00e4\u00df Nr. 2 der Pr\u00e4ambel des Abschnitts 30.13 (30981) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30981")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung("30981", c2.c) && patient.getLeistungCount("30981", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="weiterf\u00fchrendes geriatrisches Assessment (30984) h\u00f6chstens ein Mal in Krankheitsfall abrechenbar, es sei denn es besteht eine ausf\u00fchrliche medizinische Notwendigkeit", action=ActionType.ENTFERNEN, gnr="30984")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung("30984", c2.c) && patient.getLeistungCount("30984", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="weiterf\u00fchrendes geriatrisches Assessment (30984) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="03360|03362|30988", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30984", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Zuschlag zur Geb\u00fchrenordnungsposition 30984 f\u00fcr die Fortsetzung des weiterf\u00fchrenden geriatrischen Assessments (30985) h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30985")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung("30985", c2.c) && patient.getLeistungCount("30985", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Zuschlag zur Geb\u00fchrenordnungsposition 30985 f\u00fcr die Fortsetzung des weiterf\u00fchrenden geriatrischen Assessments (30986) h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30986")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung("30986", c2.c) && patient.getLeistungCount("30986", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Zuschlag zur 03362, 16230,16231, 21230, 21231 f\u00fcr die Einleitung und Koordination der Therapiema\u00dfnahmen nach multiprofessioneller geriatrischer Diagnostik (30988) h\u00f6chstens ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30988")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung("30988", c2.c) && patient.getLeistungCount("30988", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Zuschlag zur 03362, 16230,16231, 21230, 21231 f\u00fcr die Einleitung und Koordination der Therapiema\u00dfnahmen nach multiprofessioneller geriatrischer Diagnostik (30988) nur neben der 03362, 16230,16231, 21230, 21231 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="30988")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung("30988", c2.c) && !patient.hasLeistung("03362|16230|16231|21230|21231", c2.c);
    }

    @Rule(name="Zuschlag zur 03362, 16230,16231, 21230, 21231 f\u00fcr die Einleitung und Koordination der Therapiema\u00dfnahmen nach multiprofessioneller geriatrischer Diagnostik (30988) am Behandlungstag nicht neben der 30984 abrechenbar", action=ActionType.ENTFERNEN, gnr="30988", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30988", c2.c, date) && patient.hasLeistung("30984", c2.c, date);
    }

    @Rule(name="Zuschlag zur 03362, 16230, 16231, 21230, 21231 f\u00fcr die Einleitung und Koordination der Therapiema\u00dfnahmen gem\u00e4\u00df multiprofessioneller geriatrischer Diagnostik nach Durchf\u00fchrung eines weiterf\u00fchrenden geriatrischen Assessments gem\u00e4\u00df Geb\u00fchrenordnungsposition 30984 (30988) nur innerhalb von vier Wochen nach der 30984 abrechnebar", action=ActionType.ENTFERNEN, gnr="30988")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        if (!patient.hasLeistung("30988", c2.c)) {
            return false;
        }
        if (!patient.hasLeistung("30984", c2.c)) {
            return true;
        }
        return !patient.hasLeistungInDaysBefore(patient.getLeistung("30988", 1L, c2.c).getDatum(), patient.getLeistung("30984", 1L, c2.c).getDatum(), 28);
    }

    @Rule(name="sonographische Untersuchung des Abdomens (33042) ist im Behandlungfalls h\u00f6chstens 2 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="33042")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.getLeistungCount("33042", c2.c) > 2;
    }

    @Rule(name="sonographische Untersuchung des Abdomens (33042) am Behandlungstag nicht neben der 01205, 01207, 01773, 01781, 01782, 01787, 01831, 01902, 01904, 01906, 08341, 33043 abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient, Date date) {
        return patient.hasLeistung("33042", c2.c, date) && patient.hasLeistung("01205|01207|01773|01781|01782|01787|01831|01902|01904|01906|08341|33043", c2.c, date);
    }

    @Rule(name="sonographische Untersuchung des Abdomens (33042) am Behandlungstag ohne entsprechende gesicherte Diagnose nicht neben der 33081 abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient, Date date) {
        return patient.hasLeistung("33042", c2.c, date) && patient.hasLeistung("33081", c2.c, date) && !patient.hasDiagnoseBeginntMit("C81|C82|C83|C84|C85|C86|C88|C90|C91|C92|C93|C94|C95|C96", c2.c);
    }

    @Rule(name="sonographische Untersuchung des Abdomens (33042) am Behandlungstag nicht neben der 31630, 31631, 31632, 31633, 31634, 31635, 31636, 31637, 31682, 31683, 31684, 31685, 31686, 31687, 31688, 31689, 31695, 31696, 31697, 31698, 31699, 31700, 31701, 31702 abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient, Date date) {
        return patient.hasLeistung("33042", c2.c, date) && patient.hasLeistung("31630|31631|31632|31633|31634|31635|31636|31637|31682|31683|31684|31685|31686|31687|31688|31689|31695|31696|31697|31698|31699|31700|31701|31702", c2.c, date);
    }

    @Rule(name="sonographische Untersuchung des Abdomens (33042) im Behandlungsfall nicht neben der 01772, 01780, 26330 abrechenbar", action=ActionType.ENTFERNEN, gnr="33042")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung("33042", c2.c) && patient.hasLeistung("01772|01780|26330", c2.c);
    }

    @Rule(name="Zuschlag im Zusammenhang mit der 01949, 01950, 01953, 01955 f\u00fcr das therapeutische Gespr\u00e4ch (01952) nur neben der 01949, 01950, 01953, 01955 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01952")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung("01952", c2.c) && !patient.hasLeistung("01949|01950|01953|01955", c2.c);
    }

    @Rule(name="Zuschlag im Zusammenhang mit der 01949, 01950, 01955 f\u00fcr das therapeutische Gespr\u00e4ch (01952) h\u00f6chstens 4 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01952")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung("01952", c2.c) && patient.getLeistungCount("01952", c2.c) > 4;
    }

    @Rule(name="Zuschlag im Zusammenhang mit der 01949, 01950, 01953, 01955 f\u00fcr das therapeutische Gespr\u00e4ch (01952) am Behandlungstag nicht neben der 01960 abrechenbar", action=ActionType.ENTFERNEN, gnr="01960", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01960", c2.c, date) && patient.hasLeistung("01952", c2.c, date);
    }

    @Rule(name="substitutionsgest\u00fctzte Behandlung opioidabh\u00e4ngiger mit einem Depotpr\u00e4parat (01953) ohne entsprechende Diagnose (F11.*)", action=ActionType.UEBERPRUEFEN, gnr="01953")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.hasLeistung("01953", c2.c) && !patient.hasDiagnoseBeginntMit("F11", "G", c2.c);
    }

    @Rule(name="substitutionsgest\u00fctzte Behandlung opioidabh\u00e4ngiger mit einem Depotpr\u00e4parat (01953) am Behandlungstag nicht neben der Versicherten-, Grund-, Konsiliarpauschale abrechenbar", action=ActionType.ENTFERNEN, gnr="01953", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01953", c2.c, date) && patient.hasLeistung("01100|01101|01102|01205|01207|01210|01212|01214|01216|01320|01321|01418|01700|01701|01949|01950|01955|01956|01960|03001|03002|03003|03004|03005|03030|04001|04002|04003|04004|04005|04030|05210|05211|05212|06210|06211|06212|07210|07211|07212|08210|08211|08212|09210|09211|09212|10210|10211|10212|11210|11211|11212|11301|12210|12220|12225|13210|13211|13212|13290|13291|13292|13340|13341|13342|13390|13391|13392|13490|13491|13492|13540|13541|13542|13590|13591|13592|13640|13641|13642|13690|13691|13692|14210|14211|15210|15211|15212|16210|16211|16212|17210|18210|18211|18212|19210|19401|19403|20210|20211|20212|21210|21211|21212|21213|21214|21215|22210|22211|22212|23210|23211|23212|23214|24210|24211|24212|25210|25211|25214|26210|26211|26212|27210|27211|27212|30700", c2.c, date);
    }

    @Rule(name="Voruntersuchung im Rahmen der Erprobungs-Richtlinie MRgFUSTUF inklusive der notwendigen bildgebenden Verfahren nur ein Mal m\u00f6glich", action=ActionType.ENTFERNEN, gnr="61050")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung("61050", c2.c) && patient.hasLeistung("61050", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="manualmedizinischer Eingriff an der Wirbels\u00e4ule (30201) ohne Begr\u00fcndung nur zweimal im Behandlungsfall abrechenbar, bei Mehrfachabrechnung Begr\u00fcndung notwendig.", action=ActionType.UEBERPRUEFEN, gnr="30201")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean U(c c2, Patient patient) {
        return patient.getLeistungCount("30201", c2.c) > 2;
    }

    @Rule(name="manualmedizinischer Eingriff an der Wirbels\u00e4ule (30201) ohne entsprechende gesicherte Diagnose (M40-M54).", action=ActionType.UEBERPRUEFEN, gnr="30201")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung("30201", c2.c) && !patient.hasDiagnoseBeginntMit("M40|M41|M42|M43|M45|M46|M47|M48|M49|M50|M51|M52|M53|M54", "G", c2.c);
    }

    @Rule(name="Indikationsstellung zur Behandlung eines Patienten mit Tumortherapiefeldern (TTF) (30310) nur einmal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30310")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean W(c c2, Patient patient) {
        return patient.getLeistungCount("30310", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Zusatzpauschale Behandlung und/oder Betreuung eines Patienten mit Tumortherapiefeldern (TTF) (30311) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30311")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.getLeistungCount("30311", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale Behandlung und/oder Betreuung eines Patienten mit Tumortherapiefeldern (TTF) (30311) im Arztfall nicht neben der 13500 abrechenbar", action=ActionType.ENTFERNEN, gnr="13500")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        if (!patient.hasLeistung("30311", c2.c)) {
            return false;
        }
        if (!patient.hasLeistung("13500", c2.c)) {
            return false;
        }
        return patient.getLeistung("30311", 1L, c2.c).getLanr().equals(patient.getLeistung("13500", 1L, c2.c).getLanr());
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Entscheidung \u00fcber die Ausrichtung von Tumortherapiefeldern (TTF) zur Behandlung des Glioblastoms (30312) bis zu dreimal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30312")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Action action) {
        return patient.getLeistungCount("30312", c2.c) > 3;
    }

    @Rule(name="Voruntersuchung im Rahmen der Erprobungs-Richtlinie MRgFUS-TUF inklusive der notwendigen bildgebenden Verfahren (61050) am Behandlungstag nicht neben der 61051 und 61052 abrechenbar.", action=ActionType.ENTFERNEN, gnr="61050", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient, Date date) {
        return patient.hasLeistung("61050", c2.c, date) && patient.hasLeistung("61051|61052", c2.c, date);
    }

    @Rule(name="Magnetresonanztomographie-gesteuerte hochfokussierte Ultraschalltherapie zur Behandlung des Uterusmyoms im Rahmen der Erprobungs-Richtlinie MRgFUS-TUF (61051) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61051")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung("61051", c2.c) && patient.hasLeistung("61051", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Magnetresonanztomographie-gesteuerte hochfokussierte Ultraschalltherapie zur Behandlung des Uterusmyoms im Rahmen der Erprobungs-Richtlinie MRgFUS-TUF (61051) am Behandlungstag nicht neben der 61052 abrechenbar.", action=ActionType.ENTFERNEN, gnr="61052", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient, Date date) {
        return patient.hasLeistung("61051", c2.c, date) && patient.hasLeistung("61052", c2.c, date);
    }

    @Rule(name="Nachuntersuchung(en) im Rahmen der Erprobungs-Richtlinie MRgFUS-TUF inklusive der notwendigen bildgebenden Verfahren (61052) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61052")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung("61052", c2.c) && patient.hasLeistung("61052", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Nachsorge von Patienten der Interventionsgruppe in der 1.-8. Woche nach Implantation eines PA-Drucksensors (61060) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61060")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung("61060", c2.c) && patient.hasLeistung("61060", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Nachsorge von Patienten der Interventionsgruppe in der 9.-52. Woche nach Implantation eines PA-Drucksensors (61061) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61061")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung("61061", c2.c) && patient.hasLeistung("61061", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten der Kontrollgruppe in der 1.-52. Woche (61062) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61062")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung("61062", c2.c) && patient.hasLeistung("61062", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Nachsorge von Patienten der Interventionsgruppe ab der 53. Woche nach Implantation eines PA-Drucksensors (61063) nur einmal im Behandlungsfall abrechenbar.", action=ActionType.ENTFERNEN, gnr="61063")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung("61063", c2.c) && patient.hasLeistung("61063", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Pauschale f\u00fcr Auftragsleistungen der Abschnitte 12.2 und 32.2.3 im Rahmen der Erp-RL (61064) nur ein Mal im Leben abrechenbar.", action=ActionType.ENTFERNEN, gnr="61064")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean af(c c2, Patient patient) {
        return patient.hasLeistung("61064", c2.c) && patient.hasLeistung("61064", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="Extrakorporale Sto\u00dfwellentherapie beim Fersenschmerz bei Fasciitis plantaris (30440) nur durch bestimmte Fachgruppen abrechenbar", action=ActionType.ENTFERNEN, gnr="30440")
    @RuleRequirement(value={Quartale.AQ})
    public static ScheinLeistung ag(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(i.a("30440")).filter(new g("10", "11", "57").negate()).findFirst().orElse(null);
    }

    @Rule(name="Voruntersuchung im Rahmen der TES-RP Erp-RL (61080) nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="61080")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung("61080", c2.c) && patient.getLeistungCount("61080", Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="Pauschale f\u00fcr die Trainingsphase im Rahmen der TES-RP Erp-RL inklusive der Untersuchungen (61081) nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="61081")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ai(c c2, Patient patient) {
        return patient.getLeistungCount("61081", Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="Pauschale f\u00fcr Visite nach der Trainingsphase im Rahmen der TES-RP Erp-RL (61082) nur dreimal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="61082")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aj(c c2, Patient patient) {
        return patient.getLeistungCount("61082", Quartal.getBisVorvorjahr(c2.c)) > 3;
    }

    @Rule(name="Kostenpauschale f\u00fcr den Sprechstundenbedarf im Zusammenhang mit der Durchf\u00fchrung der Leistungen aus Abschnitt 61.6.2 (61083) nur f\u00fcr Krankenh\u00e4user abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="61083")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        return patient.hasLeistung("61083", c2.c);
    }

    @Rule(name="Extrakorporale Sto\u00dfwellentherapie beim Fersenschmerz bei Fasciitis plantaris (30440) ohne gesicherte M72.2 in den beiden Vorquartalen", action=ActionType.ENTFERNEN, gnr="30440")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean al(c c2, Patient patient) {
        return patient.hasLeistung("30440", c2.c) && !patient.hasDiagnose("M72.2", "G", Arrays.asList(c2.c, c2.d, c2.e));
    }

    @Rule(name="Substitutionsgest\u00fctzte Behandlung Opioidabh\u00e4ngiger (01950) nur einmal pro Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01950", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("01950", c2.c, date) > 1;
    }

    @Rule(name="Substitutionsgest\u00fctzte Behandlung Opioidabh\u00e4ngiger (01950) am Behandlungstag nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01950", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01950", c2.c, date) && patient.hasLeistung("01100|01101|01102|01207|01210|01212|01214|01216|01218|01320|01321|01418|01700|01701 03001|03002|03003|03004|03005|03030|04001|04002|04003|04004|04005|04030|05210|05211|05212|06210|06211|06212|07210|07211|07212|08210|08211|08212|09210|09211|09212|10210|10211|10212|11210|11211|11212|11301|12210|12220|12225|13210|13211|13212|13290|13291|13292|13340|13341|13342|13390|13391|13392|13490|13491|13492|13540|13541|13542|13590|13591|13592|13640|13641|13642|13690|13691|13692|14210|14211|15210|15211|15212|16210|16211|16212|17210|18210|18211|18212|19210|19401|19403|20210|20211|20212|21210|21211|21212|21213|21214|21215|22210|22211|22212|23210|23211|23212|23214|24210|24211|24212|25210|25211|25214|26210|26211|26212|27210|27211|27212|30700|37706", c2.c, date);
    }

    @Rule(name="Substitutionsgest\u00fctzte Behandlung Opioidabh\u00e4ngiger (01950) im Behandlungsfall nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01950")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient) {
        return patient.hasLeistung("01950", c2.c) && patient.hasLeistung("01410|01411|01412|01413|01414|01415|01420|01440", c2.c) && patient.hasDiagnoseBeginntMit("F11", "G", c2.c) && patient.getDiagnosen(c2.c).stream().anyMatch(scheinDiagnose -> !scheinDiagnose.getIcdCodeClean().startsWith("F11") && scheinDiagnose.getSicherheit().equals("G"));
    }

    @Rule(name="Substitutionsgest\u00fctzte Behandlung Opioidabh\u00e4ngiger (01950) im Behandlungsfall nicht neben 01430 abrechenbar", action=ActionType.ENTFERNEN, gnr="01430")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean an(c c2, Patient patient) {
        return patient.hasLeistung("01950", c2.c) && patient.hasLeistung("01430", c2.c) && patient.hasDiagnoseBeginntMit("F11", "G", c2.c) && patient.getDiagnosen(c2.c).stream().anyMatch(scheinDiagnose -> !scheinDiagnose.getIcdCodeClean().startsWith("F11") && scheinDiagnose.getSicherheit().equals("G"));
    }

    @Rule(name="Substitutionsgest\u00fctzte Behandlung Opioidabh\u00e4ngiger (01950) am Behandlungstag nicht neben 01205 abrechenbar", action=ActionType.ENTFERNEN, gnr="01205", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01950", c2.c, date) && patient.hasLeistung("01205", c2.c, date);
    }

    @Rule(name="Orale Hyposensibilisierungsbehandlung (30134) einmal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="30134", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("30134", c2.c, date) > 1;
    }

    @Rule(name="Extrakorporale Sto\u00dfwellentherapie beim Fersenschmerz bei Fasciitis plantaris (30440) in h\u00f6chstens 2 aufeinanderfolgenden Quartalen abrechenbar", action=ActionType.ENTFERNEN, gnr="30440")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean ao(c c2, Patient patient) {
        return patient.hasLeistung("30440", c2.c) && patient.hasLeistung("30440", c2.d) && patient.hasLeistung("30440", c2.e);
    }

    @Rule(name="Extrakorporale Sto\u00dfwellentherapie beim Fersenschmerz bei Fasciitis plantaris (30440) bei gesicherter Diagnose M72.2 eventuell bis zu 3x je Fu\u00df m\u00f6glich", action=ActionType.POTENTIAL, gnr="30440")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ap(c c2, Patient patient) {
        return patient.getLeistungCount("30440", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 6 && (!patient.hasLeistung("30440", c2.d) || !patient.hasLeistung("30440", c2.e)) && patient.hasLeistungBeginntMit("18|27", c2.c) && patient.hasDiagnose("M72.2", "G", c2.d) && patient.hasDiagnose("M72.2", "G", c2.e) && !patient.hasDiagnose("M72.2", "G", c2.c);
    }

    @Rule(name="Basis-Assessment bei Long-Covid (37800) am Behandlungstag nicht neben 01732, 03220, 03360, 03370, 04220, 04370 und 37801 berechnungsf\u00e4hig", gnr="37800", action=ActionType.ENTFERNEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37800", c2.c, date) && patient.hasLeistung("01732|03220|03360|03370|04220|04370|37801", c2.c, date);
    }

    @Rule(name="Basis-Assessment bei Long-Covid (37800) nur einmal im Krankheitsfall abrechenbar", gnr="37800", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aq(c c2, Patient patient) {
        return patient.hasLeistung("37800", c2.c) && patient.getLeistungCount("37800", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Basis-Assessment bei Long-Covid (37800) einmal im Krankheitsfall m\u00f6glich", gnr="37800", action=ActionType.POTENTIAL, apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.VVVQ})
    public static boolean ar(c c2, Patient patient) {
        return !patient.hasLeistung("37800", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005", c2.c) && (patient.hasDiagnose("U09.9", "G", c2.c) || patient.hasDiagnose("U09.9", "V", c2.c));
    }

    @Rule(name="Basis-Assessment bei Long-Covid (37800) angesetzt ohne abgerechnete Diagnose", gnr="37800", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung("37800", c2.c) && !patient.hasDiagnose("U09.9", "G", c2.c) && !patient.hasDiagnose("U09.9", "V", c2.c);
    }

    @Rule(name="Zuschlag zum Basis-Assessment bei Long-Covid (37801) am Behandlungstag nicht neben 37800 berechnungsf\u00e4hig", gnr="37801", action=ActionType.ENTFERNEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37801", c2.c, date) && patient.hasLeistung("37800", c2.c, date);
    }

    @Rule(name="Zuschlag zum Basis-Assessment bei Long-Covid (37801) nur zweimal im Krankheitsfall abrechenbar", gnr="37801", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean at(c c2, Patient patient) {
        return patient.hasLeistung("37801", c2.c) && patient.getLeistungCount("37801", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Zuschlag zum Basis-Assessment bei Long-Covid (37801) zweimal im Krankheitsfall m\u00f6glich", gnr="37801", action=ActionType.POTENTIAL, apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean au(c c2, Patient patient) {
        return !(patient.getLeistungCount("37801", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) >= 2 || !patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005", c2.c) || !patient.hasDiagnose("U09.9|U10.9|U12.9|G90.80|G93.3|I95.1", "G", c2.c) && !patient.hasDiagnose("U09.9|U10.9|U12.9|G90.80|G93.3|I95.1", "V", c2.c) || !patient.hasDiagnose("U50.40|U50.41|U50.50|U50.51|U51.20|U50.21", "G", c2.c) && !patient.hasDiagnose("U50.40|U50.41|U50.50|U50.51|U51.20|U50.21", "V", c2.c));
    }

    @Rule(name="Zuschlag zum Basis-Assessment bei Long-Covid (37801) angesetzt ohne abgerechnete Diagnose", gnr="37801", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient) {
        return patient.hasLeistung("37801", c2.c) && !patient.hasDiagnose("U09.9|U10.9|U12.9|G90.80|G93.3|I95.1", "G", c2.c) && !patient.hasDiagnose("U09.9|U10.9|U12.9|G90.80|G93.3|I95.1", "V", c2.c) && !patient.hasDiagnose("U50.40|U50.41|U50.50|U50.51|U51.20|U50.21", c2.c);
    }

    @Rule(name="Zuschlag zur Versicherten- oder Grundpauschale bei Long-Covid (37802) am Behandlungstag nicht neben 03220, 04220, 14240, 14313, 14314, 16230, 16231, 16233, 21230, 21231, 21232, 21233, 37100, 37102, 37105, 37113, 37120 berechnungsf\u00e4hig", gnr="37802", action=ActionType.ENTFERNEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37802", c2.c, date) && patient.hasLeistung("37802|03220|04220|14240|14313|14314|16230|16231|16233|21230|21231|21232|21233|37100|37102|37105|37113|37120", c2.c, date);
    }

    @Rule(name="Zuschlag zur Versicherten- oder Grundpauschale bei Long-Covid (37802) nur einmal im Behandlungsfall abrechenbar", gnr="37802", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient) {
        return patient.getLeistungCount("37802", c2.c) > 1;
    }

    @Rule(name="Zuschlag zur Versicherten- oder Grundpauschale bei Long-Covid (37802) angesetzt ohne Long-Covid-Diagnose", gnr="37802", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient) {
        return patient.hasLeistung("37802", c2.c) && !patient.hasDiagnose("U09.9", "G", c2.c) && !patient.hasDiagnose("U09.9", "V", c2.c);
    }

    @Rule(name="Zuschlag zur Versicherten- oder Grundpauschale bei Long-Covid (37802) bei Vorliegen der Ergebnisse des Basis-Assessments entsprechend der GOP 37800 m\u00f6glich", gnr="37802", action=ActionType.POTENTIAL, apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ay(c c2, Patient patient) {
        return !patient.hasLeistung("37802", c2.c) && patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005", c2.c) && (patient.hasDiagnose("U09.9", "G", c2.c) || patient.hasDiagnose("U09.9", "V", c2.c)) && patient.hasLeistung("37800", Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="Zuschlag zur Versicherten- oder Grundpauschale bei Long-Covid (37802) nur neben Versicherten- oder Grundpauschale abrechenbar", gnr="37802", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient) {
        return patient.hasLeistung("37802", c2.c) && !patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005", c2.c);
    }

    @Rule(name="Fallbesprechung f\u00fcr die Versorgung von Patienten mit Long-Covid ({gnr}) am Behandlungstag nicht neben 01442, 01443, 01758, 30210, 30706, 30948, 37120, 37320, 37400, 37720 berechnungsf\u00e4hig", gnr="37804|37804V", action=ActionType.ENTFERNEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date, String string) {
        return patient.hasLeistung(string, c2.c, date) && patient.hasLeistung("01442|01443|01758|30210|30706|30948|37120|37320|37400|37720", c2.c, date);
    }

    @Rule(name="Fallbesprechung f\u00fcr die Versorgung von Patienten mit Long-Covid (37804/37804V) nur f\u00fcnf Mal im Krankheitsfall abrechenbar", gnr="37804/37804V", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aA(c c2, Patient patient) {
        return patient.hasLeistung("37804|37804V", c2.c) && patient.getLeistungCount("37804|37804V", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 5;
    }

    @Rule(name="Fallbesprechung f\u00fcr die Versorgung von Patienten mit Long-Covid (37804/37804V) f\u00fcnf Mal im Krankheitsfall m\u00f6glich", gnr="37804/37804V", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aB(c c2, Patient patient) {
        return patient.getLeistungCount("37804|37804V", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 5 && patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005", c2.c) && (patient.hasDiagnose("U09.9", "G", c2.c) || patient.hasDiagnose("U09.9", "V", c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) am Behandlungstag nicht neben 01442, 01443, 01758, 30210, 30706, 30948, 37120, 37320, 37400, 37720 berechnungsf\u00e4hig", gnr="37806", action=ActionType.ENTFERNEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37806", c2.c, date) && patient.hasLeistung("01442|01443|01758|30210|30706|30948|37120|37320|37400|37720", c2.c, date);
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) nur zwei Mal im Krankheitsfall abrechenbar", gnr="37806", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aC(c c2, Patient patient) {
        return patient.hasLeistung("37806", c2.c) && patient.getLeistungCount("37806", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) zwei Mal im Krankheitsfall m\u00f6glich", gnr="37806", action=ActionType.POTENTIAL, apk=ApkModus.KARDIO_PNEUMO_NEURO)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aD(c c2, Patient patient) {
        if (!c2.a(new g("28", "30", "53"))) {
            return false;
        }
        return !patient.hasLeistung("37806", c2.c) && patient.getLeistungCount("37806", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 2 && patient.hasSchein(ContainerType.UEBERWEISUNG, c2.c) && (patient.hasDiagnose("U09.9", "G", c2.c) || patient.hasDiagnose("U09.9", "V", c2.c));
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) nur einmal im Behandlungsfall abrechenbar", gnr="37806", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient) {
        return patient.getLeistungCount("37806", c2.c) > 1;
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) nur auf \u00dcberweisung des \u00dcberweisung des koordinierenden Arztes", gnr="37806", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aF(c c2, Patient patient) {
        return patient.hasLeistung("37806", c2.c) && !patient.hasSchein(ContainerType.UEBERWEISUNG, c2.c);
    }

    @Rule(name="Pauschale f\u00fcr die Versorgung von Patienten mit Long-Covid (37806) nur durch \u00c4rzte der genannten Fachgruppen abrechenbar", gnr="37806", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ})
    public static ScheinLeistung aG(c c2, Patient patient) {
        List list = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> scheinLeistung.getGnr().startsWith("37806")).filter(scheinLeistung -> !Arrays.asList("28", "30", "53", "58").contains(scheinLeistung.getLanr().substring(7))).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (ScheinLeistung)list.get(0);
    }
}

