/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.f;

import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.PAUSCHALEN)
public class f {
    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Grundpauschale Schmerztherapie 30700 ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn der Patient hat die Krankenkasse gewechselt, dann ist diese Ziffer eventuell mehrmals abrechenbar.", action=ActionType.ENTFERNEN, gnr="30700")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount("30700", c2.c) > 1;
    }

    @Rule(name="Grundpauschale Schmerztherapie (30700) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01436|01953", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date, String string) {
        return patient.hasLeistung(string, c2.c, date) && patient.hasLeistung("30700", c2.c, date);
    }

    @Rule(name="Grundpauschale Schmerztherapie (30700) ist im Behandlungsfall nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01600|01601|03040|03220|03221|03230|04040|04220|04221|04230")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.hasLeistung("30700", c2.c);
    }

    @Rule(name="Grundpauschale Schmerztherapie (30700) ist nicht im selben Arztfall neben einer anderen Grundpauschale abrechenbar", action=ActionType.ENTFERNEN, gnr="03001|03002|03003|03004|03005|04001|04002|04003|04004|04005|05210|05211|05212|06210|06211|06212|07210|07211|07212|08210|08211|08212|09210|09211|09212|10210|10211|10212|11210|11211|11212|12210|12220|12225|13210|13211|13212|13290|13291|13292|13340|13341|13342|13390|13391|13392|13490|13491|13492|13540|13541|13542|13590|13591|13592|13640|13641|13642|13690|13691|13692|14210|14211|15210|15211|15212|16210|16211|16212|17210|18210|18211|18212|19210|19310|20210|20211|20212|21210|21211|21212|22210|22211|22212|23210|23211|23212|23214|24210|24211|24212|25210|25211|25212|26210|26211|26212|27210|27211|27212")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        if (!patient.hasLeistung(string, c2.c) || !patient.hasLeistung("30700", c2.c)) {
            return false;
        }
        return patient.getLeistung(string, 1L, c2.c).getLanr().equals(patient.getLeistung("30700", 1L, c2.c).getLanr());
    }

    @Rule(name="Zuschlag Schmerztherapie (30701) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn der Patient hat die Krankenkasse gewechselt, dann ist diese Ziffer eventuell mehrmals abrechenbar.", action=ActionType.ENTFERNEN, gnr="30701")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.getLeistungCount("30701", c2.c) > 1;
    }

    @Rule(name="Zuschlag Schmerztherapie (30701) ist im Behandlungsfall nicht neben der 01630 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30701")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung("01630", c2.c) && patient.hasLeistung("30701", c2.c);
    }

    @Rule(name="Zusatzpauschale Schmerztherapie (30702) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn der Patient hat die Krankenkasse gewechselt, dann ist diese Ziffer eventuell mehrmals abrechenbar.", action=ActionType.ENTFERNEN, gnr="30702")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.getLeistungCount("30702", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale Schmerztherapie (30702) ist nicht neben speziellen anderen Ziffern am gleichen Tag abrechenbar.", action=ActionType.ENTFERNEN, gnr="03030|04030|05360|30930|30931|30932|30933|35100|35110|35111|35112|35113|35120|35130|35131|35140|35141|35142|35150|35151|35152|35401|35402|35405|35411|35412|35415|35421|35422|35425|35431|35432|35435|35503|35504|35505|35506|35507|35508|35509|35513|35514|35515|35516|35517|35518|35519|35523|35524|35525|35526|35527|35528|35529|35533|35534|35535|35536|35537|35538|35539|35543|35544|35545|35546|35547|35548|35549|35553|35554|35555|35556|35557|35558|35559|35571|35572|35573|35591|35703|35704|35705|35706|35707|35708|35709|35713|35714|35715|35716|35717|35718|35719", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30702", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Zusatzpauschale Schmerztherapie (30702) ist im Behandlungsfall nicht neben speziellen anderen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="01600|01601|03040|03220|03221|04040|04220|04221")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung("30702", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Zusatzpauschale Schmerztherapie (30702) ist als Zuschlag nur im Zusammenhang mit der Grundpauschale Schmerztherapie (30700) abrechenbar.", action=ActionType.NACHTRAGEN, gnr="30700")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung("30702", c2.c) && !patient.hasLeistung("30700", c2.c);
    }

    @Rule(name="Grundpauschale Schmerztherapie (30700) ist meist im Zusammenhang mit der Zusatzpauschale Schmerztherapie (30702) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30702")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return !patient.hasLeistung("30702", c2.c) && patient.hasLeistung("30700", c2.c);
    }

    @Rule(name="Zuschlag Schmerztherapie (30704) ist nur im Zusammenhang mit der Zusatzpauschale (30702) abrechenbar.", action=ActionType.NACHTRAGEN, gnr="30702")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung("30704", c2.c) && !patient.hasLeistung("30702", c2.c);
    }

    @Rule(name="Zuschlag Schmerztherapie (30704) ist nur ein Mal im Behandlungsfall abrechenbar.", action=ActionType.ENTFERNEN, gnr="30704")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount("30704", c2.c) > 1;
    }

    @Rule(name="Zuschlag Schmerztherapie (30704) ist nicht am gleichen Tag wie die Ziffer 05360 abrechenbar.", action=ActionType.ENTFERNEN, gnr="05360", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30704", c2.c, date) && patient.hasLeistung("05360", c2.c, date);
    }

    @Rule(name="Zuschlag Schmerztherapie (30704) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="03040|03220|03221|04040|04220|04221")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung("30704", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Teilnahme an einer schmerztherapeutischen Fallkonferenz (30706) am Behandlungstag nicht neben der 01442 abrechenbar", action=ActionType.ENTFERNEN, gnr="01442", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01442", c2.c, date) && patient.hasLeistung("30706", c2.c, date);
    }

    @Rule(name="Teilnahme an einer schmerztherapeutischen Fallkonferenz (30706) nur neben der 30700 abrechenbar", action=ActionType.NACHTRAGEN, gnr="30700")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung("30706", c2.c) && !patient.hasLeistung("30700", c2.c);
    }

    @Rule(name="Teilnahme an einer schmerztherapeutischen Fallkonferenz (30706) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220, 04221 oder 37320 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30706")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung("30706", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221|37320", c2.c);
    }

    @Rule(name="Beratung und Er\u00f6rterung und/oder Abkl\u00e4rung im Rahmen der Schmerztherapie (30708) ist nur in Behandlungsf\u00e4llen abrechenbar, in welchen auch die 30700 zur Abrechnung kam.", action=ActionType.NACHTRAGEN, gnr="30700")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung("30708", c2.c) && !patient.hasLeistung("30700", c2.c);
    }

    @Rule(name="Beratung und Er\u00f6rterung und/oder Abkl\u00e4rung im Rahmen der Schmerztherapie (30708) eventuell beim zweiten Arzt-Patienten-Kontakt und 10 Minuten Gespr\u00e4chszeit abrechenbar.", action=ActionType.NACHTRAGEN, gnr="30708")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return !patient.hasLeistung("30708", c2.c) && patient.hasLeistung("30700", c2.c) && patient.getAPKCount(true, c2.c, scheinLeistung -> scheinLeistung.getLanr().equals(patient.getLeistung("30700", 1L, c2.c).getLanr())) > 1L;
    }

    @Rule(name="Beratung und Er\u00f6rterung und/oder Abkl\u00e4rung im Rahmen der Schmerztherapie (30708) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30708", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30708", c2.c, date) && patient.hasLeistung("01440|01511|01512|01520|01521|01530|01531|01856|02100|02101|05320|05330|05331|05340|05341|05350|05372|31820|31821|31822|31823|31824|31825|31826|31827|31828|31840|31841|36820|36821|36822|36823|36824|36825|36826|36827|36828|36829|36840|36841", c2.c, date);
    }

    @Rule(name="Beratung und Er\u00f6rterung und/oder Abkl\u00e4rung im Rahmen der Schmerztherapie (30708) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30708")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung("30708", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Infusion mit Bet\u00e4ubungsmitteln (30710) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30710", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30710", c2.c, date) && patient.hasLeistung("01910|01911|02100|05360|05372|34503|34504|34505|05310|05315|05320|05330|05331|05340|05341|05350|31800|31801|31802|31820|31821|31822|31823|31824|31825|31826|31827|31828|31840|31841|36800|36801|36802|36820|36821|36822|36823|36824|36825|36826|36827|36828|36829|36840|36841", c2.c, date);
    }

    @Rule(name="Infusion mit Bet\u00e4ubungsmitteln (30710) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30710")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung("30710", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Anleitung Selbstanwendung der transkutanen elektrischen Nervenstimulation (TENS) (30712) ist h\u00f6chstens 5 Mal im Krankheitsfall abrechenbar.", action=ActionType.ENTFERNEN, gnr="30712")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung("30712", c2.c) && patient.getLeistungCount("30712", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 5;
    }

    @Rule(name="Anleitung Selbstanwendung der transkutanen elektrischen Nervenstimulation (TENS) (30712) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30712", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30712", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Anleitung Selbstanwendung der transkutanen elektrischen Nervenstimulation (TENS) (30712) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30712")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung("30712", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Analgesie eines Hirnnerven oder eines Hirnnervenganglions (30720) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30720", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30720", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Analgesie eines Hirnnerven oder eines Hirnnervenganglions (30720) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30720")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung("30720", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Sympathikusblockade (Injektion) am zervikalen Grenzstrang (30721) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30721", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30721", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Sympathikusblockade (Injektion) am zervikalen Grenzstrang (30721) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30721")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung("30721", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Sympathikusblockade (Injektion) am thorakalen oder lumbalen Grenzstrang (30722) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30722", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30722", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Sympathikusblockade (Injektion) am thorakalen oder lumbalen Grenzstrang (30722) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30722")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung("30722", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Ganglion\u00e4re Opioid-Applikation (30723) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30723", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30723", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Ganglion\u00e4re Opioid-Applikation (30723) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30723")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung("30723", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Analgesie eines oder mehrerer Spinalnerven und der Rami communicantes an den Foramina intervertebralia (30724) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30724", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30724", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Analgesie eines oder mehrerer Spinalnerven und der Rami communicantes an den Foramina intervertebralia (30724) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30724")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung("30724", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Intraven\u00f6se regionale Sympathikusblockade in Blutleere (30730) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30730", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Intraven\u00f6se regionale Sympathikusblockade in Blutleere (30730) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="03040|03220|03221|04040|04220|04221")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung("30730", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Plexusanalgesie, Spinal- oder Periduralanalgesie (30731) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("30731", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Plexusanalgesie, Spinal- oder Periduralanalgesie (30731) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="03040|03220|03221|04040|04220|04221")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.hasLeistung("30731", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="\u00dcberpr\u00fcfung Langzeitanalgesie angelegten Plexus-, Peridural oder Spinalkatheters oder programmierbaren Stimulationsger\u00e4tes (30740) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30740", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30740", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="\u00dcberpr\u00fcfung Langzeitanalgesie angelegten Plexus-, Peridural oder Spinalkatheters oder programmierbaren Stimulationsger\u00e4tes (30740) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30740")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung("30740", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Erstprogrammierung einer externen Medikamentenpumpe zur Langzeitanalgesie (30750) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30750", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30750", c2.c, date) && patient.hasLeistung("02101|02120|05360", c2.c, date);
    }

    @Rule(name="Erstprogrammierung einer externen Medikamentenpumpe zur Langzeitanalgesie (30750) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30750")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung("30750", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Langzeitanalgospasmolyse (30751) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30751", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30751", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Langzeitanalgospasmolyse (30751) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30751")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung("30751", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Dokumentierte \u00dcberwachung im Anschluss an die Geb\u00fchrenordnungsposition 30710, 30721, 30722, 30724 oder 30730 (30760) ist nicht am gleichen Tag neben anderen speziellen Ziffern abrechenbar.", action=ActionType.ENTFERNEN, gnr="30760", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung("30760", c2.c, date) && patient.hasLeistung("02101|05360|05372|31840|31841|34503|34504|34505|36840|36841|05310|05315|05320|05330|05331|05340|05341|05350", c2.c, date);
    }

    @Rule(name="Dokumentierte \u00dcberwachung im Anschluss an die Geb\u00fchrenordnungsposition 30710, 30721, 30722, 30724 oder 30730 (30760) ist im Behandlungsfall nicht neben den Ziffern 03040, 03220, 03221, 04040, 04220 oder 04221 abrechenbar.", action=ActionType.ENTFERNEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung("30760", c2.c) && patient.hasLeistung("03040|03220|03221|04040|04220|04221", c2.c);
    }

    @Rule(name="Schmerztherapeutische Patienten ben\u00f6tigen in den meisten F\u00e4llen eine schmerztherapeutische Diagnose F45.41 oder R52.2 (gesichert)", action=ActionType.UEBERPRUEFEN, gnr="30700|30702|30704|30705|30706|30706V|30708|30708V|30780|30780V|30781|30710|30720|30721|30722|30723|30724|30730|30731|30740|30750|30751|30760|30790|30791")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnose("F45.41|R52.2", true, c2.c);
    }

    @Rule(name="Infusion mit Bet\u00e4ubungsmitteln (30710) ist jeweils im Zusammenhang mit einer \u00dcberwachung (30760) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung("30710", c2.c) && !patient.hasLeistung("30760", c2.c);
    }

    @Rule(name="Sympathikusblockade (Injektion) am zervikalen Grenzstrang (30721) ist jeweils im Zusammenhang mit einer \u00dcberwachung (30760) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung("30721", c2.c) && !patient.hasLeistung("30760", c2.c);
    }

    @Rule(name="Sympathikusblockade (Injektion) am thorakalen oder lumbalen Grenzstrang (30722) ist jeweils im Zusammenhang mit einer \u00dcberwachung (30760) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung("30722", c2.c) && !patient.hasLeistung("30760", c2.c);
    }

    @Rule(name="Analgesie eines oder mehrerer Spinalnerven und der Rami communicantes an den Foramina intervertebralia (30724) ist jeweils im Zusammenhang mit einer \u00dcberwachung (30760) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung("30724", c2.c) && !patient.hasLeistung("30760", c2.c);
    }

    @Rule(name="Intraven\u00f6se regionale Sympathikusblockade in Blutleere (30730) ist jeweils im Zusammenhang mit einer \u00dcberwachung (30760) abzurechnen.", action=ActionType.NACHTRAGEN, gnr="30760")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung("30730", c2.c) && !patient.hasLeistung("30760", c2.c);
    }

    @Rule(name="Neben der \u00dcberwachung (30760) sollte mindestens eine der folgenden Leistungen abgerechnet werden 30710, 30721, 30722, 30724 oder 30730.", action=ActionType.NACHTRAGEN, gnr="30710/30721/30722/30724/30730")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung("30760", c2.c) && !patient.hasLeistung("30710|30721|30722|30724|30730", c2.c);
    }

    @Rule(name="Zustand nach Organ- oder Gewebetransplantation (Z94.-) ohne entsprechende Diagnosesicherheit", action=ActionType.UEBERPRUEFEN, gnr="Z94")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (patient.hasDiagnoseBeginntMit("Z94", c2.c) && !patient.hasDiagnoseBeginntMit("Z94", "G", c2.c)) {
            if (patient.getAPK(false, c2.c, 1L) != null) {
                action.setAPK(patient.getAPK(false, c2.c, 1L));
            }
            return true;
        }
        return false;
    }

    @Rule(name="Interstitielle LDR-Brachytherapie mit permanenter Seed-Implantation zur Behandlung von Patienten mit lokal begrenztem Prostatakarzinom (25335) am Behandlungstag nicht neben der 25336 abrechenbar", action=ActionType.ENTFERNEN, gnr="25336", daily=true, apk=ApkModus.UROLOGIE_STRAHLENTHERAPIE)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung("25335 ", c2.c, date) && patient.hasLeistung("25336", c2.c, date);
    }

    @Rule(name="Interstitielle LDR-Brachytherapie mit permanenter Seed-Implantation zur Behandlung von Patienten mit lokal begrenztem Prostatakarzinom (25335) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="25335", apk=ApkModus.UROLOGIE_STRAHLENTHERAPIE)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung("25335", c2.c) && patient.getLeistungCount("25335", c2.c, c2.d, c2.e, c2.f) > 1;
    }

    @Rule(name="Postimplantationskontrolle und Nachplanung zur interstitiellen LDR-Brachytherapie mit permanenter Seed-Implantation zur Behandlung von Patienten mit lokal begrenztem Prostatakarzinom (25336) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="25336", apk=ApkModus.UROLOGIE_STRAHLENTHERAPIE)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung("25336", c2.c) && patient.getLeistungCount("25336", c2.c, c2.d, c2.e, c2.f) > 1;
    }

    @Rule(name="Geb\u00fchrenordnungsposition f\u00fcr die Mehrfertigung (z. B. Kopie) eines Berichtes oder Briefes (01602) nur ein Mal am Behandlungstag abrechenbar.", action=ActionType.ENTFERNEN, gnr="01602", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("01602", c2.c, date) > 1;
    }

    @Rule(name="Zusatzpauschale zu den Versicherten-, Grund- und Konsiliarpauschalen sowie zur 01320, 01321, 30700 im Zusammenhang mit der elektronischen Patientenakte (01647) im Behandlungsfall nicht neben 01648 abrechenbar", action=ActionType.ENTFERNEN, gnr="01647")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung("01647", c2.c) && patient.hasLeistung("01648", c2.c) && patient.hasLeistung("01320|01321|30700", c2.c);
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der digitalen Gesundheitsanwendung (DiGA) Vivira (01472) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01472")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.getLeistungCount("01472", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der digitalen Gesundheitsanwendung (DiGA) Vivira (01472) h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01472")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung("01472", c2.c) && patient.getLeistungCount("01472", c2.c, c2.d, c2.e, c2.f) > 2;
    }

    @Rule(name="Fallbesprechung mit dem Jugendamt im Rahmen von Kooperationsvereinbarungen zum Kinder- und Jugendschutz (01682) h\u00f6chstens 8 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01682")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("01682", c2.c) && patient.getLeistungBeginntMitCount("01682", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 8;
    }

    @Rule(name="Meldung von Anhaltspunkten einer m\u00f6glichen Kindeswohlgef\u00e4hrdung an das Jugendamt im Rahmen des Kinder- und Jugendschutzes (01681) nur 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01681")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.getLeistungCount("01681", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der DiGA elona therapy Depression (01479|01479V) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01479/01479V")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung("01479|01479V", c2.c) && patient.getLeistungCount("01479|01479V", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der DiGA elona therapy Depression (01479|01479V) nur 2 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01479/01479V")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung("01479|01479V", c2.c) && patient.getLeistungCount("01479|01479V", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der DiGA elona therapy Depression (01479|01479V) ist nur zwischen 18 und 65 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01479/01479V", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01479|01479V", c2.c, date) && (patient.getAlterAnTag(date) < 18 || patient.getAlterAnTag(date) > 65);
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der DiGA elona therapy Depression (01479|01479V) bis zu 2 Mal im Krankheitsfall abrechenbar", action=ActionType.POTENTIAL, gnr="01479/01479V")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient, Action action) {
        if (patient.hasLeistung("01479|01479V", c2.c)) {
            return false;
        }
        if (patient.getLeistungCount("01479|01479V", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1) {
            return false;
        }
        if (patient.getAlterAnTag(new Date()) < 18 || patient.getAlterAnTag(new Date()) > 65) {
            return false;
        }
        APK aPK = patient.getAPK(true, c2.c, 1L, new g("58", "51", "47", "60"));
        if (aPK != null) {
            action.setAPK(aPK);
            return true;
        }
        return false;
    }
}

