/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.a.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class m {
    private static final String a = "100171007|100175502|100177504|100186801|100189405|100571001|100575506|100577508|100586805|100589409|100971005|100975500|100977502|100986809|100989403|101300130|101302655|101371001|101375506|101377508|101386805|101389409|101520363|101520900|101570104|101571003|101575508|101575519|101576598|101576623|101577500|101578603|101586807|101589310|101589401|101771005|101775500|101777502|101786809|101789403|102171012|102171023|102171432|102171864|102400510|102800499|103071002|103075507|103077509|103086806|103089400|103170002|103471006|103475501|103477503|103486800|103489404|104071004|104075509|104077501|104086808|104089402|104621748|104625695|105071007|105075502|105077504|105086801|105089405|105171008|105175503|105177505|105186802|105189406|106271001|106275506|106277508|106286805|106289409|106371002|106375507|106377509|106386806|106389400|106471003|106475508|106477500|106486807|106489401|106571004|106575509|106577501|106586808|106589402|106771006|106775501|106777503|106786800|106789404|107271003|107275508|107277500|107286807|107289401|107371004|107375509|107377501|107386808|107389402|107871009|107875504|107877506|107886803|107889407|108071003|108075508|108077500|108086807|108089401|108371006|108375501|108377013|108377503|108386800|108389404|108429333|108429344|108429355|108429366|108432429|108433135|108433146|108433157|108433168|108433179|108433692|108434329|108434363|108537276|108734300|108734333|109023665|109371008|109375503|109377505|109386802|109389406|109530885|109530896|109530998|109571000|109575505|109577006|109577507|109586804|109589408|109720750|109771002|109775507|109777509|109786806|109789400";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Baden-W\u00fcrttemberg");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_TK);
    }

    @Rule(name="HzV TK Behandlungspauschale 0000 nur durch einen Arzt in der gleichen Betriebsst\u00e4tte abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BUNDESWEIT_TK.gnr("0000").equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet()).size() > 1;
    }

    @Rule(name="HzV TK Chronikerpauschale (0003) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV TK Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV TK Chronikerpauschale (0003) nur neben der Behandlungspauschale (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV TK Chronikerpauschale (0003) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV TK gesicherte Diagnose zu Chronikerpauschale (0003) in Vorquartalen vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, Arrays.asList(c2.d, c2.e)) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV TK Chronikerpauschale (0003) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV TK Pflegeheimpauschale (0008) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV TK Pflegeheimpauschale (0008) nur mit einem Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV TK Arzt-Patienten-Kontakt ohne Pflegeheimpauschale (0008), Pflegeheimpauschale im Vorquartal vorhanden", action=ActionType.NACHTRAGEN, gnr="0008", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean k(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0008"), c2.d) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0008"), c2.c);
    }

    @Rule(name="HzV TK Pflegeheimpauschale (0008) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0008"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr(string), c2.c);
    }

    @Rule(name="HzV TK Vertreterpauschale (0004) muss nicht \u00f6fter als ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV TK Vertreterpauschale (0004) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV TK Vertreterpauschale (0004) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV TK Zielauftrag (0005) nicht neben der 0000 innerhalb der gleichen BAG, MVZ abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV TK Zielauftragspauschale (0005) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV TK Gesundheitsvorsorgeuntersuchung (01732) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV TK Gesundheitsvorsorgeuntersuchung (01732) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV TK Gesundheitsvorsorgeuntersuchung (01732) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV TK Gesundheitsvorsorgeuntersuchung (01732) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("01732"), c2.c) > 1;
    }

    @Rule(name="HzV TK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean s(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV TK Krebsvorsorge Mann (01731) erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV TK Krebsvorsorge Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV TK Hautkrebsscreening ab 35 Jahren (01745) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean u(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV TK Hautkrebsscreening (01745) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01745"), c2.c) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV TK unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01100"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV TK unvorhergesehene Inanspruchnahme I (01100) nur in begr\u00fcndeten Ausnahmef\u00e4llen mehrfach am gleichen Tag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV TK unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("01101"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV TK unvorhergesehene Inanspruchnahme II (01101) nur in begr\u00fcndeten Ausnahmef\u00e4llen mehrfach am gleichen Tag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV TK kleinchirurgischer Eingriff I (02300) am Behandlungstag nicht neben anderen kleinchirurgischen Eingriffen (02301, 02302) abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("02300"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("02301|02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV TK kleinchirurgischer Eingriff I (02300) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("02300"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV TK kleinchirurgischen Eingriffe (02300, 02301, 02302) am Behandlungstag bei Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*) zusammen nicht \u00f6fter als 5 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("02300|02301|02302"), c2.c, date) > 5;
    }

    @Rule(name="HzV TK kleinchirurgischer Eingriff II (02301) am Behandlungstag nicht neben anderen kleinchirurgischen Eingriffen (02300, 02302) abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02301", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("02301"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV TK kleinchirurgischer Eingriff II (02301) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02301", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("02301"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV TK kleinchirurgischer Eingriff III (02302) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02302", hzv=Hzv.BUNDESWEIT_TK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_TK.gnr("02302"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV TK {gnr} bei HzV Patienten nicht auf KV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="01611|01731|01732|01745|02300|02301|02302|03220|03221|03360|03362|03321|33012|33042|35100|35110|01100|01101|89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89102V|89102W|89102X|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89105V|89105W|89105X|89106A|89106B|89107A|89107B|89107R|89107V|89107W|89107X|89108A|89108B|89108R|89110A|89110B|89111|89112|89112Y|89113|89113A|89113B|89113V|89113W|89114|89115A|89115B|89115R|89115V|89115W|89115X|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89120V|89120X|89121A|89121B|89121R|89122A|89122B|89122R|89122V|89122W|89122X|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89126V|89126W|89127A|89127B|89128A|89128B|89129A|89129B|89130V|89130W|89130X|89131A|89131B|89131R|89131Y|89132V|89132W|89132X|89133Y|89133V|89133W|89134V|89134W|89134X|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89202V|89202W|89202X|89203A|89203B|89300A|89300B|89301A|89301B|89301V|89301W|89302|89302R|89303|89303R|89303Y|89400|89400R|89401A|89401B|89401V|89401W|89500A|89500B|89600A|89600B", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV TK abdominelle Sonographie (33042) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("33042"), c2.c) > 1;
    }

    @Rule(name="HzV TK \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur ein Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("HIPST"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV TK \u00dcberpr\u00fcfung des Impfstatus (HIPST) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="HIPST", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean x(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV TK \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("HIPST"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV TK KV-Schein Pseudoziffer (88192, 88194) ohne HzV-Schein Betreuungspauschale (0000, 0004)", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static String z(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192|88194", c2.c)) {
            if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV TK Kennzeichnungsziffer {gnr} nur im KV-Schein abrechenbar, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192|88194", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr(string), c2.c);
    }

    @Rule(name="HzV TK lebenslange Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000/0004", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000|0004"), c2.c) || !patient.hasLeistung("88192|88194", c2.c)) {
            return false;
        }
        return !patient.getLeistung(Hzv.BUNDESWEIT_TK.gnr("0000|0004"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192|88194", 1L, c2.c).getLanr());
    }

    @Rule(name="HzV TK Doppelabrechnung von Betreuungspauschale (0000, 0004) im HzV-Schein und Versichertenpauschale (0300*) im KV-Schein ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV TK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr(string), c2.c);
    }

    @Rule(name="HzV TK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV TK Modul Diabetesleber (56609) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="56609", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean C(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56609"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV TK Modul Diabetesleber (56609) im Behandlungsfall nicht neben Modul Diabetesleber Nachsorge (56610) abrechenbar", action=ActionType.ENTFERNEN, gnr="56610", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56609"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56610"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetesleber (56609) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56609", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56609"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetesleber Nachsorge (56610) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56610", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56610"), c2.c) > 1;
    }

    @Rule(name="HzV TK Modul Diabetesleber Nachsorge (56610) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung Diabetesleber (56609) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56610", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean G(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56610"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56609"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56609"), Arrays.asList(c2.d, c2.e, c2.f, c2.g)) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56610"), Arrays.asList(c2.d, c2.e, c2.f)) < 2;
    }

    @Rule(name="HzV TK Modul LUTS (56611) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="56611", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56611"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56611"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV TK Modul LUTS (56611) im Behandlungsfall nicht neben Modul LUTS Nachsorge (56612) abrechenbar", action=ActionType.ENTFERNEN, gnr="56611", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56612"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56611"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56611"), Arrays.asList(c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV TK Modul LUTS Nachsorge (56612) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56612", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56612"), c2.c) > 1;
    }

    @Rule(name="HzV TK Modul LUTS Nachsorge (56612) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung LUTS (56611) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56612", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean K(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56612"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56611"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56612"), Arrays.asList(c2.d, c2.e, c2.f)) < 2;
    }

    @Rule(name="HzV TK Modul LUTS Nachsorge (56612) h\u00f6chstens 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung LUTS (56611) abrechenbar", action=ActionType.ENTFERNEN, gnr="56612", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56612"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56612"), Arrays.asList(c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie (56613) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="56613", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean M(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56613"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie (56613) im Behandlungsfall nicht neben Modul Diabetische Neuropathie Nachsorge (56614) abrechenbar", action=ActionType.ENTFERNEN, gnr="56614", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56613"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56614"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie Nachsorge (56614) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56614", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56614"), c2.c) > 1;
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie Nachsorge (56614) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung Diabetische Neuropathie (56613) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56614", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean P(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56614"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56613"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56614"), Arrays.asList(c2.d, c2.e, c2.f)) < 2;
    }

    @Rule(name="HzV TK Modul pAVK (56615) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="56615", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Q(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56615"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV TK Modul pAVK (56615) im Behandlungsfall nicht neben Modul pAVK Nachsorge (56616) abrechenbar", action=ActionType.ENTFERNEN, gnr="56616", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56615"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56616"), c2.c);
    }

    @Rule(name="HzV TK Modul pAVK Nachsorge (56616) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56616", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56616"), c2.c) > 1;
    }

    @Rule(name="HzV TK Modul pAVK Nachsorge (56616) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung pAVK (56615) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56616", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean T(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56616"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56615"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56616"), Arrays.asList(c2.d, c2.e, c2.f)) < 2;
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit (56617) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="56617", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean U(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56617"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit (56617) im Behandlungsfall nicht neben Modul Chronische Nierenkrankheit Nachsorge (56618) abrechenbar", action=ActionType.ENTFERNEN, gnr="56618", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56617"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56618"), c2.c);
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit Nachsorge (56618) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56618", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56618"), c2.c) > 1;
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit Nachsorge (56618) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung Chronische Nierenkrankheit (56617) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56618", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean X(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56618"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56617"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) && patient.getLeistungCount(Hzv.BUNDESWEIT_TK.gnr("56618"), Arrays.asList(c2.d, c2.e, c2.f)) < 2;
    }

    @Rule(name="HzV TK Modul Diabetesleber Nachsorge (56610) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56610", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56610"), c2.c);
    }

    @Rule(name="HzV TK Modul LUTS (56611) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56611", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56611"), c2.c);
    }

    @Rule(name="HzV TK Modul LUTS Nachsorge (56612) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56612", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56612"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie (56613) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56613", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56613"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetische Neuropathie Nachsorge (56614) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56614", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ac(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56614"), c2.c);
    }

    @Rule(name="HzV TK Modul pAVK (56615) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56615", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56615"), c2.c);
    }

    @Rule(name="HzV TK Modul pAVK Nachsorge (56616) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56616", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56616"), c2.c);
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit (56617) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56617", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56617"), c2.c);
    }

    @Rule(name="HzV TK Modul Chronische Nierenkrankheit Nachsorge (56618) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="56618", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56618"), c2.c);
    }

    @Rule(name="HzV TK Modul Diabetesleber (56609) m\u00f6glich, da entsprechende gesicherte Diagnose vorhanden ist", action=ActionType.POTENTIAL, gnr="56609", hzv=Hzv.BUNDESWEIT_TK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean ah(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("56609"), c2.c)) {
            return false;
        }
        if (patient.hasDiagnose("K77.8", "G", Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g))) {
            return false;
        }
        return patient.hasDiagnoseBeginntMit("E10|E11|E12|E13|E14", "G", Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_TK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

