/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.a.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class l {
    private static final String a = "100609049|102108731|103708751|103708773|104208769|105208795|105508787|105508890|106408802|106908874|108008880|108508863|108608820|108609148|108808844|108809059|109008837|109108850|109308818";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Baden-W\u00fcrttemberg");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BW_LKK);
    }

    @Rule(name="HzV LKK Behandlungspauschale 0000 nur durch einen Arzt in der gleichen Betriebsst\u00e4tte abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BW_LKK.gnr("0000").equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet()).size() > 1;
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_LKK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) nur neben der Behandlungspauschale (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Diagnose zu Chronikerpauschale (0003) im Vorquartal vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, Arrays.asList(c2.d, c2.e)) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Vertreterpauschale (0004) muss nicht \u00f6fter als ein Mal im Quartal abgerechnet werden", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_LKK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Vertreterpauschale (0004) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BW_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Zielauftrag (0005) nicht neben der 0000 innerhalb der gleichen BAG, MVZ abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BW_LKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_LKK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) nur mit einem Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Arzt-Patienten-Kontakt ohne Pflegeheimpauschale (0008), Pflegeheimpauschale im Vorquartal vorhanden", action=ActionType.NACHTRAGEN, gnr="0008", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean m(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0008"), c2.d) && patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("0008"), c2.c);
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung (01732) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung (01732) jedes Kalenderjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean o(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung (01732) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung (01732) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BW_LKK.gnr("01732"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK j\u00e4hrlicher erweiterter Gesundheits-Check-Up (01732) ohne entsprechende gesicherte Vorsorgediagnose (Z00.0)", action=ActionType.UEBERPRUEFEN, gnr="01732", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), c2.c) && !patient.hasDiagnose("Z00.0", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Vorsorgediagnose \u00e4rztliche Allgemeinuntersuchung bei Personen ohne Beschwerden oder angegebene Diagnosen, \u00c4rztliche Allgemeinuntersuchung, Check up (Z00.0) ohne j\u00e4hrlicher erweiterter Gesundheits-Check-Up (01732)", action=ActionType.UEBERPRUEFEN, gnr="01732", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01732"), c2.c) && patient.hasDiagnose("Z00.0", true, c2.c);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7 (01717) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01717"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 19 && patient.getAlterInMonate() < 28;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7a (01723) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01723"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 32 && patient.getAlterInMonate() < 39;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U8 (01718) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01718"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 42 && patient.getAlterInMonate() < 51;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U9 (01719) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInMonate() > 57 && patient.getAlterInMonate() < 67;
    }

    @Rule(name="HzV LKK Jugendvorsorgeuntersuchung J1 (01720) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="HzV LKK U-Untersuchung ({gnr}) ohne entsprechende gesicherte Vorsorgediagnose (Z00.1)", action=ActionType.UEBERPRUEFEN, gnr="01717|01718|01719|01723", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV LKK J-Untersuchung (01720) ohne entsprechende gesicherte Vorsorgediagnose (Z00.3)", action=ActionType.UEBERPRUEFEN, gnr="01720", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01720"), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte U-Vorsorgediagnose (Z00.1) ohne Abrechnungsziffer U-Untersuchung (01717, 01718, 01719, 01723)", gnr="01717/01718/01719/01723", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01717|01718|01719|01723"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte J-Vorsorgediagnose (Z00.3) ohne Abrechnungsziffer J-Untersuchung (01720)", gnr="01720", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01720"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7 (01717) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01717"), c2.c, date) && (patient.getAlterInMonate(date) < 19 || patient.getAlterInMonate(date) > 28);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7a (01723) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01723"), c2.c, date) && (patient.getAlterInMonate(date) < 32 || patient.getAlterInMonate(date) > 39);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U8 (01718) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01718"), c2.c, date) && (patient.getAlterInMonate(date) < 42 || patient.getAlterInMonate(date) > 51);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U9 (01719) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01719"), c2.c, date) && (patient.getAlterInMonate(date) < 57 || patient.getAlterInMonate(date) > 67);
    }

    @Rule(name="HzV LKK Jugendvorsorgeuntersuchung J1 (01720) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BW_LKK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01720"), c2.c, date) && (patient.getAlterAnTag(date) < 12 || patient.getAlterAnTag(date) > 15);
    }

    @Rule(name="HzV LKK Influenza-Impfung (89111) ohne entsprechende gesicherte Impfdiagnose (Z25.1)", action=ActionType.UEBERPRUEFEN, gnr="89111", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("89111"), c2.c) && !patient.hasDiagnose("Z25.1", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Impfdiagnose (Z25.1) ohne Influenza-Impfung (89111)", action=ActionType.UEBERPRUEFEN, gnr="89111", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("89111"), c2.c) && patient.hasDiagnose("Z25.1", true, c2.c);
    }

    @Rule(name="HzV LKK Masern-Mumps-R\u00f6teln-Impfung (89301B) ohne entsprechende gesicherte Impfdiagnose (Z27.4)", action=ActionType.UEBERPRUEFEN, gnr="89301B", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("89301B"), c2.c) && !patient.hasDiagnose("Z27.4", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Impfdiagnose (Z27.4) ohne Masern-Mumps-R\u00f6teln-Impfung (89301B)", action=ActionType.UEBERPRUEFEN, gnr="89301B", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("89301B"), c2.c) && patient.hasDiagnose("Z27.4", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte palliative Diagnose Z51.5 im Vorquartal vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasDiagnose("Z51.5", true, c2.d);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01100"), c2.c, date) && patient.hasLeistung(Hzv.BW_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme I (01100) nur in begr\u00fcndeten Ausnahmef\u00e4llen \u00f6fter als ein Mal am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_LKK.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01101"), c2.c, date) && patient.hasLeistung(Hzv.BW_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme II (01101) nur in begr\u00fcndeten Ausnahmef\u00e4llen \u00f6fter als ein Mal am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_LKK.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean F(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BW_LKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) ohne entsprechende gesicherte Diagnose (Z12.5)", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Vorsorgediagnose spezielle Verfahren zur Untersuchung auf Neubildung der Prostata (Z12.5) ohne Krebsvorsorge Mann (01731)", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01731"), c2.c) && patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV LKK Hautkrebsscreening ab 35 Jahren (01745) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean K(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) nur einmal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BW_LKK.gnr("01745"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) sollte nicht durch Vertreterarzt abgerechnet werden", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) ohne entsprechende gesicherte Diagnose (Z12.8)", action=ActionType.UEBERPRUEFEN, gnr="01745", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), c2.c) && !patient.hasDiagnose("Z12.8", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Vorsorgediagnose spezielle Verfahren zur Untersuchung auf Neubildungen sonstiger Lokalisationen (Z12.8) ohne Hautkrebsscreening (01745)", action=ActionType.UEBERPRUEFEN, gnr="01745", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("01745"), c2.c) && patient.hasDiagnose("Z12.8", true, c2.c);
    }

    @Rule(name="HzV LKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur neben Arzt-Patienten-Kontakt (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("56092"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_LKK.gnr("56092"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) in Vorquartalen vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean S(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_LKK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr("56092"), Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="HzV LKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("56092"), c2.c) && !patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) && !patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c);
    }

    @Rule(name="HzV LKK KV-Schein Pseudoziffer (88192, 88194) ohne HzV-Schein Betreuungspauschale (0000, 0004)", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static String U(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_LKK.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192|88194", c2.c)) {
            if (patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BW_LKK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV LKK Kennzeichnungsziffer {gnr} nur im KV-Schein abrechenbar, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192|88194", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK lebenslange Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000/0004", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_LKK.gnr("0000|0004"), c2.c) || !patient.hasLeistung("88192|88194", c2.c)) {
            return false;
        }
        return !patient.getLeistung(Hzv.BW_LKK.gnr("0000|0004"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192|88194", 1L, c2.c).getLanr());
    }

    @Rule(name="HzV LKK Doppelabrechnung von Betreuungspauschale (0000, 0004) im HzV-Schein und Versichertenpauschale (0300*) im KV-Schein ausgeschlossen", action=ActionType.ENTFERNEN, gnr="03000")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV LKK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32880|32881|32882", hzv=Hzv.BW_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32880|32881|32882")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV LKK {gnr} bei HzV Patienten nicht auf KV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="01100|01101|01731|01732|01745|03220|03221|03360|03362|89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89102V|89102W|89102X|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89105V|89105W|89105X|89106A|89106B|89107A|89107B|89107R|89107V|89107W|89107X|89108A|89108B|89108R|89110A|89110B|89111|89112|89112Y|89113|89113A|89113B|89113V|89113W|89114|89115A|89115B|89115R|89115V|89115W|89115X|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89120V|89120X|89121A|89121B|89121R|89122A|89122B|89122R|89122V|89122W|89122X|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89126V|89126W|89127A|89127B|89128A|89128B|89129A|89129B|89130V|89130W|89130X|89131A|89131B|89131R|89131Y|89132V|89132W|89132X|89133Y|89133V|89133W|89134V|89134W|89134X|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89202V|89202W|89202X|89203A|89203B|89300A|89300B|89301A|89301B|89301V|89301W|89302|89302R|89303|89303R|89303Y|89400|89400R|89401A|89401B|89401V|89401W|89500A|89500B|89600A|89600B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BW_LKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BW_LKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

