/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.a.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class d {
    private static final String a = "106818216|106818249|106818261|106918228|106918251|107018414|107018425|107018436|107118233|107118277|107310306|107415507|107415518|107415541|107415596|107515520|107515564|107515575|107515586|107615532|107615554|107815705|107815716|107815727|107815738|107815749|107815750|107815761|107815772|107815783|107815794|107815807|108018007|108018110|108018121|108018132|108018325|108018336|108018347|108018358|108018369|108018519|108018520|108018531|108018542|108018553|108018564";
    private static final Map<String, String> b = new HashMap<String, String>();

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Baden-W\u00fcrttemberg");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BW_AOK);
    }

    @Rule(name="HzV AOK Behandlungspauschale 0000 nur durch einen Arzt in der gleichen Betriebsst\u00e4tte abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BW_AOK.gnr("0000").equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet()).size() > 1;
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) nur mit einem pers\u00f6nlichem/telemed. Hausarzt-Patienten-Kontakt (Kennzeichnung 0000|0000F) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0000F"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Diagnose zu Chronikerpauschale (0003) in Vorquartalen vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, Arrays.asList(c2.d, c2.e)) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="56544", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56544"), c2.c) && patient.getDiagnoseClusterCount(c2.c, b) > 2;
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) ben\u00f6tigt mindestens drei verschiedene gesicherte Grunderkrankungen", action=ActionType.UEBERPRUEFEN, gnr="56544", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56544"), c2.c) && patient.getDiagnoseClusterCount(c2.c, b) < 3;
    }

    @Rule(name="HzV AOK gesicherte Diagnose zu Versorgungsleistung Multimorbidit\u00e4t (56544) im Vorquartal vorhanden, im aktuellen Quartal unvollst\u00e4ndig", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.getDiagnoseClusterCount(c2.c, b) < 3 && patient.getDiagnoseClusterCount(c2.d, b) > 2;
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) nur mit pers\u00f6nlichem/telemedizin. Hausarzt-Patienten-Kontakt (Kennzeichnung 0000|0000F) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56544", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56544"), c2.c, date) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0000F"), c2.c, date);
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56544", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("56544"), c2.c) > 2;
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="56544", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_AOK.gnr("56544"), c2.c, date) > 1;
    }

    @Rule(name="HzV AOK Versorgungsleistung Multimorbidit\u00e4t (56544) 2 Mal im Behandlungsfall abrechenbar", action=ActionType.NACHTRAGEN, gnr="56544", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        Optional<ScheinLeistung> optional;
        Optional<ScheinLeistung> optional2;
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("56544"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("56544"), c2.c) < 2 && patient.getLeistungCount(Hzv.BW_AOK.gnr("0000"), c2.c) > 1 && (optional2 = Optional.ofNullable(patient.getLeistung(Hzv.BW_AOK.gnr("56544"), 1L, c2.c))).isPresent() && (optional = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> scheinLeistung.getGnr().equals(Hzv.BW_AOK.gnr("0000")) && scheinLeistung.getDatum().compareTo(((ScheinLeistung)optional2.get()).getDatum()) != 0).findFirst()).isPresent()) {
            action.setAPK(new APK(optional.get()));
            return true;
        }
        return false;
    }

    @Rule(name="HzV AOK Pflegeheimpauschale (0008) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Pflegeheimpauschale (0008) nur mit einem pers\u00f6nlichem/telemed. Hausarzt-Patienten-Kontakt (Kennzeichnung 0000|0000F) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0008", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0000F"), c2.c);
    }

    @Rule(name="HzV AOK Arzt-Patienten-Kontakt ohne Pflegeheimpauschale (0008), Pflegeheimpauschale im Vorquartal vorhanden", action=ActionType.UEBERPRUEFEN, gnr="0008", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0008"), c2.d) && patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0008"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("56871"), c2.c) > 1;
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) h\u00f6chstens 3 Quartale hintereinander abrechenbar", action=ActionType.ENTFERNEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.d) && patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.e) && patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.f);
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) nur mit einem pers\u00f6nlichem/telemed. Hausarzt-Patienten-Kontakt (Kennzeichnung 0000|0000F) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0000F"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) ohne entsprechende gesicherte Diagnose (Z51.5)", action=ActionType.UEBERPRUEFEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) m\u00f6glich, keine Parallelabrechnung neben SAPV vorgesehen", action=ActionType.NACHTRAGEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean s(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasDiagnose("Z51.5", true, c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV AOK palliativmedizinische Betreuung und Koordination (56871) im Behandlungsfall nicht neben Vertreterpauschale (0004) abrechenbar", action=ActionType.ENTFERNEN, gnr="56871", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56871"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV AOK gesicherte palliative Diagnose Z51.5 im Vorquartal vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasDiagnose("Z51.5", true, c2.d);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56872) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56872", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56873) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56873", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56873"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56874) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56874", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56874"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56875) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56875", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56875"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch eines Vertreterarztes (56876) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56876", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch eines Vertreterarztes (56877) ohne gesicherte Z51.5", action=ActionType.UEBERPRUEFEN, gnr="56877", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56877"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56875) nur neben der Behandlungspauschale (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56875"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Besuche (56872, 56873, 56874, 56875) nicht im Vertreterfall (0004) oder Zielauftragsfall (0005) abrechenbar, palliativmedizinischer Besuch eines Vertreterarztes (56876, 56877) pr\u00fcfen", action=ActionType.UEBERPRUEFEN, gnr="56876/56877", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56872|56873|56874|56875"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche (56872, 56873, 56874, 56875) sind aufsteigend zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="56872", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56873"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche (56872, 56873, 56874, 56875) sind aufsteigend zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="56873", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56874"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56873"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche (56872, 56873, 56874, 56875) sind aufsteigend zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="56874", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56875"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56874"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche eines Vertreterarztes (56876, 56877) sind aufsteigend zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="56876", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56877"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche (56872, 56873, 56874, 56875) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="56872/56873/56874/56875", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("56872|56873|56874|56875", c2.c, date) > 1;
    }

    @Rule(name="HzV AOK palliativmedizinsiche Besuche (56876, 56877) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="56876/56877", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("56876|56877", c2.c, date) > 1;
    }

    @Rule(name="HzV AOK palliativmedizinsicher Besuch (56875) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="56875", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("56875", c2.c, date) > 1;
    }

    @Rule(name="HzV AOK palliativmedizinsicher Besuch im Vertreterfall (56877) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="56877", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("56877", c2.c, date) > 1;
    }

    @Rule(name="HzV AOK haus\u00e4rztlicher Kontakt bei gesicherter palliativer Diagnose (Z51.5), eventuell palliativer Hausbesuch abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56872", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV AOK Vertreterpauschale bei gesicherter palliativer Diagnose (Z51.5), eventuell palliativer Hausbesuch abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56876", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV AOK palliativmedizinsicher Besuch (56872) im Vorquartal vorhanden, eventuell auch im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56872", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.getLeistungCount(Hzv.BW_AOK.gnr("56872"), Arrays.asList(c2.d, c2.e, c2.f)) < 3;
    }

    @Rule(name="HzV AOK palliativmedizinsicher Besuch im Vertreterfall (56876) im Vorquartal vorhanden, eventuell auch im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56876", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.getLeistungCount(Hzv.BW_AOK.gnr("56876"), Arrays.asList(c2.d, c2.e, c2.f)) < 3;
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch (56872) h\u00f6chstens 3 Quartale hintereinander abrechenbar", action=ActionType.ENTFERNEN, gnr="56872", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.d) && patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.e) && patient.hasLeistung(Hzv.BW_AOK.gnr("56872"), c2.f);
    }

    @Rule(name="HzV AOK palliativmedizinischer Besuch im Vertreterfall (56876) h\u00f6chstens 3 Quartale hintereinander abrechenbar", action=ActionType.ENTFERNEN, gnr="56876", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.d) && patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.e) && patient.hasLeistung(Hzv.BW_AOK.gnr("56876"), c2.f);
    }

    @Rule(name="HzV AOK palliativmedizinische Besuche (56872, 56873, 56874, 56875) nur durch Hausarzt abrechenbar, nicht durch Vertreterarzt", action=ActionType.ENTFERNEN, gnr="56872|56873|56874|56875", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Besuche im Vertreterfall (56876, 56877) nur durch Vertreterarzt abrechenbar, nicht durch Hausarzt", action=ActionType.ENTFERNEN, gnr="56876|56877", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK palliativmedizinische Besuche (56876, 56877) nur im Vertreterfall (0004) oder Zielauftragsfall (0005) abrechenbar, palliativmedizinischer Besuch (56872, 56873, 56874, 56875) pr\u00fcfen", action=ActionType.ENTFERNEN, gnr="56872/56873/56874/56875", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56876|56877"), c2.c);
    }

    @Rule(name="HzV AOK Vertreterpauschale (0004) muss nicht \u00f6fter als ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV AOK PraCMan-Zuschlag (56564) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56564", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("56564"), c2.c) > 1;
    }

    @Rule(name="HzV AOK PraCMan Pauschale (56564) im Vorquartal vorhanden, eventuell auch im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56564", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56564"), c2.d) && patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56564"), c2.c);
    }

    @Rule(name="HzV AOK Vertreterpauschale (0004) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BW_AOK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV AOK Zielauftrag (0005) nicht neben der 0000 innerhalb der gleichen BAG, MVZ abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BW_AOK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean S(c c2, Patient patient) {
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) ohne entsprechende gesicherte Diagnose (Z12.5)", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Vorsorgediagnose spezielle Verfahren zur Untersuchung auf Neubildung der Prostata (Z12.5) ohne Krebsvorsorge Mann (01731)", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c) && patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) nur mit einem pers\u00f6nlichen Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c);
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01731"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening ab 20 Jahren (01745D, 01745) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745/01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean Z(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung("01745", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("01745|01745D"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 19;
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit Dermatoskop (01745D) im Behandlungsfall nicht neben Hautkrebsscreening ohne Dermatoskop (01745) abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745D"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("01745"), c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit Dermatoskop (01745D) nur einmal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745D"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01745D"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Hautkrebsscreening ohne Dermatoskop (01745) nur einmal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01745"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit Dermatoskop (01745D) sollte nicht durch den Vertreterarzt abgerechnet werden", action=ActionType.ENTFERNEN, gnr="01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745D"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening ohne Dermatoskop (01745) sollte nicht durch den Vertreterarzt abgerechnet werden", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit Dermatoskop (01745D) erst ab einem Alter von 20 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745D", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745D"), c2.c, date) && patient.getAlterAnTag(date) < 20;
    }

    @Rule(name="HzV AOK Hautkrebsscreening ohne Dermatoskop (01745) erst ab einem Alter von 20 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 20;
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit/ohne Dermatoskop (01745/D) ohne entsprechende gesicherte Diagnose (Z12.8)", action=ActionType.UEBERPRUEFEN, gnr="01745|01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c) && !patient.hasDiagnose("Z12.8", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Vorsorgediagnose spezielle Verfahren zur Untersuchung auf Neubildungen sonstiger Lokalisationen (Z12.8) ohne Hautkrebsscreening mit/ohne Dermatoskop (01745/D)", action=ActionType.UEBERPRUEFEN, gnr="01745/01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01745|01745D"), c2.c) && patient.hasDiagnose("Z12.8", true, c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening mit/ohne Dermatoskop (01745/D) nur mit einem Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01745/01745D", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01745|01745D"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur neben Arzt-Patienten-Kontakt (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="56091", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur einmalig durch betreuenden Hausarzt abrechenbar (erstmalig in Betrachtungsquartal + 5 Vorquartale)", action=ActionType.ENTFERNEN, gnr="56091", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aj(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), Arrays.asList(c2.d, c2.e, c2.f, c2.g, c2.h));
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="56091", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), c2.c) && !patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) && !patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c);
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) bei entsprechender Verordnung m\u00f6glich", action=ActionType.POTENTIAL, gnr="56091", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean al(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), Quartal.getBisVorvorjahr(c2.c)) && (patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) || patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c));
    }

    @Rule(name="HzV AOK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) im Behandlungsfall nicht neben der Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) abrechenbar", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56092"), c2.c);
    }

    @Rule(name="HzV AOK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur neben Arzt-Patienten-Kontakt (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean an(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56092"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ap(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("56092"), c2.c) > 1;
    }

    @Rule(name="HzV AOK dauerhafter Vitamin K-Antagonisten-Therapie (56091/56092) in Vorquartalen vorhanden, eventuell Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aq(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56091|56092"), Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="HzV AOK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56092"), c2.c) && !patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) && !patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c);
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung (01732) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung (01732) jedes Kalenderjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean at(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung (01732) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung (01732) nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean au(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01732"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV AOK j\u00e4hrlicher erweiterter Gesundheits-Check-Up (01732) ohne entsprechende gesicherte Diagnose (Z00.0)", action=ActionType.UEBERPRUEFEN, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c) && !patient.hasDiagnose("Z00.0", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Vorsorgediagnose \u00e4rztliche Allgemeinuntersuchung bei Personen ohne Beschwerden oder angegebene Diagnosen, \u00c4rztliche Allgemeinuntersuchung, Check up (Z00.0) ohne j\u00e4hrlicher erweiterter Gesundheits-Check-Up (01732)", action=ActionType.UEBERPRUEFEN, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c) && patient.hasDiagnose("Z00.0", true, c2.c);
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung (01732) nur mit einem pers\u00f6nlichen Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01732", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("01732"), c2.c);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7 (01717) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ay(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01717"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 19 && patient.getAlterInMonate() < 28;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7a (01723) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean az(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01723"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 32 && patient.getAlterInMonate() < 39;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U8 (01718) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aA(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01718"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInMonate() > 42 && patient.getAlterInMonate() < 51;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U9 (01719) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aB(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInMonate() > 57 && patient.getAlterInMonate() < 67;
    }

    @Rule(name="HzV AOK Jugendvorsorgeuntersuchung J1 (01720) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aC(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="HzV AOK U-Untersuchung {gnr} ohne entsprechende gesicherte Vorsorgediagnose (Z00.1)", action=ActionType.UEBERPRUEFEN, gnr="01711|01712|01713|01714|01715|01716|01717|01718|01719|01723", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV AOK J-Untersuchung 01720 ohne entsprechende gesicherte Vorsorgediagnose (Z00.3)", action=ActionType.UEBERPRUEFEN, gnr="01720", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aD(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01720"), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte U-Vorsorgediagnose (Z00.1) ohne Abrechnungsziffer U-Untersuchung (01711 bis 01719, 01723)", gnr="01711/01712/01713/01714/01715/01716/01717/01718/01719/01723", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01711|01712|01713|01714|01715|01716|01717|01718|01719|01723"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte J-Vorsorgediagnose (Z00.3) ohne Abrechnungsziffer J-Untersuchung (01720)", gnr="01720", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aF(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01720"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7 (01717) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01717"), c2.c, date) && (patient.getAlterInMonate(date) < 19 || patient.getAlterInMonate(date) > 28);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7a (01723) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01723"), c2.c, date) && (patient.getAlterInMonate(date) < 32 || patient.getAlterInMonate(date) > 39);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U8 (01718) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01718"), c2.c, date) && (patient.getAlterInMonate(date) < 42 || patient.getAlterInMonate(date) > 51);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U9 (01719) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01719"), c2.c, date) && (patient.getAlterInMonate(date) < 57 || patient.getAlterInMonate(date) > 67);
    }

    @Rule(name="HzV AOK Jugendvorsorgeuntersuchung J1 (01720) ohne entsprechendes Alter des Patienten", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BW_AOK, apk=ApkModus.U_UNTERSUCHUNG, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01720"), c2.c, date) && (patient.getAlterAnTag(date) < 12 || patient.getAlterAnTag(date) > 15);
    }

    @Rule(name="HzV AOK Influenza-Impfung (89111) ohne entsprechende gesicherte Impfdiagnose (Z25.1)", action=ActionType.UEBERPRUEFEN, gnr="89111", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aG(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("89111"), c2.c) && !patient.hasDiagnose("Z25.1", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Impfdiagnose (Z25.1) ohne Influenza-Impfung (89111)", action=ActionType.UEBERPRUEFEN, gnr="89111", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aH(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("89111"), c2.c) && patient.hasDiagnose("Z25.1", true, c2.c);
    }

    @Rule(name="HzV AOK Masern-Mumps-R\u00f6teln-Impfung (89301B) ohne entsprechende gesicherte Impfdiagnose (Z27.4)", action=ActionType.UEBERPRUEFEN, gnr="89301B", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aI(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("89301B"), c2.c) && !patient.hasDiagnose("Z27.4", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Impfdiagnose (Z27.4) ohne Masern-Mumps-R\u00f6teln-Impfung (89301B)", action=ActionType.UEBERPRUEFEN, gnr="89301B", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aJ(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("89301B"), c2.c) && patient.hasDiagnose("Z27.4", true, c2.c);
    }

    @Rule(name="HzV AOK Fallkonferenz R\u00fccken (56580) ohne entsprechende gesicherte Diagnose R\u00fcckenschmerz (M54.*)", action=ActionType.UEBERPRUEFEN, gnr="56580", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aK(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56580"), c2.c) && !patient.hasDiagnoseBeginntMit("M54.", "G", c2.c);
    }

    @Rule(name="HzV AOK Fallkonferenz R\u00fccken (56580) ohne entsprechende gesicherte Diagnose (F62.80, F45.40, F45.41)", action=ActionType.UEBERPRUEFEN, gnr="56580", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aL(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56580"), c2.c) && !patient.hasDiagnose("F62.80|F45.40|F45.41", true, c2.c);
    }

    @Rule(name="HzV AOK Fallkonferenz R\u00fccken (56580) nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56580", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aM(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("56580"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("56580"), Arrays.asList(c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV AOK KV-Schein Pseudoziffer (88192, 88194) ohne HzV-Schein Betreuungspauschale (0000, 0004)", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static String aN(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192|88194", c2.c)) {
            if (patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BW_AOK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV AOK Kennzeichnungsziffer {gnr} nur im KV-Schein abrechenbar, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192|88194", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK lebenslange Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000/0004", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aO(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0004"), c2.c) || !patient.hasLeistung("88192|88194", c2.c)) {
            return false;
        }
        return !patient.getLeistung(Hzv.BW_AOK.gnr("0000|0004"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192|88194", 1L, c2.c).getLanr());
    }

    @Rule(name="HzV AOK Doppelabrechnung von Betreuungspauschale (0000, 0004) im HzV-Schein und Versichertenpauschale (0300*) im KV-Schein ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit(string, c2.c);
    }

    @Rule(name="HzV AOK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Diagnose f\u00fcr F\u00f6rderung Zielauftragspauschale Diabetologie im Vorquartal vorhanden, fehlt aktuell", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aP(c c2, Patient patient) {
        for (String string : "E10.01|E10.11|E10.20|E10.21|E10.30|E10.31|E10.40|E10.41|E10.50|E10.51|E10.60|E10.61|E10.72|E10.73|E10.74|E10.75|E10.80|E10.81|E10.90|E10.91|E11.01|E11.11|E11.20|E11.21|E11.30|E11.31|E11.40|E11.41|E11.50|E11.51|E11.60|E11.61|E11.72|E11.73|E11.74|E11.75|E11.80|E11.81|E11.90|E11.91|E12.01|E12.11|E12.20|E12.21|E12.30|E12.31|E12.40|E12.41|E12.50|E12.51|E12.60|E12.61|E12.72|E12.73|E12.74|E12.75|E12.80|E12.81|E12.90|E12.91|E13.01|E13.11|E13.20|E13.21|E13.30|E13.31|E13.40|E13.41|E13.50|E13.51|E13.60|E13.61|E13.72|E13.73|E13.74|E13.75|E13.80|E13.81|E13.90|E13.91".split("\\|")) {
            if (!patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) || !patient.hasDiagnose(string, true, c2.d) || patient.hasDiagnose(string, true, c2.c)) continue;
            return true;
        }
        return false;
    }

    @Rule(name="HzV AOK {gnr} bei HzV Patienten nicht auf KV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="01732|01745|01731|03220|03221|03360|03362|89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89102V|89102W|89102X|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89105V|89105W|89105X|89106A|89106B|89107A|89107B|89107R|89107V|89107W|89107X|89108A|89108B|89108R|89110A|89110B|89111|89112|89112Y|89113|89113A|89113B|89113V|89113W|89114|89115A|89115B|89115R|89115V|89115W|89115X|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89120V|89120X|89121A|89121B|89121R|89122A|89122B|89122R|89122V|89122W|89122X|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89126V|89126W|89127A|89127B|89128A|89128B|89129A|89129B|89130V|89130W|89130X|89131A|89131B|89131R|89131Y|89132V|89132W|89132X|89133Y|89133V|89133W|89134V|89134W|89134X|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89202V|89202W|89202X|89203A|89203B|89300A|89300B|89301A|89301B|89301V|89301W|89302|89302R|89303|89303R|89303Y|89400|89400R|89401A|89401B|89401V|89401W|89500A|89500B|89600A|89600B|92001|92003|92005|92006|92007|92008|92009|92010|92012|94940|94941|94942|94943|94944|94945|94946|94948|94950|94952|94954|99211|99213|99214|99219|99221|99241|99246|99247|99961|99964|99965|99966|99977|99979")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005) ", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aQ(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aR(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("01711"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01711"), c2.c, date) && patient.getAlterInTage(date) > 2;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) am 3. bis 14. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aS(c c2, Patient patient) {
        Date date = new Date();
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01712"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage(date) > 2 && patient.getAlterInTage(date) < 15;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) nur einmal zwischen 3. und 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aT(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_AOK.gnr("01712"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag und nur bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01712"), c2.c, date) && (patient.getAlterInTage(date) < 3 || patient.getAlterInTage(date) > 14);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) in der 3. bis 8. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aU(c c2, Patient patient) {
        Date date = new Date();
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01713"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage(date) > 14 && patient.getAlterInTage(date) < 50;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aV(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01713"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01713"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) nur zwischen 3. und 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01713"), c2.c, date) && (patient.getAlterInTage(date) < 15 || patient.getAlterInTage(date) > 49);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) im 2. bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aW(c c2, Patient patient) {
        Date date = new Date();
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01714"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage(date) > 30 && patient.getAlterInTage(date) < 136;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aX(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01714"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01714"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) nur zwischen 2. und 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01714"), c2.c, date) && (patient.getAlterInTage(date) < 30 || patient.getAlterInTage(date) > 136);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) im 5. bis 8. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aY(c c2, Patient patient) {
        Date date = new Date();
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01715"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage(date) > 120 && patient.getAlterInTage(date) < 241;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aZ(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01715"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01715"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) nur zwischen 5. und 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01715"), c2.c, date) && (patient.getAlterInTage(date) < 120 || patient.getAlterInTage(date) > 241);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) im 9. bis 14. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ba(c c2, Patient patient) {
        Date date = new Date();
        return patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_AOK.gnr("01716"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getAlterInTage(date) > 240 && patient.getAlterInTage(date) < 421;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BW_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean bb(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01716"), c2.c) && patient.getLeistungCount(Hzv.BW_AOK.gnr("01716"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) nur zwischen 9. und 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BW_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_AOK.gnr("01716"), c2.c, date) && (patient.getAlterInTage(date) < 241 || patient.getAlterInTage(date) > 420);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BW_AOK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BW_AOK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }

    static {
        b.put("Atherosklerose", "I70.21|I70.22|I70.23|I70.24|I70.25|I70.26");
        b.put("Chronische Nierenkrankheit", "N18.1|N18.2|N18.3|N18.4|N18.5");
        b.put("Chronischer Schmerz", "F45.40|F45.41|R52.1|R52.2");
        b.put("Diabetes mellitus", "E10.20|E10.21|E10.30|E10.31|E10.40|E10.41|E10.50|E10.51|E10.60|E10.61|E10.72|E10.73|E10.74|E10.75|E10.80|E10.81|E10.90|E10.91|E11.20|E11.21|E11.30|E11.31|E11.40|E11.41|E11.50|E11.51|E11.60|E11.61|E11.72|E11.73|E11.74|E11.75|E11.80|E11.81|E11.90|E11.91|E12.20|E12.21|E12.30|E12.31|E12.40|E12.41|E12.50|E12.51|E12.60|E12.61|E12.72|E12.73|E12.74|E12.75|E12.80|E12.81|E12.90|E12.91|E13.20|E13.21|E13.30|E13.31|E13.40|E13.41|E13.50|E13.51|E13.60|E13.61|E13.72|E13.73|E13.74|E13.75|E13.80|E13.81|E13.90|E13.91|G59.0|G63.2|H36.0");
        b.put("Chronische Erkrankungen der Leber", "B18.0|B18.11|B18.12|B18.13||B18.14|B18.19|B18.2|B18.8|K73.0|K73.1|K73.2|K73.8|I85.9|K70.2|K70.3|K70.40|K70.41|K70.42|K70.48|K71.7|K72.10|K72.18|K74.0|K74.1|K74.2|K74.3|K74.4|K74.5|K74.6|K76.7");
        b.put("Chronische Erkrankungen der Lunge", "J43.0|J43.1|J43.2|J43.8|J43.9|J44.00|J44.01|J44.02|J44.03|J44.10|J44.11|J44.12|J44.13|J44.80|J44.81|J44.82|J44.83|J44.90|J44.91|J44.92|J44.93|J47|J84.00|J84.01|J84.10|J84.11|J84.80|J84.81|J84.90|J84.91|J96.10|J96.11|J96.19|J98.2|J98.3|J99.0|J99.1|J99.21|J99.22|J99.23|J99.8");
        b.put("Hypertonie mit Komplikationen, renovaskul\u00e4re Hypertonie", "I11.00|I11.01|I11.90|I11.91|I12.00|I12.01|I12.90|I12.91|I13.00|I13.01|I13.10|I13.11|I13.20|I13.21|I13.90|I13.91|I15.00|I15.01|I15.10|I15.11|I15.20|I15.21|I15.80|I15.81|I15.90|I15.91|I67.4");
        b.put("Kardiologische Erkrankungen", "I47.0|I47.1|I47.2|I48.0|I48.1|I48.2|I48.3|I48.9|I20.1|I20.8|I20.9|I25.10|I25.11|I25.12|I25.13|I25.14|I25.15|I25.16|I25.20|I25.21|I25.22|I25.3|I25.4|I25.5|I25.6|I25.8|I27.0|I27.1|I27.20|I27.28|I27.8|I27.9|I42.0|I42.1|I42.2|I42.3|I42.4|I42.5|I42.6|I42.7|I42.80|I42.88|I42.9|I43.0|I43.1|I43.2|I43.8|I50.00|I50.01|I50.11|I50.12|I50.13|I50.14|I51.5");
        b.put("Metastasen", "C77.0|C77.1|C77.2|C77.3|C77.4|C77.5|C77.8|C77.9|C78.0|C78.1|C78.2|C78.3|C78.4|C78.5|C78.6|C78.7|C78.8|C79.0|C79.1|C79.2|C79.3|C79.4|C79.5|C79.6|C79.7|C79.81|C79.82|C79.83|C79.84|C79.85|C79.86|C79.88");
        b.put("Neurologische Erkrankungen", "G10|G20.00|G20.01|G20.10|G20.11|G20.20|G20.21|G21.0|G21.1|G21.2|G21.3|G21.4|G21.8|G23.0|G23.1|G23.2|G23.3|G23.8|G24.0|G24.1|G24.2|G24.3|G24.4|G24.5|G24.8|G25.0|G25.1|G25.2|G25.3|G25.4|G25.5|G25.6|G25.80|G25.81|G25.88|G35.0|G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G36.0|G36.1|G36.8|G37.0|G37.1|G37.2|G37.5|G37.8|I69.0|I69.1|I69.2|I69.3|I69.4|I69.8");
        b.put("Arthrose des Kniegelenks, des H\u00fcftgelenks, der Beckenregion oder des Oberschenkels", "M16.0|M16.1|M16.2|M16.3|M16.4|M16.5|M16.6|M16.7|M17.0|M17.1|M17.2|M17.3|M17.4|M17.5|M19.05|M19.25|M19.85|M19.95");
        b.put("Mittelgradige/Schwere Depression", "F32.1|F32.2|F32.3|F33.1|F33.2|F33.3");
        b.put("Zustand nach Transplantation", "Z94.0|Z94.1|Z94.2|Z94.3|Z94.4|Z94.5|Z94.6|Z94.7|Z94.80|Z94.81|Z94.88");
        b.put("Brustkrebs", "C50.0|C50.1|C50.2|C50.3|C50.4|C50.5|C50.6|C50.8");
        b.put("Rheumatoide Arthritis, Spondylosis ankylosans, Psoariasis-Arthropathie", "M05.00|M05.01|M05.02|M05.03|M05.04|M05.05|M05.06|M05.07|M05.08|M05.10|M05.11|M05.12|M05.13|M05.14|M05.15|M05.16|M05.17|M05.18|M05.20|M05.21|M05.22|M05.23|M05.24|M05.25|M05.26|M05.27|M05.28|M05.30|M05.31|M05.32|M05.33|M05.34|M05.35|M05.36|M05.37|M05.38|M05.80|M05.81|M05.82|M05.83|M05.84|M05.85|M05.86|M05.87|M05.88|M05.90|M05.91|M05.92|M05.93|M05.94|M05.95|M05.96|M05.97|M05.98|M06.00|M06.01|M06.02|M06.03|M06.04|M06.05|M06.06|M06.07|M06.08|M06.10|M06.11|M06.12|M06.13|M06.14|M06.15|M06.16|M06.17|M06.18|M06.20|M06.21|M06.22|M06.23|M06.24|M06.25|M06.26|M06.27|M06.28|M06.30|M06.31|M06.32|M06.33|M06.34|M06.35|M06.36|M06.37|M06.38|M06.40|M06.41|M06.42|M06.43|M06.44|M06.45|M06.46|M06.47|M06.48|M06.80|M06.81|M06.82|M06.83|M06.84|M06.85|M06.86|M06.87|M06.88|M06.90|M06.91|M06.92|M06.93|M06.94|M06.95|M06.96|M06.97|M06.98|L40.5|M45.00|M45.01|M45.02|M45.03|M45.04|M45.05|M45.06|M45.07|M45.08");
        b.put("Chronisch entz\u00fcndliche Darmerkrankungen", "K50.0|K50.1|K50.80|K50.81|K50.82|K50.88|K51.0|K51.2|K51.3|K51.4|K51.5|K51.8");
        b.put("Dekubitus", "L89.00|L89.01|L89.02|L89.03|L89.04|L89.05|L89.06|L89.07|L89.08|L89.10|L89.11|L89.12|L89.13|L89.14|L89.15|L89.16|L89.17|L89.18|L89.20|L89.21|L89.22|L89.23|L89.24|L89.25|L89.26|L89.27|L89.28|L89.30|L89.31|L89.32|L89.33|L89.34|L89.35|L89.36|L89.37|L89.38|L89.90|L89.91|L89.92|L89.93|L89.94|L89.95|L89.96|L89.97|L89.98|L97|L98.4");
        b.put("Sucht/Alkohol", "F10.2|F10.3|F10.4|F10.5|F10.6|F10.7|F10.8|G62.1");
        b.put("Paresen", "G80.0|G80.1|G80.2|G80.3|G80.4|G80.8|G80.9|G81.0|G81.1|G82.02|G82.03|G82.12|G82.13|G82.22|G82.23|G82.32|G82.33|G82.42|G82.43|G82.52|G82.53|G83.0|G83.1|G83.2|G83.3");
        b.put("Gerinnungsst\u00f6rungen", "D66|D67|D68.00|D68.01|D68.1|D68.20|D68.21|D68.22|D68.23|D68.24|D68.25|D68.26|D68.28|D68.31|D68.32|D68.4|D68.5|D68.6|D68.8|D69.1|D69.2|D69.3|D69.40|D69.41|D69.52|D69.53|D69.57|D69.58|D69.60|D69.61|D69.80|D69.88");
    }
}

