/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nhochdrei.kvdt.model.DateConverter;
import com.nhochdrei.kvdt.model.OPS;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ScheinLeistung {
    public static final Comparator<ScheinLeistung> DEFAULT_ORDER = Comparator.comparing(ScheinLeistung::getDatum, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ScheinLeistung::getGnr, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ScheinLeistung::getBsnr, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ScheinLeistung::getLanr, Comparator.nullsFirst(Comparator.naturalOrder()));
    private Date datum;
    private String gnr;
    private String asvteamnummer;
    private String bsnr;
    private String lanr;
    private String erbringerLanr;
    private String art;
    private Integer multiplikator;
    private Integer sachkosten;
    private final List<OPS> opSchluessel = new ArrayList<OPS>();
    private String uhrzeit;
    private Double steigerungsfaktor;
    private Double wert;
    private Double gesamtWert;
    private String legende;
    private String vertragsidentifikator;
    private String budget;
    private Integer prfZeitTag;
    private Integer prfZeitQuartal;
    private String arztkuerzel;
    private String arztkuerzelErbringer;

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="Europe/Berlin")
    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = DateConverter.truncateDate(datum);
    }

    public String getGnr() {
        return this.gnr;
    }

    public void setGnr(String gnr) {
        this.gnr = gnr;
    }

    public String getAsvteamnummer() {
        return this.asvteamnummer;
    }

    public void setAsvteamnummer(String asvteamnummer) {
        this.asvteamnummer = asvteamnummer;
    }

    public String getBsnr() {
        return this.bsnr;
    }

    public void setBsnr(String bsnr) {
        this.bsnr = bsnr;
    }

    public String getLanr() {
        return this.lanr;
    }

    public void setLanr(String lanr) {
        this.lanr = lanr;
    }

    public String getErbringerLanr() {
        return this.erbringerLanr;
    }

    public void setErbringerLanr(String erbringerLanr) {
        this.erbringerLanr = erbringerLanr;
    }

    public String getArt() {
        return this.art;
    }

    public void setArt(String art) {
        this.art = art;
    }

    public Integer getMultiplikator() {
        return this.multiplikator;
    }

    public int ensureMultiplikator() {
        Integer n2 = this.getMultiplikator();
        if (n2 == null) {
            return 1;
        }
        return n2;
    }

    public void setMultiplikator(Integer multiplikator) {
        this.multiplikator = multiplikator;
    }

    public List<OPS> getOpSchluessel() {
        return this.opSchluessel;
    }

    public Integer getSachkosten() {
        return this.sachkosten;
    }

    public void setSachkosten(Integer sachkosten) {
        this.sachkosten = sachkosten;
    }

    public String getUhrzeit() {
        return this.uhrzeit;
    }

    public void setUhrzeit(String uhrzeit) {
        this.uhrzeit = uhrzeit;
    }

    public Double getSteigerungsfaktor() {
        return this.steigerungsfaktor;
    }

    public void setSteigerungsfaktor(Double steigerungsfaktor) {
        this.steigerungsfaktor = steigerungsfaktor;
    }

    public Double getWert() {
        return this.wert;
    }

    public void setWert(Double wert) {
        this.wert = wert;
    }

    public Double getGesamtWert() {
        return this.gesamtWert;
    }

    public void setGesamtWert(Double gesamtWert) {
        this.gesamtWert = gesamtWert;
    }

    public double ensureWert() {
        Double d2 = this.getWert();
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public double ensureGesamtWert() {
        Double d2 = this.getGesamtWert();
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public String getLegende() {
        return this.legende;
    }

    public void setLegende(String legende) {
        this.legende = legende;
    }

    public String getVertragsidentifikator() {
        if (this.vertragsidentifikator == null && this.gnr != null && this.gnr.contains("-")) {
            return this.gnr.substring(this.gnr.indexOf("-") + 1);
        }
        return this.vertragsidentifikator;
    }

    public void setVertragsidentifikator(String vertragsidentifikator) {
        this.vertragsidentifikator = vertragsidentifikator;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return "\t" + this.gnr + ": " + simpleDateFormat.format(this.datum) + " - " + this.bsnr + " / " + this.lanr;
    }

    public boolean hasLeistungBeginntMit(String gnr) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            if (!this.getGnr().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeistung(String gnr) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            if (!this.getGnr().equals(string)) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public String getBudget() {
        return this.budget;
    }

    public void setBudget(String budget) {
        this.budget = budget;
    }

    @JsonIgnore
    public String getKW() {
        return new SimpleDateFormat("yyyy-ww").format(this.datum);
    }

    @JsonIgnore
    public Integer getPrfZeitQuartal() {
        return this.prfZeitQuartal;
    }

    public void setPrfZeitQuartal(Integer prfZeitQuartal) {
        this.prfZeitQuartal = prfZeitQuartal;
    }

    @JsonIgnore
    public Integer getPrfZeitTag() {
        return this.prfZeitTag;
    }

    public void setPrfZeitTag(Integer prfZeitTag) {
        this.prfZeitTag = prfZeitTag;
    }

    public int ensurePrfZeitTag() {
        Integer n2 = this.getPrfZeitTag();
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public int ensurePrfZeitQuartal() {
        Integer n2 = this.getPrfZeitQuartal();
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public String getArztkuerzel() {
        return this.arztkuerzel;
    }

    public void setArztkuerzel(String arztkuerzel) {
        this.arztkuerzel = arztkuerzel;
    }

    public String getArztkuerzelErbringer() {
        return this.arztkuerzelErbringer;
    }

    public void setArztkuerzelErbringer(String arztkuerzelErbringer) {
        this.arztkuerzelErbringer = arztkuerzelErbringer;
    }
}

