/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Quartal
implements Comparable<Quartal> {
    private static Map<Integer, Quartal> quartale = new HashMap<Integer, Quartal>();
    private static Map<String, Quartal> quartaleString = new HashMap<String, Quartal>();
    private int jahr;
    private int quartal;

    private Quartal(int jahr, int quartal) {
        this.jahr = jahr;
        this.quartal = quartal;
        quartale.put(jahr * 10 + quartal, this);
        quartaleString.put(String.valueOf(quartal) + String.valueOf(jahr), this);
    }

    public static Quartal get(String string) {
        Quartal quartal = quartaleString.get(string);
        if (quartal != null) {
            return quartal;
        }
        int n2 = Integer.parseInt(string.substring(0, 1));
        int n3 = Integer.parseInt(string.substring(1));
        return new Quartal(n3, n2);
    }

    @JsonCreator
    public static Quartal fromJson(String quartal) {
        int n2 = Integer.parseInt(quartal.substring(5));
        int n3 = Integer.parseInt(quartal.substring(0, 4));
        return Quartal.get(n3, n2);
    }

    public static Quartal get(int jahr, int quartal) {
        Quartal quartal2 = quartale.get(jahr * 10 + quartal);
        if (quartal2 != null) {
            return quartal2;
        }
        return new Quartal(jahr, quartal);
    }

    public static Collection<Quartal> values() {
        return quartale.values();
    }

    public static List<Quartal> getBisVorjahr(Quartal quartal) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 0; i2 < 8; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            if (quartal2.getJahr() < quartal.getJahr() - 1) continue;
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getBisVorvorjahr(Quartal quartal) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 0; i2 < 12; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            if (quartal2.getJahr() < quartal.getJahr() - 2) continue;
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getBisJahresanfang(Quartal quartal) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 0; i2 < 8; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            if (quartal2.getJahr() < quartal.getJahr()) continue;
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getBisVorjahrOhneAq(Quartal quartal) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 1; i2 < 8; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            if (quartal2.getJahr() < quartal.getJahr() - 1) continue;
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getBisVorVorjahrOhneAq(Quartal quartal) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 1; i2 < 12; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            if (quartal2.getJahr() < quartal.getJahr() - 2) continue;
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getQuartale(Quartal quartal, int altquartalsanzahl) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 0; i2 < altquartalsanzahl; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public static List<Quartal> getQuartaleOhneAq(Quartal quartal, int altquartalsanzahl) {
        ArrayList<Quartal> arrayList = new ArrayList<Quartal>();
        for (int i2 = 1; i2 < altquartalsanzahl; ++i2) {
            Quartal quartal2 = quartal.getDelta(-i2);
            arrayList.add(quartal2);
        }
        return arrayList;
    }

    public int getJahr() {
        return this.jahr;
    }

    public int getQuartal() {
        return this.quartal;
    }

    public Quartal getDelta(int delta) {
        int n2 = delta / 4;
        int n3 = delta % 4;
        int n4 = this.jahr + n2;
        int n5 = this.quartal + n3;
        if (n5 < 1) {
            n5 += 4;
            --n4;
        } else if (n5 > 4) {
            n5 -= 4;
            ++n4;
        }
        return Quartal.get(n4, n5);
    }

    @JsonValue
    public String asJsonValue() {
        return String.format("%4d-%d", this.getJahr(), this.getQuartal());
    }

    public int hashCode() {
        return this.jahr * 10 + this.quartal;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Quartal) {
            return this.jahr == ((Quartal)obj).jahr && this.quartal == ((Quartal)obj).quartal;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.jahr) + String.valueOf(this.quartal);
    }

    @Override
    public int compareTo(Quartal o2) {
        return Integer.compare(this.hashCode(), o2.hashCode());
    }

    public boolean contains(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(2) / 3 + 1;
        int n3 = calendar.get(1);
        return n2 == this.quartal && n3 == this.jahr;
    }

    public boolean after(Quartal q2) {
        return this.hashCode() > q2.hashCode();
    }
}

