/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nhochdrei.kvdt.model.Quartal;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Arzt
implements Comparable<Arzt> {
    private String lanr;
    private String name;
    private String vorname;
    private String titel;
    private String namenszusatz;
    private String arztkuerzel;
    private Map<Quartal, Integer> zeitenQuartal = new HashMap<Quartal, Integer>();
    private Map<Long, Integer> zeitenTag = new HashMap<Long, Integer>();

    public String getLanr() {
        return this.lanr;
    }

    public void setLanr(String lanr) {
        this.lanr = lanr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVorname() {
        return this.vorname;
    }

    public void setVorname(String vorname) {
        this.vorname = vorname;
    }

    public String getTitel() {
        return this.titel;
    }

    public void setTitel(String titel) {
        this.titel = titel;
    }

    public String getNamenszusatz() {
        return this.namenszusatz;
    }

    public void setNamenszusatz(String namenszusatz) {
        this.namenszusatz = namenszusatz;
    }

    @JsonIgnore
    public String getFullname() {
        return (this.titel != null ? this.titel + " " : "") + (this.vorname != null ? this.vorname + " " : "") + this.name;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(this.lanr).append(" - ").append(this.getFullname());
        return stringWriter.toString();
    }

    public int hashCode() {
        return Integer.parseInt(this.lanr);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Arzt) {
            return this.lanr.equals(((Arzt)obj).lanr);
        }
        return false;
    }

    @Override
    public int compareTo(Arzt o2) {
        return this.lanr.compareTo(o2.lanr);
    }

    @JsonIgnore
    public String getShortName() {
        if (this.vorname != null) {
            return this.vorname.substring(0, 1) + ". " + this.name;
        }
        return this.name;
    }

    public void clearTimes() {
        this.zeitenQuartal.clear();
        this.zeitenTag.clear();
    }

    public int getTime(Quartal q2) {
        if (q2 == null) {
            return -1;
        }
        return this.zeitenQuartal.getOrDefault(q2, 0);
    }

    public void addTime(Quartal q2, int zeit) {
        this.zeitenQuartal.put(q2, this.zeitenQuartal.getOrDefault(q2, 0) + zeit);
    }

    public int getTime(Date t) {
        if (t == null) {
            return -1;
        }
        return this.zeitenTag.getOrDefault(t.getTime(), 0);
    }

    public void addTime(Date t, int zeit) {
        this.zeitenTag.put(t.getTime(), this.zeitenTag.getOrDefault(t.getTime(), 0) + zeit);
    }

    @JsonIgnore
    public String getFachgruppe() {
        if (this.getLanr() == null || this.getLanr().length() != 9) {
            return "99";
        }
        return this.getLanr().substring(7, 9);
    }

    public String getArztkuerzel() {
        return this.arztkuerzel;
    }

    public void setArztkuerzel(String arztkuerzel) {
        this.arztkuerzel = arztkuerzel;
    }
}

