/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nhochdrei.kvdt.data.EBM;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.optimizer.RuleData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Action {
    private Patient patient;
    private List<RuleData> ruleDatas = new ArrayList<RuleData>();
    private String gnr;
    private Float potential;
    private Date datum;
    private String input;
    private APK apk;
    private ActionType actionType = null;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Integer count;
    private boolean hidden;

    public static Action dummy() {
        return new Action(null, (RuleData)null);
    }

    public Action(Patient patient, RuleData ruleData) {
        this.patient = patient;
        this.ruleDatas.add(ruleData);
    }

    public Action(List<Action> actions) {
        Action action = actions.get(0);
        this.patient = action.patient;
        this.gnr = action.gnr;
        this.datum = action.datum;
        this.input = action.input;
        this.potential = action.potential;
        this.apk = action.apk;
        this.actionType = action.actionType;
        this.parameters.putAll(action.parameters);
        this.count = action.count;
        this.hidden = actions.stream().allMatch(Action::isHidden);
        this.ruleDatas = actions.stream().map(Action::getFirstRule).collect(Collectors.toList());
    }

    public Action(Action action, List<RuleData> ruleDatas) {
        this.patient = action.patient;
        this.gnr = action.gnr;
        this.datum = action.datum;
        this.input = action.input;
        this.potential = action.potential;
        this.apk = action.apk;
        this.actionType = action.actionType;
        this.parameters.putAll(action.parameters);
        this.count = action.count;
        this.hidden = action.hidden;
        this.ruleDatas = ruleDatas;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public void addRule(RuleData ruleData) {
        this.ruleDatas.add(ruleData);
    }

    public String getGnr() {
        if (this.gnr != null) {
            return this.gnr;
        }
        if (this.input != null) {
            return this.input;
        }
        return this.getFirstRule().getRule().gnr();
    }

    public void setGnr(String gnr) {
        this.gnr = gnr;
    }

    public float getPotential() {
        float f2 = (this.potential != null ? this.potential : EBM.getWert(this.getFirstRule().getRule().hzv().gnr(this.getGnr()))).floatValue();
        return f2 * this.getActionType().getFactor();
    }

    public void setPotential(Float potential) {
        this.potential = potential;
    }

    public int getZeitTag() {
        return EBM.getZeitTag(this.getGnr());
    }

    public int getZeitQuartal() {
        return EBM.getZeitQuartal(this.getGnr());
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public APK getAPK() {
        return this.apk;
    }

    public void setAPK(APK apk) {
        this.apk = apk;
    }

    public String getText() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return this.ruleDatas.stream().map(r -> r.getName().replace("{gnr}", this.getGnr()).replace("{input}", this.input != null ? this.input : "")).map(this::replaceParameters).collect(Collectors.joining("; ")) + (this.datum != null ? " am " + simpleDateFormat.format(this.datum) : "");
    }

    public String toString() {
        return this.patient.getName() + ", " + this.patient.getVorname() + ": " + this.getText() + " ==> " + this.getGnr() + " / " + this.getPotential();
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public ActionType getActionType() {
        if (this.actionType != null) {
            return this.actionType;
        }
        return this.ruleDatas.get(0).getRule().action();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public RuleData getFirstRule() {
        return this.ruleDatas.get(0);
    }

    public int orderForReport(Action a2) {
        int n2 = this.getActionType().compareTo(a2.getActionType());
        if (n2 != 0) {
            return n2;
        }
        if (this.datum != null && a2.datum != null && (n2 = this.datum.compareTo(a2.datum)) != 0) {
            return n2;
        }
        return Float.compare(this.getPotential(), a2.getPotential());
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    private String replaceParameters(String input) {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            input = input.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return input;
    }

    public String getKey() {
        return String.format("%s-%s-%s", new Object[]{this.getGnr(), this.getActionType(), this.apk != null ? this.apk.getDatum() : this.getDatum()});
    }

    public int getCount() {
        return this.count != null ? this.count : 1;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

