/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImportException;
import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.VirtualConFile;
import com.nhochdrei.kvdt.model.VirtualConFileList;
import com.nhochdrei.kvdt.model.json.KvdtSerializer;
import java.io.File;
import java.io.InputStream;

public class JsonImport
extends AbstractFileImporter {
    @Override
    public boolean canReadFile(File file) {
        return file.getName().toLowerCase().endsWith(".json");
    }

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) throws AbrechnungImportException {
        try {
            VirtualConFileList virtualConFileList = KvdtSerializer.deserializeFile(file);
            for (VirtualConFile virtualConFile : virtualConFileList.getConFiles()) {
                if (this.c == null) continue;
                this.c.accept(virtualConFile);
                for (Betriebssteatte betriebssteatte : virtualConFile.getBetriebsstaetten().values()) {
                    this.c.accept(betriebssteatte);
                }
                for (Schein schein : virtualConFile.getScheine()) {
                    this.c.accept(schein);
                }
                if (!this.b) continue;
                this.a(virtualConFile);
            }
        }
        catch (Exception exception) {
            throw new AbrechnungImportException("Fehler beim Einlesen der Json-Datei: " + file.getName(), exception);
        }
    }
}

