/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.importer.HzvContext;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConFile;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HzvXmlImport
extends AbstractFileImporter {
    private static final Logger g = LoggerFactory.getLogger(HzvXmlImport.class);
    private HzvContext h = HzvContext.UNKNOWN;
    protected File d;
    protected Map<String, String> e;
    private String i;
    private String j;
    private ConFile k;
    private Betriebssteatte l;
    private Arzt m;
    private Schein n;
    private ScheinLeistung o;
    private ScheinDiagnose p;
    private boolean q;
    protected Date f;
    private StringBuilder r = new StringBuilder();
    private String s;
    private final SimpleDateFormat t = new SimpleDateFormat("yyyy-MM-dd");
    private final a u = new a();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canReadFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".xml")) {
            return false;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            boolean bl = bufferedReader.lines().anyMatch(string -> string.startsWith("<AbrechnungsContainer "));
            return bl;
        }
        catch (IOException iOException) {
            g.error("Fehler beim Einlesen der XML HZV-Datei: " + file, (Throwable)iOException);
            return false;
        }
    }

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) {
        this.d = file;
        this.e = settings.getBetriebsstaettenMapping();
        try {
            this.f = new Date(Files.getLastModifiedTime(Paths.get(file.toURI()), new LinkOption[0]).toMillis());
        }
        catch (IOException iOException) {
            this.f = new Date(0L);
            iOException.printStackTrace();
        }
        this.a(file);
    }

    private void a(File file) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)this.u);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            g.error("Fehler beim Verarbeiten des HZV-XML", (Throwable)exception);
        }
    }

    protected void a(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)this.u);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            g.error("Fehler beim Verarbeiten des HZV-XML", (Throwable)exception);
        }
    }

    private void b(String string) {
        switch (string) {
            case "Bsnr": {
                this.l = new Betriebssteatte();
                this.l.setBsnr(this.s);
                String string2 = this.e.get(this.l.getBsnr());
                this.n.setAbrechnungBsnr(string2);
                break;
            }
            case "Lanr": {
                this.m.setLanr(this.s);
                break;
            }
            case "Nachname": {
                this.m.setName(this.s);
                break;
            }
            case "Vorname": {
                this.m.setVorname(this.s);
                break;
            }
            case "AkademischerGrad": {
                this.m.setTitel(this.s);
                break;
            }
        }
    }

    private void c(String string) {
        switch (string) {
            case "Nachname": {
                this.n.setPatientName(this.s);
                break;
            }
            case "Vorname": {
                this.n.setPatientVorname(this.s);
                break;
            }
            case "Geburtsdatum": {
                try {
                    this.n.setPatientGeburtsdatum(this.t.parse(this.s));
                }
                catch (ParseException parseException) {
                    g.warn("Geburtsdatum '{}' konnte nicht ausgelesen werden", (Object)this.s);
                }
                break;
            }
            case "Geschlecht": {
                this.n.setPatientGeschlecht(this.s);
                break;
            }
            case "KrankenkassenIk": {
                this.n.setKostentraegerKennung(this.s);
                break;
            }
            case "VersichertenNummer": {
                this.n.setPatientVersichertenId(this.s);
                break;
            }
            case "VersichertenArt": {
                this.n.setPatientVersichertenArt(this.s);
                break;
            }
            case "PatientenId": {
                this.k.setPatientIdHzv(this.s);
                break;
            }
        }
    }

    private void d(String string) {
        switch (string) {
            case "Leistungsdatum": {
                try {
                    this.o.setDatum(this.t.parse(this.s));
                }
                catch (ParseException parseException) {
                    g.warn("Leistungsdatum '{}' konnte nicht ausgelesen werden", (Object)this.s);
                }
                break;
            }
            case "Leistungsziffer": {
                this.o.setGnr(this.s + "-" + this.k.getVertragsIdentifikator());
                break;
            }
        }
    }

    private void e(String string) {
        switch (string) {
            case "DiagnoseCode": {
                this.p.setIcdCode(this.s);
                break;
            }
            case "Sicherheit": {
                this.p.setSicherheit(this.s);
                break;
            }
            case "Seitenlokalisation": {
                this.p.setLokalisation(this.s);
                break;
            }
            case "IstDauerDiagnose": {
                this.q = Boolean.parseBoolean(this.s);
                break;
            }
        }
    }

    class a
    extends DefaultHandler {
        a() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            HzvXmlImport.this.r.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            HzvXmlImport.this.r = new StringBuilder();
            switch (localName) {
                case "AbrechnungsContainer": {
                    HzvXmlImport.this.h = HzvContext.CONTAINER;
                    HzvXmlImport.this.k = new ConFile();
                    HzvXmlImport.this.k.setAbrechnungsType(AbrechnungType.HZV);
                    HzvXmlImport.this.k.setFile(HzvXmlImport.this.d);
                    HzvXmlImport.this.k.setErstellungsdatum(HzvXmlImport.this.f);
                    HzvXmlImport.this.k.setFilenameHzv(HzvXmlImport.this.d.getName());
                    HzvXmlImport.this.h = HzvContext.ABRECHNUNGSDOKUMENTATION;
                    HzvXmlImport.this.n = new Schein();
                    break;
                }
                case "Vertragsarzt": {
                    HzvXmlImport.this.h = HzvContext.VERTRAGSARZT;
                    HzvXmlImport.this.m = new Arzt();
                    break;
                }
                case "AbrechnungsEinheit": {
                    break;
                }
                case "Patient": {
                    HzvXmlImport.this.h = HzvContext.PATIENT;
                    break;
                }
                case "Leistung": {
                    HzvXmlImport.this.h = HzvContext.LEISTUNG;
                    HzvXmlImport.this.o = new ScheinLeistung();
                    break;
                }
                case "Diagnose": {
                    HzvXmlImport.this.h = HzvContext.DIAGNOSE;
                    HzvXmlImport.this.p = new ScheinDiagnose();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            HzvXmlImport.this.s = HzvXmlImport.this.r.toString();
            switch (HzvXmlImport.this.h) {
                case VERTRAGSARZT: {
                    HzvXmlImport.this.b(localName);
                    break;
                }
                case PATIENT: {
                    HzvXmlImport.this.c(localName);
                    break;
                }
                case LEISTUNG: {
                    HzvXmlImport.this.d(localName);
                    break;
                }
                case DIAGNOSE: {
                    HzvXmlImport.this.e(localName);
                    break;
                }
            }
            switch (localName) {
                case "AbrechnungsContainer": {
                    HzvXmlImport.this.k.setAbrechnungsquartal(Quartal.get(HzvXmlImport.this.j + HzvXmlImport.this.i));
                    HzvXmlImport.this.n.setQuartal(HzvXmlImport.this.k.getAbrechnungsquartal());
                    HzvXmlImport.this.n.setArt(ContainerType.HZV);
                    HzvXmlImport.this.n.setHzvVertrag(Hzv.get(HzvXmlImport.this.k.getVertragsIdentifikator()));
                    if (HzvXmlImport.this.c != null) {
                        HzvXmlImport.this.c.accept(HzvXmlImport.this.n);
                    }
                    HzvXmlImport.this.k.getScheine().add(HzvXmlImport.this.n);
                    if (HzvXmlImport.this.c != null) {
                        HzvXmlImport.this.c.accept(HzvXmlImport.this.k);
                        for (Betriebssteatte betriebssteatte : HzvXmlImport.this.k.getBetriebsstaetten().values()) {
                            HzvXmlImport.this.c.accept(betriebssteatte);
                        }
                    }
                    if (!HzvXmlImport.this.b) break;
                    HzvXmlImport.this.a(HzvXmlImport.this.k);
                    break;
                }
                case "VertragsIdentifikator": {
                    HzvXmlImport.this.k.setVertragsIdentifikator(HzvXmlImport.this.s);
                    break;
                }
                case "AbrechnungsJahr": {
                    HzvXmlImport.this.i = HzvXmlImport.this.s;
                    break;
                }
                case "AbrechnungsQuartal": {
                    HzvXmlImport.this.j = HzvXmlImport.this.s;
                    break;
                }
                case "Vertragsarzt": {
                    HzvXmlImport.this.l.getAerzte().put(HzvXmlImport.this.m.getLanr(), HzvXmlImport.this.m);
                    HzvXmlImport.this.k.addBetriebsstaette(HzvXmlImport.this.l.getBsnr(), HzvXmlImport.this.l);
                    HzvXmlImport.this.n.getLeistungen().forEach(scheinLeistung -> {
                        scheinLeistung.setLanr(HzvXmlImport.this.m.getLanr());
                        scheinLeistung.setBsnr(HzvXmlImport.this.l.getBsnr());
                    });
                    break;
                }
                case "AbrechnungsEinheit": {
                    break;
                }
                case "Leistung": {
                    HzvXmlImport.this.n.getLeistungen().add(HzvXmlImport.this.o);
                    HzvXmlImport.this.h = HzvContext.UNKNOWN;
                    break;
                }
                case "Diagnose": {
                    if (HzvXmlImport.this.q) {
                        HzvXmlImport.this.n.getDauerdiagnosen().add(HzvXmlImport.this.p);
                    } else {
                        HzvXmlImport.this.n.getDiagnosen().add(HzvXmlImport.this.p);
                    }
                    HzvXmlImport.this.h = HzvContext.UNKNOWN;
                    break;
                }
            }
        }
    }
}

