/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.AxarisContext;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConFile;
import com.nhochdrei.kvdt.model.OPS;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AxarisImport
extends AbstractFileImporter {
    private static final Logger f = LoggerFactory.getLogger(AxarisImport.class);
    private final HashMap<String, ConFile> g = new HashMap();
    private final Set<Betriebssteatte> h = new HashSet<Betriebssteatte>();
    private final Set<Arzt> i = new HashSet<Arzt>();
    private final Map<String, Set<ScheinDiagnose>> j = new HashMap<String, Set<ScheinDiagnose>>();
    private final List<ScheinDiagnose> k = new ArrayList<ScheinDiagnose>();
    private final SimpleDateFormat l = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat m = new SimpleDateFormat("yyyyMMdd");
    private final a n = new a();
    protected File d;
    protected Map<String, String> e;
    private AxarisContext o = AxarisContext.UNKNOWN;
    private ConFile p;
    private Schein q;
    private ScheinLeistung r;
    private ScheinDiagnose s;
    private boolean t;
    private String u;
    private OPS v = null;
    private String w;
    private Betriebssteatte x;
    private boolean y;
    private StringBuilder z = new StringBuilder();
    private String A;
    private Date B;
    private String C;
    private String D;
    private String E;
    private String F;
    private String G;
    private String H;
    private Date I;
    private String J;
    private String K;
    private String L;
    private String M;
    private String N;
    private String O;
    private String P;
    private String Q;
    private String R;
    private Quartal S = Quartal.get("19001");
    private Charset T = StandardCharsets.ISO_8859_1;

    @Override
    public boolean canReadFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".xml")) {
            return false;
        }
        if (this.checkCharset(file, StandardCharsets.UTF_8)) {
            return true;
        }
        if (this.checkCharset(file, StandardCharsets.ISO_8859_1)) {
            return true;
        }
        return this.checkCharset(file, StandardCharsets.UTF_16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCharset(File file, Charset charset) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            boolean bl;
            bufferedReader.mark(4);
            int n2 = bufferedReader.read();
            if (n2 != 65279) {
                bl = bufferedReader.read();
                int n3 = bufferedReader.read();
                if (239 != n2 || 187 != 0 != bl || 191 != n3) {
                    bufferedReader.reset();
                }
            }
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string == null) {
                bl = false;
                return bl;
            }
            if (!string.startsWith("<extraxExport")) return false;
            this.T = charset;
            bl = true;
            return bl;
        }
        catch (IOException iOException) {
            f.error("Fehler beim Einlesen der Axaris Datei: " + file, (Throwable)iOException);
        }
        return false;
    }

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) {
        this.a();
        this.d = file;
        this.e = settings.getBetriebsstaettenMapping();
        this.a(file);
    }

    private void a() {
        this.S = Quartal.get("19001");
        this.A = null;
        this.B = null;
        this.C = null;
        this.D = null;
        this.E = null;
        this.F = null;
        this.G = null;
        this.H = null;
        this.I = null;
        this.J = null;
        this.K = null;
        this.L = null;
        this.M = null;
        this.g.clear();
        this.h.clear();
        this.i.clear();
        this.j.clear();
        this.k.clear();
        this.v = null;
        this.o = AxarisContext.UNKNOWN;
        this.N = null;
        this.P = null;
        this.Q = null;
        this.w = null;
        this.u = null;
        this.x = null;
        this.y = false;
        this.R = null;
    }

    private void b() {
        this.O = null;
        this.C = null;
        this.D = null;
        this.E = null;
        this.F = null;
        this.G = null;
        this.H = null;
        this.I = null;
        this.J = null;
        this.K = null;
        this.L = null;
        this.M = null;
        this.R = null;
        this.j.clear();
        this.k.clear();
    }

    private void c() {
        this.t = false;
        this.u = null;
    }

    private void d() {
        this.P = null;
        this.Q = null;
    }

    private void a(File file) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), this.T));
            bufferedReader.mark(4);
            int n2 = bufferedReader.read();
            if (n2 != 65279) {
                int n3 = bufferedReader.read();
                int n4 = bufferedReader.read();
                if (239 != n2 || 187 != n3 || 191 != n4) {
                    bufferedReader.reset();
                }
            }
            sAXParser.parse(new InputSource(bufferedReader), (DefaultHandler)this.n);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            f.error("Fehler beim Verarbeiten des Axaris-XML", (Throwable)exception);
        }
    }

    private void a(String string) {
        switch (string) {
            case "ErstellungGestartet": {
                this.B = this.parseDate(this.A);
                break;
            }
            case "Exportzeitraum": {
                this.S = this.parseQuartal(this.parseFileDate(this.A.substring(0, 8)));
                f.info("Quartal: {}", (Object)this.S);
            }
        }
    }

    private void b(String string) {
        switch (string) {
            case "Nachname": {
                this.C = this.A;
                break;
            }
            case "Vorname": {
                this.E = this.A;
                break;
            }
            case "Geburtsdatum": {
                this.I = this.parseDate(this.A);
                break;
            }
            case "Geschlecht": {
                this.D = this.A;
                break;
            }
            case "Ort": {
                this.F = this.A;
                break;
            }
            case "PLZ": {
                this.G = this.A.length() == 4 ? "0".concat(this.A) : this.A;
                break;
            }
            case "Strasse": {
                this.H = this.A;
                break;
            }
        }
    }

    private void c(String string) {
        switch (string) {
            case "IKNummer": {
                this.J = this.A;
                break;
            }
            case "Versichertennummer": {
                this.K = this.A;
                break;
            }
            case "VKNR": {
                this.L = this.A;
                break;
            }
            case "BesonderePersonengruppe": {
                this.M = this.A;
                break;
            }
            case "Kassenart": {
                this.R = this.A;
                break;
            }
        }
    }

    private void d(String string) {
        switch (string) {
            case "BSNR": {
                if (this.w == null) {
                    this.w = this.e.get(this.A);
                }
                Betriebssteatte betriebssteatte = new Betriebssteatte();
                betriebssteatte.setBsnr(this.A);
                this.h.add(betriebssteatte);
                if (!this.y) break;
                this.x = betriebssteatte;
                this.w = this.x.getBsnr();
                break;
            }
            case "LANR": {
                Arzt arzt = new Arzt();
                arzt.setLanr(this.A);
                this.i.add(arzt);
                break;
            }
        }
    }

    private void e(String string) {
        switch (string) {
            case "GueltigVon": 
            case "GueltigBis": 
            case "Datum": 
            case "Ausstellungsdatum": {
                this.q.setAusstellungsdatum(this.parseDate(this.A));
                break;
            }
            case "Scheinart": {
                this.q.setArt(ContainerType.get(0 + this.A));
                break;
            }
            case "Rechnungsart": 
            case "ScheinUntergruppe": {
                this.q.setUntergruppe(this.A);
                break;
            }
            case "Versichertenart": {
                this.q.setPatientVersichertenArt(this.A);
                break;
            }
            case "VK_Nummer": {
                this.q.setAbrechnungsVknr(this.A);
                break;
            }
            case "IK_Nummer": {
                this.q.setKostentraegerKennung(this.A);
                break;
            }
            case "V_Nummer": {
                this.q.setPatientVersichertenId(this.A);
                break;
            }
            case "UberweisungAn": {
                this.q.setUeberweisungAn(this.A);
                break;
            }
            case "Kostentraegerabrechnungsbereich": {
                this.q.setKostentraegerAbrechnungsbereich(this.A);
                break;
            }
            case "UeberweiserLanr": {
                this.q.setUeberweiserLanr(this.A);
                break;
            }
            case "UeberweiserBsnr": {
                this.q.setUeberweiserBsnr(this.A);
                break;
            }
            case "IV": {
                if (!this.A.equals("true")) break;
                this.q.setArt(ContainerType.HZV);
                break;
            }
            case "IVArt": 
            case "VertragsID": {
                this.N = this.A;
                if (this.N.matches("^(\\d\\d\\d-).*$")) {
                    this.N = this.N.substring(4);
                }
                this.q.setHzvVertrag(Hzv.get(this.N));
                break;
            }
            case "TSVGVermittlungsart": {
                this.q.setTsvg(this.A);
                break;
            }
        }
    }

    private void f(String string) {
        switch (string) {
            case "Datum": {
                this.r.setDatum(this.parseDate(this.A));
                break;
            }
            case "Ziffer": {
                if (this.q.getArt() == ContainerType.HZV) {
                    this.r.setGnr(this.A + "-" + this.N);
                    this.r.setVertragsidentifikator(this.N);
                    break;
                }
                if (this.q.getArt() == ContainerType.PRIVAT) {
                    this.r.setGnr(AbrechnungType.PKV.gnr(this.A));
                    break;
                }
                this.r.setGnr(this.A);
                break;
            }
            case "Anzahl": {
                this.r.setMultiplikator(Integer.valueOf(this.A));
                break;
            }
            case "BSNR": 
            case "BSNummer": {
                this.r.setBsnr(this.A);
                break;
            }
            case "LANR": 
            case "LANummer": {
                this.r.setLanr(this.A);
                break;
            }
            case "OPS": {
                this.v = new OPS();
                this.r.getOpSchluessel().add(this.v);
                this.v.setOpSchluessel(this.P);
                this.v.setSeitenLokalisation(this.Q);
                break;
            }
            case "Schluessel": {
                this.P = this.A;
                break;
            }
            case "Lokalisation": {
                this.Q = this.A;
                break;
            }
            case "Steigerungsfaktor": {
                try {
                    this.r.setSteigerungsfaktor(Double.valueOf(this.A));
                }
                catch (NumberFormatException numberFormatException) {
                    f.warn("could not parse double " + this.A, (Throwable)numberFormatException);
                }
                break;
            }
            case "ASVTeamnummer": {
                this.r.setAsvteamnummer(this.A);
                break;
            }
        }
    }

    private void g(String string) {
        switch (string) {
            case "ICD": {
                this.s.setIcdCode(this.A.substring(0, this.A.length() - 1));
                this.s.setSicherheit(this.A.substring(this.A.length() - 1));
                break;
            }
            case "Lokalisation": {
                this.s.setLokalisation(this.A);
                break;
            }
            case "IstDauerDiagnose": {
                this.t = Boolean.parseBoolean(this.A);
                break;
            }
            case "Datum": {
                this.u = this.parseQuartal(this.parseDate(this.A)).toString();
                break;
            }
        }
    }

    private void h(String string) {
        switch (string) {
            case "ICD": {
                this.s.setIcdCode(this.A);
                break;
            }
            case "Sicherheit": {
                this.s.setSicherheit(this.A);
                break;
            }
            case "Lokalisation": {
                this.s.setLokalisation(this.A);
                break;
            }
            case "Datum": {
                this.u = this.parseQuartal(this.parseDate(this.A)).toString();
                break;
            }
        }
    }

    public Date parseDate(String d2) {
        if (d2.isEmpty()) {
            return null;
        }
        try {
            return this.l.parse(d2.substring(0, 10));
        }
        catch (ParseException parseException) {
            f.warn("Fehler Datum parse", (Throwable)parseException);
            return null;
        }
    }

    public Date parseFileDate(String d2) {
        if (d2.isEmpty()) {
            return null;
        }
        try {
            return this.m.parse(d2);
        }
        catch (ParseException parseException) {
            f.warn("Fehler File Datum parse", (Throwable)parseException);
            return null;
        }
    }

    public Quartal parseQuartal(Date d2) {
        if (d2 == null) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d2);
            return Quartal.get(calendar.get(1), calendar.get(2) / 3 + 1);
        }
        catch (Exception exception) {
            f.warn("Fehler Quartal parse", (Throwable)exception);
            return null;
        }
    }

    private void a(Quartal quartal, AbrechnungType abrechnungType, String string) {
        this.p = null;
        this.p = this.g.get(quartal.toString() + (Object)((Object)abrechnungType) + string);
        if (this.p == null) {
            this.p = new ConFile();
            this.p.setFile(this.d);
            this.p.setAbrechnungsType(abrechnungType);
            this.p.setAbrechnungsquartal(quartal);
            this.p.setErstellungsdatum(this.B);
            this.p.setVertragsIdentifikator(string);
            this.g.put(quartal.toString() + (Object)((Object)abrechnungType) + string, this.p);
        }
    }

    public void fillSchein() {
        this.q.setQuartal(this.S);
        this.q.setPatientNummer(this.O);
        this.q.setPatientName(this.C);
        this.q.setPatientVorname(this.E);
        this.q.setPatientGeschlecht(this.D);
        this.q.setPatientOrt(this.F);
        this.q.setPatientPlz(this.G);
        this.q.setPatientStrasse(this.H);
        this.q.setPatientGeburtsdatum(this.I);
        this.q.setPatientVersichertenId(this.K);
        this.q.setAbrechnungsVknr(this.L);
        this.q.setKostentraegerKennung(this.J);
        this.q.setBesonderePersonengruppe(this.M);
        if (this.q.getArt() == ContainerType.PRIVAT && this.R.equals("G")) {
            this.q.setIsIgel(true);
        }
        if (!this.k.isEmpty()) {
            this.q.getDauerdiagnosen().addAll(this.k);
        }
        if (this.j.get(this.q.getQuartal().toString()) != null) {
            this.q.getDiagnosen().addAll((Collection<ScheinDiagnose>)this.j.get(this.q.getQuartal().toString()));
        }
    }

    class a
    extends DefaultHandler {
        a() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            AxarisImport.this.z.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AxarisImport.this.z = new StringBuilder();
            switch (localName) {
                case "Header": {
                    AxarisImport.this.o = AxarisContext.HEADER;
                    break;
                }
                case "Patient": {
                    AxarisImport.this.b();
                    AxarisImport.this.O = attributes.getValue("patnr");
                    break;
                }
                case "PersonendatenPatient": {
                    AxarisImport.this.o = AxarisContext.PATIENT;
                    break;
                }
                case "Kassendaten": {
                    AxarisImport.this.o = AxarisContext.KASSE;
                    break;
                }
                case "Praxisdaten": {
                    AxarisImport.this.o = AxarisContext.PRAXISDATEN;
                    break;
                }
                case "BSNR": {
                    if (AxarisImport.this.o != AxarisContext.PRAXISDATEN) break;
                    AxarisImport.this.y = Objects.equals(attributes.getValue("hauptbetriebsstaette"), "true");
                    break;
                }
                case "Abrechnung": 
                case "Kassenabrechnung": {
                    AxarisImport.this.N = "";
                    AxarisImport.this.o = AxarisContext.SCHEINGKV;
                    AxarisImport.this.q = new Schein();
                    AxarisImport.this.q.setAbrechnungBsnr(AxarisImport.this.w);
                    break;
                }
                case "Privatabrechnung": {
                    AxarisImport.this.N = "";
                    AxarisImport.this.o = AxarisContext.SCHEINPKV;
                    AxarisImport.this.q = new Schein();
                    AxarisImport.this.q.setAbrechnungBsnr(AxarisImport.this.w);
                    break;
                }
                case "AndereAbrechnung": {
                    AxarisImport.this.N = "";
                    AxarisImport.this.o = AxarisContext.SCHEIN;
                    AxarisImport.this.q = new Schein();
                    AxarisImport.this.q.setAbrechnungBsnr(AxarisImport.this.w);
                    break;
                }
                case "Abrechnungsziffer": {
                    AxarisImport.this.d();
                    AxarisImport.this.o = AxarisContext.LEISTUNG;
                    AxarisImport.this.r = new ScheinLeistung();
                    AxarisImport.this.r.setGnr("keineZiffer");
                    break;
                }
                case "Diagnose": {
                    AxarisImport.this.c();
                    AxarisImport.this.t = attributes.getValue("dauerdiagnose") != null;
                    AxarisImport.this.o = AxarisContext.DIAGNOSE;
                    AxarisImport.this.s = new ScheinDiagnose();
                    break;
                }
                case "Dauerdiagnose": 
                case "Akutdiagnose": {
                    AxarisImport.this.c();
                    AxarisImport.this.o = AxarisContext.AKUTDIAGNOSE;
                    AxarisImport.this.s = new ScheinDiagnose();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            AxarisImport.this.A = AxarisImport.this.z.toString();
            switch (AxarisImport.this.o) {
                case HEADER: {
                    AxarisImport.this.a(localName);
                    break;
                }
                case PATIENT: {
                    AxarisImport.this.b(localName);
                    break;
                }
                case KASSE: {
                    AxarisImport.this.c(localName);
                    break;
                }
                case PRAXISDATEN: {
                    AxarisImport.this.d(localName);
                    break;
                }
                case SCHEINGKV: 
                case SCHEINPKV: 
                case SCHEIN: {
                    AxarisImport.this.e(localName);
                    break;
                }
                case LEISTUNG: {
                    AxarisImport.this.f(localName);
                    break;
                }
                case DIAGNOSE: {
                    AxarisImport.this.g(localName);
                    break;
                }
                case AKUTDIAGNOSE: {
                    AxarisImport.this.h(localName);
                    break;
                }
            }
            switch (localName) {
                case "extraxExport": {
                    if (AxarisImport.this.c != null) {
                        for (ConFile conFile : AxarisImport.this.g.values()) {
                            AxarisImport.this.c.accept(conFile);
                            if (AxarisImport.this.x != null) {
                                AxarisImport.this.i.forEach(arzt -> AxarisImport.this.x.getAerzte().put(arzt.getLanr(), (Arzt)arzt));
                                conFile.addBetriebsstaette(AxarisImport.this.x.getBsnr(), AxarisImport.this.x);
                            }
                            for (Betriebssteatte betriebssteatte : AxarisImport.this.h) {
                                AxarisImport.this.i.forEach(arzt -> betriebssteatte.getAerzte().put(arzt.getLanr(), (Arzt)arzt));
                                conFile.addBetriebsstaette(betriebssteatte.getBsnr(), betriebssteatte);
                            }
                            for (Betriebssteatte betriebssteatte : conFile.getBetriebsstaetten().values()) {
                                AxarisImport.this.c.accept(betriebssteatte);
                            }
                            for (Schein schein : conFile.getScheine()) {
                                AxarisImport.this.c.accept(schein);
                            }
                        }
                    }
                    if (AxarisImport.this.b) {
                        for (ConFile conFile : AxarisImport.this.g.values()) {
                            AxarisImport.this.a(conFile);
                        }
                    }
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "PersonendatenPatient": 
                case "Kassendaten": {
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Abrechnung": 
                case "Kassenabrechnung": {
                    if (AxarisImport.this.q.getArt() == ContainerType.HZV) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.q.getQuartal(), AbrechnungType.HZV, AxarisImport.this.N);
                        AxarisImport.this.p.getScheine().add(AxarisImport.this.q);
                    } else {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.q.getQuartal(), AbrechnungType.GKV, AxarisImport.this.N);
                        AxarisImport.this.p.getScheine().add(AxarisImport.this.q);
                    }
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Privatabrechnung": {
                    AxarisImport.this.fillSchein();
                    AxarisImport.this.a(AxarisImport.this.q.getQuartal(), AbrechnungType.PKV, AxarisImport.this.N);
                    AxarisImport.this.p.getScheine().add(AxarisImport.this.q);
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "AndereAbrechnung": {
                    if (AxarisImport.this.q.getArt() == ContainerType.BG) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.q.getQuartal(), AbrechnungType.BG, AxarisImport.this.N);
                        AxarisImport.this.p.getScheine().add(AxarisImport.this.q);
                    } else if (AxarisImport.this.q.getArt() == ContainerType.HZV) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.q.getQuartal(), AbrechnungType.HZV, AxarisImport.this.N);
                        AxarisImport.this.p.getScheine().add(AxarisImport.this.q);
                    }
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Abrechnungsziffer": {
                    AxarisImport.this.q.getLeistungen().add(AxarisImport.this.r);
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Diagnose": {
                    if (AxarisImport.this.t) {
                        AxarisImport.this.k.add(AxarisImport.this.s);
                    } else {
                        AxarisImport.this.j.computeIfAbsent(AxarisImport.this.u, string -> new HashSet()).add(AxarisImport.this.s);
                    }
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Dauerdiagnose": {
                    AxarisImport.this.k.add(AxarisImport.this.s);
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
                case "Akutdiagnose": {
                    AxarisImport.this.j.computeIfAbsent(AxarisImport.this.u, string -> new HashSet()).add(AxarisImport.this.s);
                    AxarisImport.this.o = AxarisContext.UNKNOWN;
                    break;
                }
            }
        }
    }
}

