/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.data.EBM;
import com.nhochdrei.kvdt.exporter.KvdtConsumer;
import com.nhochdrei.kvdt.importer.AbrechnungImportException;
import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractAbrechnungImporter;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.AbstractSqlImporter;
import com.nhochdrei.kvdt.importer.AxarisImport;
import com.nhochdrei.kvdt.importer.HzvFptImport;
import com.nhochdrei.kvdt.importer.HzvImport;
import com.nhochdrei.kvdt.importer.HzvXmlImport;
import com.nhochdrei.kvdt.importer.JsonImport;
import com.nhochdrei.kvdt.importer.KVDTData;
import com.nhochdrei.kvdt.importer.KVDTImport;
import com.nhochdrei.kvdt.importer.TomedoImport;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.ConMetadata;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.PvsType;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbrechnungImporter {
    private static final Logger b = LoggerFactory.getLogger(AbrechnungImporter.class);
    AbrechnungImporterSettings a;
    private List<AbstractAbrechnungImporter> c = Arrays.asList(new KVDTImport(), new HzvImport(), new HzvXmlImport(), new HzvFptImport(), new AxarisImport(), new TomedoImport(), new JsonImport());

    public AbrechnungImporter(AbrechnungImporterSettings settings) {
        this.a = settings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(File file) throws AbrechnungImportException {
        try {
            Iterator iterator = this.fileImporters().iterator();
            while (iterator.hasNext()) {
                AbstractFileImporter abstractFileImporter = (AbstractFileImporter)iterator.next();
                if (!abstractFileImporter.canReadFile(file)) continue;
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    abstractFileImporter.process(file, fileInputStream, this.a);
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                    return;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AbrechnungImportException("Datei nicht gefunden", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new AbrechnungImportException("Fehler beim Einlesen", iOException);
        }
    }

    public void processSql(PvsType pvsType, String url, String user, String password) throws AbrechnungImportException {
        Iterator iterator = this.sqlImporters().iterator();
        while (iterator.hasNext()) {
            AbstractSqlImporter abstractSqlImporter = (AbstractSqlImporter)iterator.next();
            if (!abstractSqlImporter.canHandle(pvsType)) continue;
            abstractSqlImporter.process(url, user, password);
            break;
        }
    }

    public void setStoreData(boolean storeData) {
        this.c.forEach(abstractAbrechnungImporter -> abstractAbrechnungImporter.setStoreData(storeData));
    }

    public void setAbrechnungConsumer(KvdtConsumer kvdtConsumer) {
        this.c.forEach(abstractAbrechnungImporter -> abstractAbrechnungImporter.setAbrechnungConsumer(kvdtConsumer));
    }

    public KVDTData getData() {
        if (!this.getAllConFiles().findFirst().isPresent()) {
            return null;
        }
        KVDTData kVDTData = new KVDTData();
        kVDTData.setKV(this.a().map(ConMetadata::getKV).findFirst().get());
        b.info("Lade EBM: {}", (Object)kVDTData.getKV());
        EBM.load(kVDTData.getKV());
        kVDTData.setAbrechnungsquartal(this.b());
        kVDTData.setQuartale(this.getAllConFiles().map(ConMetadata::getAbrechnungsquartal).collect(Collectors.toSet()));
        kVDTData.setHauptbetriebsstaetten(this.a().map(ConMetadata::getFirstBsnr).distinct().collect(Collectors.toList()));
        kVDTData.setAerzte(this.c());
        kVDTData.setPatients(this.e());
        kVDTData.setFachgruppen(this.d());
        kVDTData.setAbrechnungType(this.getAllConFiles().map(ConMetadata::getAbrechnungsType).distinct().collect(Collectors.toSet()));
        this.a(kVDTData);
        this.b(kVDTData);
        return kVDTData;
    }

    public Stream<ConMetadata> getAllConFiles() {
        return this.c.stream().flatMap(AbstractAbrechnungImporter::getConFiles);
    }

    private Stream<ConMetadata> a() {
        Quartal quartal = this.b();
        return this.getAllConFiles().filter(conMetadata -> conMetadata.getAbrechnungsquartal().equals(quartal));
    }

    private Quartal b() {
        return this.getAllConFiles().map(ConMetadata::getAbrechnungsquartal).max(Quartal::compareTo).get();
    }

    private List<Arzt> c() {
        return this.a().flatMap(conMetadata -> conMetadata.getBetriebsstaetten().values().stream()).flatMap(betriebssteatte -> betriebssteatte.getAerzte().values().stream()).distinct().sorted().collect(Collectors.toList());
    }

    private List<String> d() {
        return this.c().stream().map(arzt -> arzt.getLanr().substring(7, 9)).distinct().collect(Collectors.toList());
    }

    private String a(Schein schein) {
        switch (this.a.getMode()) {
            case MVZ: {
                return String.format("%s-%s-%s-%s", schein.getAbrechnungBsnr(), schein.getPatientName(), schein.getPatientVorname(), schein.getPatientGeburtsdatum());
            }
        }
        return String.format("%s-%s-%s", schein.getPatientName(), schein.getPatientVorname(), schein.getPatientGeburtsdatum());
    }

    private List<Patient> e() {
        HashMap hashMap = new HashMap();
        this.getAllConFiles().flatMap(conMetadata -> conMetadata.getScheine().stream()).forEach(schein -> {
            String string = this.a((Schein)schein);
            Patient patient = (Patient)hashMap.get(string);
            if (patient != null) {
                patient.merge((Schein)schein);
            } else {
                hashMap.put(string, new Patient((Schein)schein));
            }
        });
        Quartal quartal = this.b();
        return hashMap.values().stream().filter(patient -> !patient.getLeistungen(quartal).isEmpty() || !patient.getLeistungen(quartal.getDelta(-1)).isEmpty() || !patient.getLeistungen(quartal.getDelta(-2)).isEmpty() || !patient.getLeistungen(quartal.getDelta(-3)).isEmpty()).collect(Collectors.toList());
    }

    private void a(KVDTData kVDTData) {
        for (Patient patient : kVDTData.getPatients()) {
            for (Quartal quartal : kVDTData.getQuartale()) {
                for (ScheinLeistung scheinLeistung2 : patient.getLeistungen(quartal)) {
                    scheinLeistung2.setPrfZeitQuartal(EBM.getZeitQuartal(scheinLeistung2.getGnr()));
                    scheinLeistung2.setPrfZeitTag(EBM.getZeitTag(scheinLeistung2.getGnr()));
                }
                for (Schein schein : patient.getScheine(quartal)) {
                    schein.getLeistungen().forEach(scheinLeistung -> {
                        scheinLeistung.setPrfZeitQuartal(EBM.getZeitQuartal(scheinLeistung.getGnr()));
                        scheinLeistung.setPrfZeitTag(EBM.getZeitTag(scheinLeistung.getGnr()));
                    });
                }
            }
        }
    }

    private void b(KVDTData kVDTData) {
        kVDTData.getPruefzeitenQuartal().clear();
        kVDTData.getPruefzeitenTag().clear();
        Map<String, Arzt> map = this.c().stream().collect(Collectors.toMap(Arzt::getLanr, arzt -> arzt));
        map.values().forEach(arzt -> {
            arzt.clearTimes();
            kVDTData.getPruefzeitenQuartal().put(arzt.getLanr(), new HashMap());
            kVDTData.getPruefzeitenTag().put(arzt.getLanr(), new HashMap());
        });
        this.a().forEach(conMetadata -> {
            for (Schein schein : conMetadata.getScheine()) {
                for (ScheinLeistung scheinLeistung : schein.getLeistungen()) {
                    scheinLeistung.setPrfZeitQuartal(EBM.getZeitQuartal(scheinLeistung.getGnr()));
                    scheinLeistung.setPrfZeitTag(EBM.getZeitTag(scheinLeistung.getGnr()));
                    Arzt arzt = (Arzt)map.get(scheinLeistung.getLanr());
                    if (arzt == null) continue;
                    arzt.addTime(conMetadata.getAbrechnungsquartal(), scheinLeistung.ensurePrfZeitQuartal() * scheinLeistung.ensureMultiplikator());
                    arzt.addTime(scheinLeistung.getDatum(), scheinLeistung.ensurePrfZeitTag() * scheinLeistung.ensureMultiplikator());
                    kVDTData.getPruefzeitenQuartal().get(arzt.getLanr()).put(conMetadata.getAbrechnungsquartal(), arzt.getTime(conMetadata.getAbrechnungsquartal()));
                    kVDTData.getPruefzeitenTag().get(arzt.getLanr()).put(scheinLeistung.getDatum(), arzt.getTime(scheinLeistung.getDatum()));
                }
            }
        });
    }

    public boolean canReadFile(File file) {
        return this.fileImporters().anyMatch(abstractFileImporter -> abstractFileImporter.canReadFile(file));
    }

    public Stream<AbstractFileImporter> fileImporters() {
        return this.c.stream().filter(abstractAbrechnungImporter -> abstractAbrechnungImporter instanceof AbstractFileImporter).map(abstractAbrechnungImporter -> (AbstractFileImporter)abstractAbrechnungImporter);
    }

    public Stream<AbstractSqlImporter> sqlImporters() {
        return this.c.stream().filter(abstractAbrechnungImporter -> abstractAbrechnungImporter instanceof AbstractSqlImporter).map(abstractAbrechnungImporter -> (AbstractSqlImporter)abstractAbrechnungImporter);
    }
}

