/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.exporter;

import com.nhochdrei.kvdt.exporter.AbstractTableExport;
import com.nhochdrei.kvdt.exporter.KvdtConsumer;
import com.nhochdrei.kvdt.exporter.Table;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConMetadata;
import com.nhochdrei.kvdt.model.OPS;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KvdtTableExport
extends AbstractTableExport
implements KvdtConsumer {
    private final Table d = new Table("con", "Key_con0", "Datei_Name", "Datei_Erstellungsdatum", "Datei_Abrechnungsquartal", "Datei_VertragsIdentifikator", "Abrechnungs_Art");
    private final Table e = new Table("BS", "Key_con0", "BS_BSNR_NBSNR", "BS_Bezeichnung", "BS_PLZ");
    private final Table f = new Table("BS_Arzt", "Key_con0", "BS_BSNR_NBSNR", "BS_Arzt_LANR", "BS_Arzt_NameOErlaeuterung", "BS_Arzt_Vorname", "BS_Arzt_Titel", "BS_Arzt_Kuerzel");
    private final Table g = new Table("Schein", "Key_con0", "Schein_Nummer", "Schein_Art", "Schein_Untergruppe", "Schein_Ausstellungsdatum", "Schein_Behandlungsquartal", "Patient_VersichertenID", "Patient_VersichertenartMFR", "Patient_Name", "Patient_Vorname", "Patient_Geburtsdatum", "Patient_Strasse", "Patient_PLZ", "Patient_Wohnort", "Patient_Geschlecht", "Schein_Abrechnungs_VKNR", "Schein_Krankenkassennummer_IK", "Schein_Kostentraegername", "Schein_KTAB", "Schein_SKT_Zusatzangaben", "Schein_Ueberweiser_BSNR", "Schein_Ueberweiser_LANR", "Schein_UeberweisungAn", "Schein_Besondere_Personengruppe", "Schein_Tsvg", "Patient_Nummer", "istIgel");
    private final Table h = new Table("Schein_Leistung", "Key_con0", "Schein_Nummer", "leistung_id", "Leistung_GOP", "Leistung_Tag", "Leistung_BSNR_DesOrtes", "Leistung_LANR", "Leistung_ArtDerUntersuchung", "Leistung_Multiplikator", "Leistung_OPSchluessel", "Leistung_ASVTeamnummer", "Leistung_SeitenlokalisationOps", "Leistung_Sachkosten", "Leistung_Uhrzeit", "Leistung_Erbringer_LANR", "Leistung_Steigerungsfaktor", "Leistung_Wert", "Leistung_Legende", "Leistung_Arzt_Kuerzel", "Leistung_Arzt_Kuerzel_Erbringer", "Leistung_Gesamt_Wert");
    private final Table i = new Table("Schein_Diagnose", "Key_con0", "Schein_Nummer", "diagnose_id", "Diagnose_Art", "Diagnose_ICD", "Diagnose_Sicherheit", "Diagnose_Seitenlokalisation", "Diagnose_Erlaeuterung");
    private int j = -1;
    private int k = -1;
    private int l = -1;
    private int m = -1;
    private final Map<ConMetadata, Integer> n = new HashMap<ConMetadata, Integer>();

    public KvdtTableExport() {
    }

    public KvdtTableExport(Collection<ConMetadata> conFiles) {
        super(Table::addRow);
    }

    public void process(Collection<ConMetadata> conFiles) {
        if (this.a != null) {
            for (ConMetadata conMetadata : conFiles) {
                this.accept(conMetadata);
                conMetadata.getBetriebsstaetten().values().forEach(this::accept);
                conMetadata.getScheine().forEach(this::accept);
            }
        }
    }

    @Override
    public List<Table> getTables() {
        return Arrays.asList(this.d, this.e, this.f, this.g, this.h, this.i);
    }

    public String[] conData(ConMetadata conFile, int id) {
        return new String[]{String.valueOf(id), conFile.getFilename(), this.b(conFile.getErstellungsdatum()), conFile.getAbrechnungsquartal().toString(), conFile.getVertragsIdentifikator(), conFile.getAbrechnungsType().toString()};
    }

    public String[] bsnrData(int conId, Betriebssteatte betriebssteatte) {
        return new String[]{String.valueOf(conId), betriebssteatte.getBsnr(), betriebssteatte.getBezeichnung(), betriebssteatte.getPlz()};
    }

    public String[] lanrData(int conId, Betriebssteatte betriebssteatte, Arzt arzt) {
        return new String[]{String.valueOf(conId), betriebssteatte.getBsnr(), arzt.getLanr(), arzt.getName(), arzt.getVorname(), arzt.getTitel(), arzt.getArztkuerzel()};
    }

    public String[] scheinData(int conId, Schein schein, int id) {
        return new String[]{String.valueOf(conId), String.valueOf(id), schein.getArt().toString(), schein.getUntergruppe(), this.a(schein.getAusstellungsdatum()), schein.getQuartal().toString(), schein.getPatientVersichertenId(), schein.getPatientVersichertenArt(), schein.getPatientName(), schein.getPatientVorname(), this.a(schein.getPatientGeburtsdatum()), schein.getPatientStrasse(), schein.getPatientPlz(), schein.getPatientOrt(), schein.getPatientGeschlecht(), schein.getAbrechnungsVknr(), schein.getKostentraegerKennung(), schein.getKostentraegerName(), schein.getKostentraegerAbrechnungsbereich(), schein.getSktZusatzangaben(), schein.getUeberweiserBsnr(), schein.getUeberweiserLanr(), schein.getUeberweisungAn(), schein.getBesonderePersonengruppe(), schein.getTsvg(), schein.getPatientNummer(), schein.getIsIgel() != null ? String.valueOf(schein.getIsIgel()) : null};
    }

    public String[] leistungData(int conId, int scheinId, ScheinLeistung leistung, int id) {
        return new String[]{String.valueOf(conId), String.valueOf(scheinId), String.valueOf(id), leistung.getGnr(), this.a(leistung.getDatum()), leistung.getBsnr(), leistung.getLanr(), leistung.getArt(), leistung.getMultiplikator() != null ? String.valueOf(leistung.getMultiplikator()) : null, this.a(leistung.getOpSchluessel().stream().map(OPS::getOpSchluessel).collect(Collectors.toList())), leistung.getAsvteamnummer(), this.a(leistung.getOpSchluessel().stream().map(OPS::getSeitenLokalisation).collect(Collectors.toList())), leistung.getSachkosten() != null ? String.valueOf(leistung.getSachkosten()) : null, leistung.getUhrzeit(), leistung.getErbringerLanr(), leistung.getSteigerungsfaktor() != null ? String.valueOf(leistung.getSteigerungsfaktor()) : null, leistung.getWert() != null ? String.valueOf(leistung.getWert()) : null, leistung.getLegende(), leistung.getArztkuerzel(), leistung.getArztkuerzelErbringer(), leistung.getGesamtWert() != null ? String.valueOf(leistung.getGesamtWert()) : null};
    }

    public String[] diagnoseData(int conId, int scheinId, ScheinDiagnose diagnose, String art, int id) {
        return new String[]{String.valueOf(conId), String.valueOf(scheinId), String.valueOf(id), art, diagnose.getIcdCode(), diagnose.getSicherheit(), diagnose.getLokalisation(), this.a(diagnose.getErlauterungen())};
    }

    @Override
    public void accept(ConMetadata conFile) {
        if (this.a == null) {
            return;
        }
        ++this.j;
        this.a.accept(this.d, this.conData(conFile, this.j));
        if (this.b != null) {
            this.n.put(conFile, this.j);
        }
    }

    @Override
    public void accept(Betriebssteatte betriebssteatte) {
        if (this.a == null) {
            return;
        }
        this.a.accept(this.e, this.bsnrData(this.j, betriebssteatte));
        for (Arzt arzt : betriebssteatte.getAerzte().values()) {
            this.a.accept(this.f, this.lanrData(this.j, betriebssteatte, arzt));
        }
    }

    @Override
    public void accept(Schein schein) {
        if (this.a == null) {
            return;
        }
        ++this.k;
        this.a.accept(this.g, this.scheinData(this.j, schein, this.k));
        for (ScheinLeistung object : schein.getLeistungen()) {
            ++this.l;
            this.a.accept(this.h, this.leistungData(this.j, this.k, object, this.l));
        }
        for (ScheinDiagnose scheinDiagnose : schein.getDiagnosen()) {
            ++this.m;
            this.a.accept(this.i, this.diagnoseData(this.j, this.k, scheinDiagnose, "D", this.m));
        }
        for (ScheinDiagnose scheinDiagnose : schein.getDauerdiagnosen()) {
            ++this.m;
            this.a.accept(this.i, this.diagnoseData(this.j, this.k, scheinDiagnose, "DD", this.m));
        }
    }

    @Override
    public void replace(ConMetadata existingConFile, ConMetadata newConFile) {
        this.n.remove(existingConFile);
    }

    @Override
    public void finish() {
        this.getTables().forEach(this.c);
        if (this.b == null) {
            return;
        }
        for (Table table : this.getTables()) {
            this.b.accept(table, String.format("Key_con0 NOT IN (%s)", this.n.values().stream().map(n2 -> String.format("'%d'", n2)).collect(Collectors.joining(","))));
        }
    }
}

