/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.exporter;

import com.nhochdrei.kvdt.exporter.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExport
implements BiConsumer<Table, String[]> {
    private static final Logger a = LoggerFactory.getLogger(CsvExport.class);
    private final String b = System.getProperty("line.separator");
    private List<Table> c;
    private final HashMap<Table, BufferedWriter> d = new HashMap();

    public CsvExport(List<Table> tables) {
        this.c = tables;
    }

    public void process(File exportDirectory) throws IOException {
        for (Table table : this.c) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(exportDirectory + "-" + table.getName() + ".csv"));
            Throwable throwable = null;
            try {
                bufferedWriter.write(this.a(table.getHeader()));
                for (String[] stringArray : table.getValues()) {
                    bufferedWriter.write(this.a(stringArray));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bufferedWriter == null) continue;
                if (throwable != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bufferedWriter.close();
            }
        }
    }

    private String a(String[] stringArray) {
        StringWriter stringWriter = new StringWriter();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringWriter.append(";");
            }
            stringWriter.append(this.a(stringArray[i2]));
        }
        stringWriter.append(this.b);
        return stringWriter.toString();
    }

    private String a(String string) {
        if (string == null) {
            return "";
        }
        boolean bl = false;
        if (string.contains("\"")) {
            string = string.replace("\"", "\"\"");
            bl = true;
        }
        if (string.contains(";") || string.contains("\r") || string.contains("\n")) {
            bl = true;
        }
        if (bl) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public void prepareExport(File exportDirectory) throws IOException {
        this.d.clear();
        for (Table table : this.c) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(exportDirectory + "-" + table.getName() + ".csv"));
            this.d.put(table, bufferedWriter);
            bufferedWriter.write(this.a(table.getHeader()));
        }
    }

    @Override
    public void accept(Table table, String[] values) {
        try {
            this.d.get(table).write(this.a(values));
        }
        catch (IOException iOException) {
            a.error("Fehler beim Schreiben in Datei f\u00fcr Tabelle " + table + ": " + this.a(values), (Throwable)iOException);
        }
    }

    public void finishExport() throws IOException {
        for (BufferedWriter bufferedWriter : this.d.values()) {
            bufferedWriter.close();
        }
        this.d.clear();
    }
}

