/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules;

import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.VORSORGE)
public class p {
    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Gesundheitsuntersuchung 01732 m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean b(c c2, Patient patient) {
        if (c2.a("Niedersachsen")) {
            return false;
        }
        if (c2.a("Sachsen-Anhalt") && patient.hasLeistung("99022", c2.c)) {
            return false;
        }
        return patient.getAlterAnTag(new Date()) > 34 && patient.hasSchein(ContainerType.AMBULANT, Quartal.getBisVorvorjahr(c2.c)) && !patient.hasLeistung("01732", Quartal.getBisVorvorjahr(c2.c));
    }

    @Rule(name="Hautkrebsscreening 01745/01746 m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745/01746", apk=ApkModus.HAUSARZT_DERMATOLOGIE_INTERNISTOSP)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|10|13", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|10|13", 1L, c2.c).getDatum()) > 34 && patient.hasSchein(ContainerType.AMBULANT, Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01745|01746|01745M|01746M", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Krebsvorsorge M\u00e4nner 01731 m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", apk=ApkModus.HA_INTERNIST_URO_CHIR_HAUT)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|07|10|13|26", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|07|10|13|26", 1L, c2.c).getDatum()) > 44 && "M".equals(patient.getGeschlecht()) && patient.hasSchein(ContainerType.AMBULANT, Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c)) && !patient.hasDiagnoseBeginntMit("C61", c2.c);
    }

    @Rule(name="Stuhluntersuchung alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01737", apk=ApkModus.HA_INTERNIST_URO_CHIR_GYN)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|07|08|10|13|26", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|07|08|10|13|26", 1L, c2.c).getDatum()) > 49 && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|07|08|10|13|26", 1L, c2.c).getDatum()) < 55 && patient.hasSchein(ContainerType.AMBULANT, Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01737|01737M|01734|40150", Quartal.getBisJahresanfang(c2.c)) && !patient.hasDiagnoseBeginntMit("C61", c2.c);
    }

    @Rule(name="Stuhluntersuchung alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01737", apk=ApkModus.HA_INTERNIST_URO_CHIR_GYN)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|07|08|10|13|26", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|07|08|10|13|26", 1L, c2.c).getDatum()) > 54 && patient.hasSchein(ContainerType.AMBULANT, Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01737|01737M|01734|40150", Quartal.getBisVorjahr(c2.c)) && !patient.hasDiagnoseBeginntMit("C61", c2.c);
    }

    @Rule(name="Kindervorsorgeuntersuchung U1 (01711) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01711", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04|08", c2.c) && !patient.hasLeistung("01711", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() < 3;
    }

    @Rule(name="Kindervorsorgeuntersuchung U2 (01712) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01712", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 2 && patient.getAlterInTage() < 15;
    }

    @Rule(name="Kindervorsorgeuntersuchung U3 (01713) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01713", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 14 && patient.getAlterInTage() < 50;
    }

    @Rule(name="Kindervorsorgeuntersuchung U4 (01714) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01714", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 30 && patient.getAlterInTage() < 136;
    }

    @Rule(name="Kindervorsorgeuntersuchung U5 (01715) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01715", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 120 && patient.getAlterInTage() < 241;
    }

    @Rule(name="Kindervorsorgeuntersuchung U6 (01716) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01716", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 240 && patient.getAlterInTage() < 421;
    }

    @Rule(name="Kindervorsorgeuntersuchung U7 (01717) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01717", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 570 && patient.getAlterInTage() < 811;
    }

    @Rule(name="Kindervorsorgeuntersuchung U7a (01723) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01723", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 960 && patient.getAlterInTage() < 1141;
    }

    @Rule(name="Kindervorsorgeuntersuchung U8 (01718) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01718", Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 1260 && patient.getAlterInTage() < 1501;
    }

    @Rule(name="Kindervorsorgeuntersuchung U9 (01719) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", apk=ApkModus.U_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01719", Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage() > 1710 && patient.getAlterInTage() < 1981;
    }

    @Rule(name="Jugendvorsorgeuntersuchung J1 (01720) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", apk=ApkModus.J_UNTERSUCHUNG_POTENTIAL)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("03|04", c2.c) && !patient.hasLeistung("01720", Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|04", 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|04", 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) erst ab dem vollendeten 14. Lebensjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01480")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung("01480", c2.c) && patient.getAlterAnTag(patient.getLeistung("01480", 1L, c2.c).getDatum()) < 14;
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480", apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean s(c c2, Patient patient) {
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && (patient.hasLeistungBeginntMit("03|04", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("03|04", 1L, c2.c).getDatum()) > 13 || patient.hasLeistung("88192|88194", c2.c) && patient.getAlterAnTag(patient.getLeistung("88192|88194", 1L, c2.c).getDatum()) > 13);
    }

    @Rule(name="Prophylaxe gegen RSV (01941) innerhalb vom 1. LJ m\u00f6glich", action=ActionType.POTENTIAL, gnr="01941", daily=true, apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return !patient.hasLeistung("01941", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01943", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistungBeginntMit("03|04", c2.c, date) && patient.getAlterAnTag(date) < 1;
    }

    @Rule(name="Aufkl\u00e4rung und Beratung zur Prophylaxe gegen RSV (01943) innerhalb vom 1. LJ m\u00f6glich", action=ActionType.POTENTIAL, gnr="01943", daily=true, apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return !patient.hasLeistung("01943", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && !patient.hasLeistung("01941", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistungBeginntMit("03|04", c2.c, date) && patient.getAlterAnTag(date) < 1;
    }
}

