/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules;

import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.PAUSCHALEN)
public class m {
    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Versichertenpauschale kann nur ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        if (patient.hasLeistung("03008", c2.c)) {
            return false;
        }
        return patient.getLeistungCount(string, c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale zur Versichertenpauschale (03040) kann nur ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.ENTFERNEN, gnr="03040*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.getLeistungCount(string, c2.c) > 1;
    }

    @Rule(name="{gnr} ohne kurative Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0300*|0400*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        if (patient.hasLeistung("03008", c2.c)) {
            return false;
        }
        String string2 = "Z0|Z1|Z20|Z22|Z23|Z24|Z25|Z26|Z27|Z29|Z3|Z4|Z5|Z6|Z7|Z8|Z9";
        List list = Arrays.stream(string2.split("[|]")).collect(Collectors.toList());
        return patient.hasLeistung(string, c2.c) && patient.hasDiagnoseBeginntMit(string2, c2.c) && patient.getDiagnosen(c2.c).stream().allMatch(scheinDiagnose -> list.stream().anyMatch(string -> scheinDiagnose.getIcdCodeClean().startsWith((String)string)));
    }

    @Rule(name="{gnr} ist im Quartal nicht neben Grundpauschalen abrechenbar", action=ActionType.ENTFERNEN, gnr="01430|01435")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        if (!patient.hasLeistung(string, c2.c)) {
            return false;
        }
        for (String string2 : "03001|03002|03003|03004|03005|03030|04001|04002|04003|04004|04005|04030|01320|01321|01700|01701|05210|05211|05212|06210|06211|06212|07210|07211|07212|08210|08211|08212|09210|09211|09212|10210|10211|10212|11210|11211|11212|11301|12220|12225|13210|13211|13212|13290|13291|13292|13340|13341|13342|13390|13391|13392|13490|13491|13492|13540|13541|13542|13590|13591|13592|13640|13641|13642|13690|13691|13692|14210|14211|15210|15211|15212|16210|16211|16212|18210|18211|18212|19401|19403|20210|20211|20212|21210|21211|21212|21213|21214|21215|22210|22211|22212|23210|23211|23212|23214|26210|26211|26212|27210|27211|27212|30700|12210|17210|19210|24210|24211|24212|25210|25211|25214".split("\\|")) {
            if (!patient.hasLeistung(string2, c2.c) || !patient.getLeistung(string, 1L, c2.c).getLanr().equals(patient.getLeistung(string2, 1L, c2.c).getLanr())) continue;
            return true;
        }
        return false;
    }

    @Rule(name="01435 am Behandlungstag ist nicht neben anderen Ziffern durch selben Arzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01435", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        if (!patient.hasLeistung("01435", c2.c, date)) {
            return false;
        }
        return patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung -> !"01435|01431|40110|40111|32001|32004|32005|32006|32007|32008|32009|32011|32012|32014|32015|32017|32018|32020|32021|32022|32023".contains(scheinLeistung.getGnr()) && scheinLeistung.getDatum().equals(date) && scheinLeistung.getLanr().equals(patient.getLeistungAnTag("01435", 1L, c2.c, date).getLanr()));
    }

    @Rule(name="01430 ist im Quartal nicht neben anderen Ziffern durch selben Arzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01430")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        if (!patient.hasLeistung("01430", c2.c)) {
            return false;
        }
        return patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung -> !"01430|01431|32001|32004|32005|32006|32007|32008|32009|32011|32012|32014|32015|32017|32018|32020|32021|32022|32023|40110|40111".contains(scheinLeistung.getGnr()) && scheinLeistung.getLanr().equals(patient.getLeistung("01430", 1L, c2.c).getLanr()));
    }

    @Rule(name="Haus-/Fach\u00e4rztliche Bereitschaftspauschale (01435) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01435")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        if (!patient.hasLeistung("01435", c2.c)) {
            return false;
        }
        return patient.getAlter(c2.c) > 11 && patient.getLeistungCount("01435", c2.c) > 1;
    }

    @Rule(name="Haus-/Fach\u00e4rztliche Bereitschaftspauschale (01435) nur zweimal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01435")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        if (!patient.hasLeistung("01435", c2.c)) {
            return false;
        }
        return patient.getAlter(c2.c) < 12 && patient.getLeistungCount("01435", c2.c) > 2;
    }

    @Rule(name="Zusatzpauschale f\u00fcr das Ausstellen einer Erstverordnung einer digitalen Gesundheitsanwendung DiGA (01470*) ohne Begr\u00fcndung nur einmal im Behandlungsfall abrechenbar, bei Mehrfachabrechnung Begr\u00fcndung notwendig", action=ActionType.UEBERPRUEFEN, gnr="01470")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("01470", c2.c) && patient.getLeistungBeginntMitCount("01470", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und Auswertung der digitalen Gesundheitsanwendung DiGA somnio (01471*) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01471")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("01471", c2.c) && patient.getLeistungBeginntMitCount("01471", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale zur 01430, 01435 und 01820 f\u00fcr \u00e4rztliche T\u00e4tigkeiten im Zusammenhang mit der elektronischen Patientenakte (01431) h\u00f6chstens 4 Mal im Arztfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01431")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (!patient.hasLeistung("01431", c2.c) || patient.getLeistungCount("01431", c2.c) < 5) {
            return false;
        }
        List list = patient.getLeistungen(c2.c).stream().filter(i.a("01431")).collect(Collectors.toList());
        for (ScheinLeistung scheinLeistung : list) {
            if (patient.getLeistungCountByLanr("01431", scheinLeistung.getLanr(), c2.c) <= 4) continue;
            action.setAPK(new APK(scheinLeistung));
            return true;
        }
        return false;
    }

    @Rule(name="Zusatzpauschale zur 01430, 01435 und 01820 f\u00fcr \u00e4rztliche T\u00e4tigkeiten im Zusammenhang mit der elektronischen Patientenakte (01431) im Arztfall nicht neben anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01431")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        if (!patient.hasLeistung("01431", c2.c)) {
            return false;
        }
        ScheinLeistung scheinLeistung = patient.getLeistung("01431", 1L, c2.c);
        ScheinLeistung scheinLeistung3 = patient.getLeistungen(c2.c).stream().filter(scheinLeistung2 -> !scheinLeistung2.getGnr().equals("01431|01430|01435|01820") && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr())).findFirst().orElse(null);
        return scheinLeistung3 != null;
    }

    @Rule(name="Zusatzpauschale zur 01430, 01435 und 01820 f\u00fcr \u00e4rztliche T\u00e4tigkeiten im Zusammenhang mit der elektronischen Patientenakte (01431) nur einmal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01431", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        if (!patient.hasLeistung("01431", c2.c, date)) {
            return false;
        }
        return patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung -> !"01430|01435|01820".contains(scheinLeistung.getGnr()) && scheinLeistung.getDatum().equals(date) && scheinLeistung.getLanr().equals(patient.getLeistungAnTag("01431", 1L, c2.c, date).getLanr()));
    }

    @Rule(name="Zusatzpauschale zur 01430, 01435 und 01820 f\u00fcr \u00e4rztliche T\u00e4tigkeiten im Zusammenhang mit der elektronischen Patientenakte (01431) nur neben der 01430, 01435, 01820 abrechenbar", action=ActionType.NACHTRAGEN, gnr="01430/01435/01820")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung("01431", c2.c) && !patient.hasLeistung("01430|01435|01820", c2.c);
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der digitalen Gesundheitsanwendung (DiGA) zanadio gem\u00e4\u00df dem Verzeichnis f\u00fcr digitale Gesundheitsanwendungen gem\u00e4\u00df \u00a7 139e SGB V (01473) nicht in 2 aufeinanderfolgenden Quartalen abrechenbar", action=ActionType.ENTFERNEN, gnr="01473")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung("01473", c2.c) && patient.hasLeistung("01473", c2.d);
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der digitalen Gesundheitsanwendung (DiGA) zanadio gem\u00e4\u00df dem Verzeichnis f\u00fcr digitale Gesundheitsanwendungen gem\u00e4\u00df \u00a7 139e SGB V (01473) nur 1x im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01473")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("01473", c2.c) && patient.getLeistungBeginntMitCount("01473", c2.c) > 1;
    }

    @Rule(name="Zusatzpauschale f\u00fcr die Verlaufskontrolle und die Auswertung der digitalen Gesundheitsanwendung (DiGA) zanadio gem\u00e4\u00df dem Verzeichnis f\u00fcr digitale Gesundheitsanwendungen gem\u00e4\u00df \u00a7 139e SGB V (01473) h\u00f6chstens 2x im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01473")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean k(c c2, Patient patient) {
        if (!patient.hasLeistung("01473", c2.c)) {
            return false;
        }
        return patient.getLeistungCount("01473", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Versichertenpauschale nach GOP 03000 ohne Suffix V im aktuellen Quartal, aber Pseudo-GOP Videosprechstunde (88220) abgerechnet", action=ActionType.UEBERPRUEFEN, gnr="88220")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung("88220", c2.c) && patient.hasLeistung("03001|03002|03003|03004|03005", c2.c);
    }

    @Rule(name="Versichertenpauschale nach GOP 03000 mit Suffix V {gnr} im aktuellen Quartal abgerechnet ohne Pseudo-GOP Videosprechstunde (88220)", action=ActionType.UEBERPRUEFEN, gnr="03001V|03002V|03003V|03004V|03005V")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        if (patient.hasLeistung("88220", c2.c)) {
            return false;
        }
        return patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Pers\u00f6nlicher APK in AQ vorhanden, Versichertenpauschale nach GOP 03000 umsetzen ohne Suffix V und 88220 entfernen", action=ActionType.UEBERPRUEFEN, gnr="88220")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        if (patient.hasLeistung("03001|03002|03003|03004|03005", c2.c)) {
            return false;
        }
        return patient.getAPKCount(true, c2.c, new g("01", "02", "03")) > 0L && patient.hasLeistung("88220", c2.c) && patient.hasLeistung("03001V|03002V|03003V|03004V|03005V", c2.c);
    }
}

