/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.f.h;

import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.VORSORGE)
public class c {
    private static final g a = new g("15", "16", "17");

    @RulePrerequisite
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2) {
        return c2.a(a);
    }

    @RulePrerequisite
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient) && patient.hasLeistungBeginntMit("08", c2.c);
    }

    @Rule(name="Beratung zu Fr\u00fcherkennungsuntersuchungen f\u00fcr nach dem 1. April 1987 geborene Frauen (01735) ist nur ein Mal innerhalb von 2 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01735")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01735", c2.c) && patient.getLeistungCount("01735", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Beratung zu Fr\u00fcherkennungsuntersuchungen f\u00fcr nach dem 1. April 1987 geborene Frauen (01735) im Behandlungs- oder Folgequartal nicht neben der 01760, 01761 abrechenbar", action=ActionType.ENTFERNEN, gnr="01735")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean c(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01760|01761", Arrays.asList(c2.c, c2.d)) && patient.hasLeistung("01735", c2.c);
    }

    @Rule(name="Beratung zu Fr\u00fcherkennungsuntersuchungen f\u00fcr nach dem 1. April 1987 geborene Frauen (01735) erfordert ein Geburtsdatum nach dem 01.04.1987", action=ActionType.ENTFERNEN, gnr="01735")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01735", c2.c) && patient.getGeburtsdatum().getTime() < LocalDate.of(1987, 4, 1).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
    }

    @Rule(name="Beratung zu Fr\u00fcherkennungsuntersuchungen f\u00fcr nach dem 1. April 1987 geborene Frauen (01735) am Behandlungstag nicht neben der 01620, 01621 abrechenbar", action=ActionType.ENTFERNEN, gnr="01620|01621", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("01735", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung von Krebserkrankungen bei der Frau (01760) im Kalenderjahr nicht neben der 01761 abrechenbar", action=ActionType.ENTFERNEN, gnr="01760")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean e(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01760", c2.c) && patient.hasLeistung("01761", Quartal.getBisJahresanfang(c2.c));
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01764|01825", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date, String string) {
        return patient.hasLeistung("01761", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Zytologische Untersuchung (01762) am Behandlungstag nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01762", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01762", c2.c, date) && patient.hasLeistungBeginntMit("3268|3269|327|3281|3282|3283|3284|3285|19", c2.c, date);
    }

    @Rule(name="Zytologische Untersuchung (01762, 01766) im Behandlungsfall nicht neben der 01826 abrechenbar", action=ActionType.ENTFERNEN, gnr="01826")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01762|01766", c2.c) && patient.hasLeistung("01826", c2.c);
    }

    @Rule(name="Nachweis von Humanen Papillom-Viren (01763) am Behandlungstag nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01763", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01763", c2.c, date) && patient.hasLeistungBeginntMit("01767|3268|3269|327|3281|3282|3283|3284|3285|19", c2.c, date);
    }

    @Rule(name="Abkl\u00e4rungsdiagnostik (01764) am Behandlungstag nicht neben der 01825 abrechenbar", action=ActionType.ENTFERNEN, gnr="01825", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01764", c2.c, date) && patient.hasLeistung("01825", c2.c, date);
    }

    @Rule(name="Zytologische Untersuchung (01766) am Behandlungstag nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01766", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01766", c2.c, date) && patient.hasLeistungBeginntMit("01762|3268|3269|327|3281|3282|3283|3284|3285|19", c2.c, date);
    }

    @Rule(name="Nachweis von Humanen Papillom-Viren (01767) am Behandlungstag nicht neben speziellen anderen Ziffern abrechenbar", action=ActionType.ENTFERNEN, gnr="01767", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01767", c2.c, date) && patient.hasLeistungBeginntMit("3268|3269|327|3281|3282|3283|3284|3285|19", c2.c, date);
    }

    @Rule(name="Histologie bei Abkl\u00e4rungskolposkopie (01768) am Behandlungstag nicht neben der 19310, 19320, 19321, 19322 abrechenbar", action=ActionType.ENTFERNEN, gnr="01768", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01768", c2.c, date) && patient.hasLeistung("19310|19320|19321|19322", c2.c, date);
    }

    @Rule(name="Betreuung einer Schwangeren (01770) im Behandlungsfall nur 1 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="01770")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01770", c2.c) && patient.getLeistungCount("01770", c2.c) > 1;
    }

    @Rule(name="Betreuung einer Schwangeren (01770) ohne entsprechende Diagnose der Schwangerschaftsdauer", action=ActionType.UEBERPRUEFEN, gnr="01770")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01770", c2.c) && !patient.hasDiagnoseBeginntMit("O09", "G", c2.c);
    }

    @Rule(name="Betreuung einer Schwangeren (01770) eventuell noch abrechenbar, da die Schwangerschaftsdauer codiert wurde, jedoch nicht die 01770 abgerechnet", action=ActionType.UEBERPRUEFEN, gnr="01770", apk=ApkModus.GYNAEKOLOGIE)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("08", c2.c) && !patient.hasLeistung("01770", c2.c) && patient.hasDiagnoseBeginntMit("O09", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2. Trimenon (01771) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn es handelt sich um eine Mehrlingsschwangerschaft, dann ist die 01771 mehrfach abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01771", c2.c) > 1 && !patient.hasDiagnoseBeginntMit("O30", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2. Trimenon (01771) im Behandlungsfall nicht neben der 33043, 33044 abrechenbar", action=ActionType.ENTFERNEN, gnr="33043|33044")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01771", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik I (01772) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn es handelt sich um eine Mehrlingsschwangerschaft, dann ist die 01772 mehrfach abrechenbar", action=ActionType.ENTFERNEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01772", c2.c) > 1 && !patient.hasDiagnoseBeginntMit("O30", "G", c2.c);
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik II (01773) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn es handelt sich um eine Mehrlingsschwangerschaft, dann ist die 01773 mehrfach abrechenbar", action=ActionType.ENTFERNEN, gnr="01773")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01773", c2.c) > 1;
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik des fetalen kardiovaskul\u00e4ren Systems (01774) ist nur ein Mal im Behandlungsfall abrechenbar, es sei denn es handelt sich um eine Mehrlingsschwangerschaft, dann ist die 01774 mehrfach abrechenbar", action=ActionType.ENTFERNEN, gnr="01774")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01774", c2.c) > 1;
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik des fetalen kardiovaskul\u00e4ren Systems (01774) im Behandlungsfall nicht neben der 33062 abrechenbar", action=ActionType.ENTFERNEN, gnr="33062")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01774", c2.c) && patient.hasLeistung("33062", c2.c);
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik des fetomaternalen Gef\u00e4\u00dfsystems (01775) ist nur zwei Mal im Behandlungsfall abrechenbar, es sei denn es handelt sich um eine Mehrlingsschwangerschaft, dann ist die 01775 mehrfach abrechenbar", action=ActionType.ENTFERNEN, gnr="01775")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01775", c2.c) > 2;
    }

    @Rule(name="weiterf\u00fchrende sonographische Diagnostik des fetomaternalen Gef\u00e4\u00dfsystems (01775) im Behandlungsfall nicht neben der 33062 abrechenbar", action=ActionType.ENTFERNEN, gnr="33062")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01775", c2.c) && patient.hasLeistung("33062", c2.c);
    }

    @Rule(name="Vortest auf Gestationsdiabetes (01776) ist h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar, jedoch nur ein Mal pro Schwangerschaft", action=ActionType.ENTFERNEN, gnr="01776")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean q(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01776", c2.c) && patient.getLeistungCount("01776", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="oraler Glukosetoleranztest (oGTT) zum Ausschluss/Nachweis eines Gestationsdiabetes (01777) ist h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar, jedoch nur ein Mal pro Schwangerschaft", action=ActionType.ENTFERNEN, gnr="01777")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean r(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01777", c2.c) && patient.getLeistungCount("01777", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Planung der Geburtsleitung (01780) ist nicht durch den Arzt berechnungsf\u00e4hig, der die Schwangere w\u00e4hrend der Schwangerschaft betreut", action=ActionType.ENTFERNEN, gnr="01780")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01780", c2.c) && patient.hasLeistung("01770", c2.c);
    }

    @Rule(name="Planung der Geburtsleitung (01780) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01786|33042|33043|33044")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01780", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Fruchtwasserentnahme (01781) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01782|02340|02341|02343|33042|33043|33044|33090|33091|33092", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("01781", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="transabdominale Blutentnahme (01782) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01781|02340|02341|02343|33042|33043|33044|33090|33091|33092", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("01782", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Alpha-1-Feto-Protein (AFP) Bestimmung (01783) am Behandlungstag nicht neben der 32350 abrechenbar", action=ActionType.ENTFERNEN, gnr="32350", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01783", c2.c, date) && patient.hasLeistung("32350", c2.c, date);
    }

    @Rule(name="tokographische Untersuchung (01785) am Behandlungstag nicht neben der externen kardiotokographischen Untersuchung (CTG) (01786) abrechenbar", action=ActionType.ENTFERNEN, gnr="01785", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01785", c2.c, date) && patient.hasLeistung("01786", c2.c, date);
    }

    @Rule(name="externe kardiotokographische Untersuchung (CTG) (01786) ist h\u00f6chstens 2 Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01786", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate("01786", c2.c, date) > 2;
    }

    @Rule(name="externe kardiotokographische Untersuchung (CTG) (01786) im Behandlungsfall nicht neben der 01780 abrechenbar", action=ActionType.ENTFERNEN, gnr="01786")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01786", c2.c) && patient.hasLeistung("01780", c2.c);
    }

    @Rule(name="transzervikale Gewinnung von Chorionzottengewebe oder transabdominale Gewinnung von Plazentagewebe (01787) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="02340|02341|02343|33042|33043|33044|33090|33091|33092", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("01787", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung (01790) ist h\u00f6chstens 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01790")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean u(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01790", c2.c) && patient.getLeistungCount("01790", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung (01790) im Behandlungsfall nicht neben der 01600, 01601, 01791, 01792, 01835, 01836, 01837, 08570, 08571, 08572 abrechenbar", action=ActionType.ENTFERNEN, gnr="01790")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01790", c2.c) && patient.hasLeistung("01600|01601|01791|01792|01835|01836|01837|08570|08571|08572", c2.c);
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung (01790) im Krankheitsfall nicht neben der 11230, 11233 abrechenbar", action=ActionType.ENTFERNEN, gnr="01790")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean w(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01790", c2.c) && patient.hasLeistung("11230|11233", Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung auf der Grundlage zugesandter Befunde (01791) ist h\u00f6chstens 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01791")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean x(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01791", c2.c) && patient.getLeistungCount("01791", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung auf der Grundlage zugesandter Befunde (01791) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01600|01601|01790|01792|01793|01835|01836|01837|01838|08570|08571|08572|08573")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01791", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="wissenschaftlich begr\u00fcndete humangenetische Beurteilung auf der Grundlage zugesandter Befunde (01791) im Krankheitsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="11230|11233")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean d(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01791", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="ausf\u00fchrliche humangenetische Beurteilung (01792) ist h\u00f6chstens 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01792")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean y(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01792", c2.c) && patient.getLeistungCount("01792", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="ausf\u00fchrliche humangenetische Beurteilung (01792) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01600|01601|01790|01791|01835|01836|01837|08570|08571|08572")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01792", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="ausf\u00fchrliche humangenetische Beurteilung (01792) im Krankheitsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="11230|11233")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean f(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01792", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="pr\u00e4natale zytogenetische Untersuchung(en) (01793) ist h\u00f6chstens 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01793")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean z(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01793", c2.c) && patient.getLeistungCount("01793", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="pr\u00e4natale zytogenetische Untersuchung(en) (01793) im Behandlungsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="01600|01601|01791|01836|08571|08573")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01793", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="pr\u00e4natale zytogenetische Untersuchung(en) (01793) im Krankheitsfall nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="11501|11502|11503|11506|11508|11511|11512|11513|11516|11517|11521|11522")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean h(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string) {
        return patient.hasLeistung("01793", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Treponemenantik\u00f6rper-Nachweis (01800) am Behandlungstag nicht neben der 32566 abrechenbar", action=ActionType.ENTFERNEN, gnr="32566", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01800", c2.c, date) && patient.hasLeistung("32566", c2.c, date);
    }

    @Rule(name="R\u00f6telnantik\u00f6rper-Bestimmung mittels Immunoassay (01802) am Behandlungstag nicht neben der 32574 abrechenbar", action=ActionType.ENTFERNEN, gnr="32574", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01802", c2.c, date) && patient.hasLeistung("32574", c2.c, date);
    }

    @Rule(name="Untersuchung auf R\u00f6telnantik\u00f6rper der Klasse IgM mittels Immunoassay (01803) am Behandlungstag nicht neben der 32574 abrechenbar", action=ActionType.ENTFERNEN, gnr="32574", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01803", c2.c, date) && patient.hasLeistung("32574", c2.c, date);
    }

    @Rule(name="Bestimmung der Blutgruppe (A, B, 0) und des Rh-Faktors D (01804) am Behandlungstag nicht neben der 32540 abrechenbar", action=ActionType.ENTFERNEN, gnr="32540", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01804", c2.c, date) && patient.hasLeistung("32540", c2.c, date);
    }

    @Rule(name="Untersuchung auf Dweak (01805) am Behandlungstag nicht neben der 32542 abrechenbar", action=ActionType.ENTFERNEN, gnr="32542", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01805", c2.c, date) && patient.hasLeistung("32542", c2.c, date);
    }

    @Rule(name="Bestimmung der Blutgruppenmerkmale C, c, E und e (01806) am Behandlungstag nicht neben der 32541 abrechenbar", action=ActionType.ENTFERNEN, gnr="32541", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01806", c2.c, date) && patient.hasLeistung("32541", c2.c, date);
    }

    @Rule(name="Antik\u00f6rper-Nachweis (01807) am Behandlungstag nicht neben der 32545 abrechenbar", action=ActionType.ENTFERNEN, gnr="32545", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01807", c2.c, date) && patient.hasLeistung("32545", c2.c, date);
    }

    @Rule(name="Antik\u00f6rper-Differenzierung (01808) am Behandlungstag nicht neben der 32546 abrechenbar", action=ActionType.ENTFERNEN, gnr="32546", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01808", c2.c, date) && patient.hasLeistung("32546", c2.c, date);
    }

    @Rule(name="quantitativer Antik\u00f6rpernachweis (01809) am Behandlungstag nicht neben der 32554 abrechenbar", action=ActionType.ENTFERNEN, gnr="32554", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01809", c2.c, date) && patient.hasLeistung("32554", c2.c, date);
    }

    @Rule(name="Untersuchung auf Hepatitis B-Virus-Antigen (HBs-Ag) (01810) am Behandlungstag nicht neben der 32781 abrechenbar", action=ActionType.ENTFERNEN, gnr="32781", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01810", c2.c, date) && patient.hasLeistung("32781", c2.c, date);
    }

    @Rule(name="Untersuchung auf HIV-Antik\u00f6rper (01811) am Behandlungstag nicht neben der 32575 abrechenbar", action=ActionType.ENTFERNEN, gnr="32575", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01811", c2.c, date) && patient.hasLeistung("32575", c2.c, date);
    }

    @Rule(name="Glukosebestimmung im ven\u00f6sen Plasma (01812) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32057", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("01812", c2.c, date) && patient.hasLeistung(string, c2.c, date);
    }

    @Rule(name="Chlamydia trachomatis - Nachweis im Urin (01816) ist h\u00f6chstens 2 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01816")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean A(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01816", c2.c) && patient.getLeistungCount("01816", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="Chlamydia trachomatis - Nachweis im Urin (01816) am Behandlungstag nicht neben der 32839 abrechenbar", action=ActionType.ENTFERNEN, gnr="32839", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01816", c2.c, date) && patient.hasLeistung("32839", c2.c, date);
    }

    @Rule(name="oraler Glukosetoleranztest (oGTT) (01777) erfordert meist die vorausgehende Ansetzung des Vortest auf Gestationsdiabetes (01776)", action=ActionType.UEBERPRUEFEN, gnr="01776")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean B(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return !patient.hasLeistung("01776", Arrays.asList(c2.c, c2.d)) && patient.hasLeistung("01777", c2.c);
    }

    @Rule(name="Verdacht oder Ausschluss von Gestrationsdiabetes ohne Ansetzung der 01776, 01777 in den letzten 2 Quartalen. Wenn dieser Test durchgef\u00fchrt wurden, dann ist eventuell die 01776 oder 01777 ansetzbar", action=ActionType.NACHTRAGEN, gnr="01776/01777", apk=ApkModus.GYNAEKOLOGIE)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasScheinInQuartal(c2.c) && !patient.hasLeistung("01776|01777", Arrays.asList(c2.c, c2.d)) && (patient.hasDiagnose("O24.9", false, c2.c) || patient.hasDiagnose("O24.9", true, c2.c));
    }

    @Rule(name="postpartale Betreuung von M\u00fcttern Z39 ist meist im Zusammenhang mit der postpartalen Betreuung (01815) abrechenbar", action=ActionType.NACHTRAGEN, gnr="01815")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasScheinInQuartal(c2.c) && !patient.hasLeistung("01815", c2.c) && patient.hasDiagnoseBeginntMit("Z39", "G", c2.c);
    }

    @Rule(name="Pr\u00e4natale Bestimmung des fetalen Rhesusfaktors D an fetaler DNA aus m\u00fctterlichem Blut (01869) nicht bei Mehrlingsschwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01869")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01896", c2.c) && patient.hasDiagnoseBeginntMit("O30", "G", c2.c);
    }

    @Rule(name="Beratung nach GenDG zum nicht-invasiven Pr\u00e4nataltest auf den Rhesusfaktor(NIPT-RhD) gem\u00e4\u00df der Mutterschaftsrichtlinien (01788) h\u00f6chstens zweimal je Schwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01788")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean F(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01788", c2.c) && patient.getLeistungCount("01788", c2.c, c2.d, c2.e) > 2;
    }

    @Rule(name="Pr\u00e4natale Bestimmung des fetalen Rhesusfaktors D an fetaler DNA aus m\u00fctterlichem Blut (01869) h\u00f6chstens zweimal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01869")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean G(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01869", c2.c) && patient.getLeistungCount("01788", c2.c, c2.d, c2.e, c2.f) > 2;
    }

    @Rule(name="Pr\u00e4natale Bestimmung des fetalen Rhesusfaktors D an fetaler DNA aus m\u00fctterlichem Blut (01869) nur einmal je Schwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01869")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean H(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01869", c2.c) && patient.getLeistungCount("01788", c2.c, c2.d, c2.e) > 1;
    }

    @Rule(name="Untersuchung und Beratung der W\u00f6chnerin (01815) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="01815")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01815", c2.c) && !patient.hasDiagnose("A34|O15.2|O15.9|O16|O25|O26.4|O26.68|O26.7", "G", c2.c) && !patient.hasDiagnoseBeginntMit("O10|O24|O8|O9|Z37|Z39", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) max. 1x je Schwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean J(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01771", c2.c) && patient.hasDiagnoseBeginntMit("O09", "G", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getLeistungCount("01771", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) im Behandlungsfall nur in der SSW 14-27 abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01771", c2.c) && !patient.hasDiagnose("O09.2|O09.3", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01771", c2.c) && patient.getLeistungCount("01771", c2.c) < 2 && patient.hasDiagnose("O30.0", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01771", c2.c) && patient.getLeistungCount("01771", c2.c) < 3 && patient.hasDiagnose("O30.1", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01771", c2.c) && patient.getLeistungCount("01771", c2.c) < 4 && patient.hasDiagnose("O30.2", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01771", c2.c) > 2 && patient.hasDiagnose("O30.0", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01771", c2.c) > 3 && patient.hasDiagnose("O30.1", "G", c2.c);
    }

    @Rule(name="Ultraschalluntersuchung mit Biometrie und systematischer Untersuchung der fetalen Morphologie im 2.Trimenon (01771) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01771")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01771", c2.c) > 4 && patient.hasDiagnose("O30.2", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01772", c2.c) && patient.getLeistungCount("01772", c2.c) < 2 && patient.hasDiagnoseBeginntMit("O30.0", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01772", c2.c) && patient.getLeistungCount("01772", c2.c) < 3 && patient.hasDiagnoseBeginntMit("O30.1", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01772", c2.c) && patient.getLeistungCount("01772", c2.c) < 4 && patient.hasDiagnoseBeginntMit("O30.2", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01772", c2.c) > 2 && patient.hasDiagnoseBeginntMit("O30.0", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01772", c2.c) > 3 && patient.hasDiagnoseBeginntMit("O30.1", "G", c2.c);
    }

    @Rule(name="Weiterf\u00fchrende sonographische Diagnostik I (01772) nur entsprechend der Anzahl der Mehrlinge abrechenbar", action=ActionType.ENTFERNEN, gnr="01772")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getLeistungCount("01772", c2.c) > 4 && patient.hasDiagnoseBeginntMit("O30.2", "G", c2.c);
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung von Krebserkrankungen bei der Frau (01760) erst ab dem vollendeten 20. Lebensjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01760", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01760", c2.c, date) && patient.getAlterAnTag(date) < 20;
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung von Krebserkrankungen bei der Frau (01760) nur 1x im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01760")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean X(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01760", c2.c) && patient.getLeistungCount("01760", Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung von Krebserkrankungen bei der Frau (01760) ab dem vollendeten 20. Lebensjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01760")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Y(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getAlterAnTag(new Date()) > 19 && !patient.hasLeistung("01760", Quartal.getBisJahresanfang(c2.c));
    }

    @Rule(name="Entnahme von Zellmaterial von der Portio-Oberfl\u00e4che - Empf\u00e4ngnisregelung (01825) am Behandlungstag nicht neben der 01761 abrechenbar", action=ActionType.ENTFERNEN, gnr="01825", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01761", c2.c, date) && patient.hasLeistung("01825", c2.c, date);
    }

    @Rule(name="Abkl\u00e4rungsdiagnostik gem\u00e4\u00df Teil III. C. \u00a7 7 oKFE-RL (01764) am Behandlungstag nicht neben der 01761 abrechenbar", action=ActionType.ENTFERNEN, gnr="01764", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01761", c2.c, date) && patient.hasLeistung("01764", c2.c, date);
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) ab dem vollendeten 20. Lebensjahr bis zum vollendetem 34. Lebensjahr nur 1 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01761", daily=true)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean y(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01761", c2.c, date) && patient.getAlterAnTag(date) > 19 && patient.getAlterAnTag(date) < 35 && patient.getLeistungCount("01761", Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) ab dem vollendeten 35. Lebensjahr nur 1 Mal alle drei Kalenderjahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01761", daily=true)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean z(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01761", c2.c, date) && patient.getAlterAnTag(date) > 34 && patient.getLeistungCount("01761", Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) erst ab dem vollendeten 20. Lebensjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01761", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(com.nhochdrei.kvdt.optimizer.c c2, Patient patient, Date date) {
        return patient.hasLeistung("01761", c2.c, date) && patient.getAlterAnTag(date) < 20;
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) ab dem vollendeten 20. Lebensjahr bis vollendetem 34. Lebensjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01761")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Z(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        Date date = new Date();
        return patient.getAlterAnTag(date) > 19 && patient.getAlterAnTag(date) < 35 && !patient.hasLeistung("01761", Quartal.getBisJahresanfang(c2.c));
    }

    @Rule(name="Untersuchung zur Fr\u00fcherkennung des Zervixkarzinoms (01761) ab dem vollendeten 35. Lebensjahr alle drei Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01761")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aa(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.getAlterAnTag(new Date()) > 34 && !patient.hasLeistung("01761", Quartal.getBisVorvorjahr(c2.c));
    }

    @Rule(name="Betreuung einer Schwangeren (01770) h\u00f6chstens 4 Mal je Schwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01770")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ab(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01770", c2.c) && patient.hasDiagnoseBeginntMit("O09", "G", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getLeistungCount("01770", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 4;
    }

    @Rule(name="Beratung nach GenDG zum nicht-invasiven Pr\u00e4nataltest zur Bestimmung des Risikos autosomaler Trisomien 13, 18 und 21 (01789) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01789")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ac(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return !patient.hasLeistung("01789", c2.c) && patient.getLeistungCount("01789", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 4 && patient.hasLeistung("08211", c2.c) && patient.hasDiagnoseBeginntMit("O09", c2.c);
    }

    @Rule(name="Beratung nach GenDG zum nicht-invasiven Pr\u00e4nataltest zur Bestimmung des Risikos autosomaler Trisomien 13, 18 und 21 (01789) h\u00f6chstens 4 Mal je Schwangerschaft abrechenbar", action=ActionType.ENTFERNEN, gnr="01789")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ad(com.nhochdrei.kvdt.optimizer.c c2, Patient patient) {
        return patient.hasLeistung("01789", c2.c) && patient.hasDiagnoseBeginntMit("O09", c2.c) && patient.getLeistungCount("01789", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 4;
    }
}

