/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules;

import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.PAUSCHALEN)
public class d {
    private static final String a = "F00|F01|F02|G30|G20.1|G20.2";
    private static final String b = "E41|F00|F01|F02|F03|F04|F05|F06|F07|F08|F09|F29|F32|F33|F41|F45.41|F69|F79.9|G20.1|G20.2|G20.3|G20.4|G20.5|G20.6|G20.7|G20.8|G20.9|G30|G31|G32|G54.6|G81.0|G81.1|H81|H82|I6|M62.50|M80.0|M80.2|M80.3|M80.5|M80.8|N31.0|N39.3|N39.4|R13|R15|R26|R29.6|R32|R41|R42|R46.4|R52.1|R52.2|R53|R54|R63.4|R64|R68.8|U50|U51|Z74|Z99.3";
    private static final g c = new g("01", "02", "03");

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Geriatrie {gnr} bei Pat. j\u00fcnger 70 J., ohne gesicherte Alzheimer, Parkinson, Demenz", action=ActionType.UEBERPRUEFEN, gnr="03360|03362")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getAlterAnTag(patient.getLeistung(string, 1L, c2.c).getDatum()) < 70 && !patient.hasDiagnoseBeginntMit(a, "G", c2.c);
    }

    @Rule(name="Geriatrie {gnr} ohne gesicherte geriatrische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="03360|03362")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="Geriatrie 03362 fehlt, 03360 in letzten 4Q vorhanden und mehr als 1 APK aktuell", action=ActionType.NACHTRAGEN, gnr="03362")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (patient.hasLeistung("03362", c2.c)) {
            return false;
        }
        if (!patient.hasDiagnoseBeginntMit(b, "G", c2.c)) {
            return false;
        }
        if (!patient.hasLeistung("03360", Arrays.asList(c2.c, c2.d, c2.e, c2.f))) {
            return false;
        }
        if (patient.getAPKCount(true, c2.c, c.and(scheinLeistung -> !"03370|03371|03372|03373|30984|37300|37302|37305|37306".contains(scheinLeistung.getGnr()))) < 2L) {
            return false;
        }
        action.setAPK(patient.getAPK(true, c2.c, 2L, c.and(scheinLeistung -> !"03370|03371|03372|03373|30984|37300|37302|37305|37306".contains(scheinLeistung.getGnr()))));
        return true;
    }

    @Rule(name="Geriatrie 03362 ohne 03360 in letzten 4 Quartalen", action=ActionType.ENTFERNEN, gnr="03362")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("03362", c2.c) && !patient.hasLeistung("03360", Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="Geriatrie 03362 und weniger als 2 APK", action=ActionType.ENTFERNEN, gnr="03362")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung("03362", c2.c) && patient.getAPKCount(true, c2.c, c) < 1L;
    }

    @Rule(name="Geriatrie 03360 \u00f6fters als 2 Mal in den letzten 4Q", action=ActionType.ENTFERNEN, gnr="03360")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean d(c c2, Patient patient) {
        if (!patient.hasLeistung("03360", c2.c)) {
            return false;
        }
        int n2 = 0;
        if (patient.hasLeistung("03360", c2.d)) {
            ++n2;
        }
        if (patient.hasLeistung("03360", c2.e)) {
            ++n2;
        }
        if (patient.hasLeistung("03360", c2.f)) {
            ++n2;
        }
        return n2 >= 2;
    }

    @Rule(name="03360 noch nicht zwei Mal in den letzten 4 Q. abgerechnet, obwohl Pat. \u00e4lter 69 J. und geriatr. Diagn. in den letzten 4 Q. vorh. war", action=ActionType.POTENTIAL, gnr="03360", apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasDiagnoseBeginntMit(b, c2.c) && patient.hasLeistungBeginntMit("0300", c2.c) && patient.getLeistungCount("03360", c2.c, c2.d, c2.e, c2.f) < 2 && !patient.hasLeistung("03360", Arrays.asList(c2.c, c2.d)) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300", 1L, c2.c).getDatum()) > 69 && patient.hasSchein(ContainerType.AMBULANT, c2.c);
    }

    @Rule(name="Pat. j\u00fcnger 70 J. mit Alzheimer o. Parkinson o. Demenz, 03360 noch nicht zwei Mal in den letzten 4Q", action=ActionType.POTENTIAL, gnr="03360", apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasDiagnoseBeginntMit(a, c2.c) && patient.hasLeistungBeginntMit("0300", c2.c) && patient.getLeistungCount("03360", c2.c, c2.d, c2.e, c2.f) < 2 && !patient.hasLeistung("03360", c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300", 1L, c2.c).getDatum()) < 70 && patient.hasSchein(ContainerType.AMBULANT, c2.c);
    }

    @Rule(name="geriatrisches Basisassesment (03360) am Behandlungstag nicht neben der 03370-03373, 30984, 37300, 37302, 37305, 37306 abrechenbar", action=ActionType.ENTFERNEN, gnr="03360", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("03360", c2.c, date) && patient.hasLeistung("03370|03371|03372|03373|30984|37300|37302|37305|37306", c2.c, date);
    }

    @Rule(name="haus\u00e4rztlich-geriatrischer Betreuungskomplex (03362) am Behandlungstag nicht neben der 03370-03373, 30984, 37300, 37302, 37305, 37306 abrechenbar", action=ActionType.ENTFERNEN, gnr="03362", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("03362", c2.c, date) && patient.hasLeistung("03370|03371|03372|03373|30984|37300|37302|37305|37306", c2.c, date);
    }
}

