/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.b.a;

import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.SkipRuleInSingleMode;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class a {
    private static final String a = "108310400|108416214|108416225|108510413|108516419|108516420|108516431|108516442|108516453|108516464|108516475|108516486|108516497|108610425|108616001|108616034|108616513|108616524|108616535|108616546|108616557|108616568|108716002|108716024|108716115|108716126|108716137|108816003|108816811|108816822|108816833|108816844|108816855|108910473|108916004|108916618|108916629|108916630|108916641|108916652|108916663|108916709|109010432|109016007|109016314|109016325|109016336|109016347|109016358|109016369|109016370|109110444|109116008|109116714|109116725|109116736|109116747|109116758|109116769|109116770";
    private static final String b = "F32|F33|F34.1|F40|F41|F42|F45|F44|F43|F50|F51|F52|F6|F90|F91|F92|F93|F94|F95|F96|F97|F98";
    private static final String c = "F00.0|F00.1|F00.2|F00.9|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F04|F05.0|F05.1|F05.8|F06.0|F06.1|F06.2|F06.3|F06.4|F06.5|F06.6|F06.7|F06.8|F07.0|F07.1|F07.2|F07.8|F10.0|F10.1|F10.2|F10.3|F10.4|F10.5|F10.6|F10.7|F10.8|F20.0|F20.1|F20.2|F20.3|F20.4|F20.5|F20.6|F20.8|F21|F22.0|F22.8|F23.0|F23.1|F23.2|F23.3|F23.8|F24|F25.0|F25.1|F25.2|F25.8|G20.1|G20.2|G21.1|G21.2|G21.3|G21.4|G21.8|G30.0|G30.1|G30.8|G30.9|G35.0|G35.1|G35.2|G35.3|I24.1|I25.3|I25.5|I69.0|I69.1|I69.2|I69.3|I69.4|R47.0|R47.1|Z74.0|Z74.1|Z74.2|Z74.3";
    private static final String d = "E41|F03|F04|F05|F06|F07|F08|F09|F32|F33|F41|G20.3|G20.4|G20.5|G20.6|G20.7|G20.8|G20.9|G31|G32|G54.6|G81.0|G81.1|H81|H82|I60|I61|I62|I63|I64|I65|I66|I67|I68|I69|M80.0|M80.2|M80.3|M80.5|M80.8|N31.0|N39.3|N39.4|R13|R15|R26|R29.6|R32|R41|R42|R52.1|R54|R64|U50|U51|Z74|Z99.3";
    private static final String e = "M15.0|M15.3|M15.4|M15.8|M15.9|M17.0|M17.1|M17.2|M17.3|M17.4|M17.5|M17.6|M17.7|M17.8|M17.9|M40.05|M40.06|M40.07|M40.08|M40.15|M40.16|M40.17|M40.18|M40.25|M40.26|M40.27|M40.28|M40.35|M40.36|M40.37|M40.38|M40.45|M40.46|M40.47|M40.48|M40.55|M40.56|M40.57|M40.58|M41.05|M41.06|M41.07|M41.08|M41.15|M41.16|M41.17|M41.18|M41.25|M41.26|M41.27|M41.28|M41.35|M41.36|M41.37|M41.38|M41.45|M41.46|M41.47|M41.48|M41.55|M41.56|M41.57|M41.58|M41.85|M41.86|M41.87|M41.88|M41.95|M41.96|M41.97|M41.98|M42.05|M42.06|M42.07|M42.08|M42.15|M42.16|M42.17|M42.18|M42.95|M42.96|M42.97|M42.98|M43.05|M43.06|M43.07|M43.08|M43.15|M43.16|M43.17|M43.18|M43.25|M43.26|M43.27|M43.28|M43.55|M43.56|M43.57|M43.58|M43.85|M43.86|M43.87|M43.88|M43.95|M43.96|M43.97|M43.98|M45.05|M45.06|M45.07|M45.08|M46.05|M46.06|M46.07|M46.08|M46.25|M46.26|M46.27|M46.28|M46.35|M46.36|M46.37|M46.38|M46.45|M46.46|M46.47|M46.48|M46.55|M46.56|M46.57|M46.58|M46.85|M46.86|M46.87|M46.88|M46.95|M46.96|M46.97|M46.98|M47.05|M47.06|M47.07|M47.08|M47.15|M47.16|M47.17|M47.18|M47.25|M47.26|M47.27|M47.28|M47.85|M47.86|M47.87|M47.88|M47.95|M47.96|M47.97|M47.98|M48.05|M48.06|M48.07|M48.08|M48.15|M48.16|M48.17|M48.18|M48.25|M48.26|M48.27|M48.28|M48.35|M48.36|M48.37|M48.38|M48.45|M48.46|M48.47|M48.48|M48.55|M48.56|M48.57|M48.58|M48.85|M48.86|M48.87|M48.88|M48.95|M48.96|M48.97|M48.98|M49.05|M49.06|M49.07|M49.08|M49.15|M49.16|M49.17|M49.18|M49.25|M49.26|M49.27|M49.28|M49.35|M49.36|M49.37|M49.38|M49.45|M49.46|M49.47|M49.48|M49.55|M49.56|M49.57|M49.58|M49.85|M49.86|M49.87|M49.88|M51.0|M51.1|M51.2|M53.25|M53.26|M53.27|M53.28|M53.3|M53.85|M53.86|M53.87|M53.88|M53.95|M53.96|M53.97|M53.98|M54.15|M54.16|M54.17|M54.18|M54.4|M54.5|M54.85|M54.86|M54.87|M54.88|M54.95|M54.96|M54.97|M54.98|S32.00|S32.01|S32.02|S32.03|S32.04|S32.05|S32.1|S32.2|S32.3|S32.7|S32.81|S32.82|S32.83|S32.89|S33.0|S33.1|S33.10|S33.11|S33.12|S33.13|S33.14|S33.15|S33.2|S33.3|S33.4|S33.50|S33.51|S33.6|S33.7";
    private static int f;
    private static int g;
    private static boolean h;
    private static final g i;

    @RulePrerequisite
    public static boolean a(c c2) {
        if (!c2.a("Bayern")) {
            return false;
        }
        f = (int)c2.b.getPatients().stream().filter(patient -> patient.hasIk(a)).flatMap(patient -> patient.getLeistungen(c2.c).stream()).filter(i).filter(scheinLeistung -> Hzv.BAYERN_AOK.gnr("0000").equals(scheinLeistung.getGnr())).count();
        g = (int)c2.b.getPatients().stream().filter(patient -> patient.hasIk(a)).flatMap(patient -> patient.getLeistungen(c2.c).stream()).filter(i).filter(scheinLeistung -> Hzv.BAYERN_AOK.gnr("35100").equals(scheinLeistung.getGnr()) || Hzv.BAYERN_AOK.gnr("35110").equals(scheinLeistung.getGnr())).count();
        h = c2.b.getPatients().stream().filter(patient -> patient.hasIk(a)).flatMap(patient -> patient.getLeistungen(c2.c).stream()).anyMatch(scheinLeistung -> Hzv.BAYERN_AOK.gnr("1790").equals(scheinLeistung.getGnr()));
        return true;
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BAYERN_AOK);
    }

    @Rule(name="HzV AOK Pauschale f\u00fcr nicht pers\u00f6nlichen oder telefonischen APK (1112) nicht neben Grundpauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="1112", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1112"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) ohne 2 pers\u00f6nliche Arzt-Patienten-Kontakte angesetzt", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0003"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0000"), c2.c) < 2;
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) ansetzbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0000"), c2.c) > 1 && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.c(), true, c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0003|0002|0004"), c2.c) && !patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Pauschale onkologischer Patienten (0002) ohne gesicherte onkologische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0002", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c);
    }

    @Rule(name="HzV AOK onkologische Leitdiagnose ({dia}) bei einem haus\u00e4rztlich betreuten Patienten vorhanden, ohne Pauschale onkologische Patienten (0002)", action=ActionType.UEBERPRUEFEN, gnr="0002", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (!patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c)) {
            return false;
        }
        action.setParameter("dia", patient.getFirstDiagnose(com.nhochdrei.kvdt.data.a.d(), c2.c));
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK onkologisches Konsil (2009) ohne onkologische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="2009", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2009"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c);
    }

    @Rule(name="HzV AOK kontaktabh\u00e4ngige Vertreterpauschale (0004) in BAG oder MVZ nicht abrechenbar, nur bei Einrichtungswechsel des Patienten", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c) && (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.e) || patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.d));
    }

    @Rule(name="HzV AOK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht \u00f6fter als 2 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0004"), c2.c) > 2;
    }

    @Rule(name="HzV AOK Zielauftragspauschale (0005) nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0005"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Pauschale Palliativpatienten ({gnr}) ohne gesicherte Leitdiagnose Palliativbehandlung Z51.5", action=ActionType.UEBERPRUEFEN, gnr="0001|0001A|0001B|0001C|0001D|0001E|0001F", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV AOK gesicherte Leitdiagnose Palliativbehandlung Z51.5 bei einem haus\u00e4rztlich betreuten Patienten vorhanden, ohne Pauschale Palliativmedizin", action=ActionType.NACHTRAGEN, gnr="0001", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && patient.hasDiagnose("Z51.5", true, c2.c) && !patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale Palliativmedizin (0001*) nicht neben Pauschale Onkologie Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0002", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale Palliativmedizin (0001*) nicht neben Chronikerpauschale (0003) abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV AOK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Pauschale Palliativmedizin (0001*) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV AOK Zielauftragspauschale (0005) nicht neben Pauschale Palliativmedizin (0001*) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale Palliativpatienten ({gnr}) ist nur bei mehr als einem pers\u00f6nlichen Arzt-Patienten-Kontakt im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0001|0001A|0001B|0001C|0001D|0001E|0001F", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasHzvLeistungBeginntMit(string, Hzv.BAYERN_AOK, c2.c) && patient.getAPKCount(false, c2.c) < 2L;
    }

    @Rule(name="HzV AOK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Pauschale onkologischer Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV AOK Zielauftragspauschale (0005) nicht neben Pauschale onkologischer Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale onkologischer Patienten (0002) ist nur bei mehr als einem pers\u00f6nlichen Arzt-Patienten-Kontakt im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0002", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.getAPKCount(false, c2.c) < 2L && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale Onkologiepatienten (0002) nicht neben Chronikerpauschale (0003) abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV AOK onkologisches Konsil (2009) ist nur durch den Betreuungsarzt abrechenbar, nicht im Vertretungsfall", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2009"), c2.c);
    }

    @Rule(name="HzV AOK onkologisches Konsil (2009) ist nur durch den Betreuungsarzt abrechenbar, nicht im Auftragsfall", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0005"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2009"), c2.c);
    }

    @Rule(name="HzV AOK onkologisches Konsil (2009) ist nicht \u00f6fter als 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2009", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("2009"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Pauschale Onkologiepatienten (0002) abgerechnet, eventuell ist ein onkologisches Konsil (2009) erfolgt, jedoch nicht abgerechnet worden", action=ActionType.NACHTRAGEN, gnr="2009", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2009"), c2.c);
    }

    @Rule(name="HzV AOK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Zielauftragspauschale (0005) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV AOK Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV AOK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BAYERN_AOK.gnr("0000"))).getLanr();
            } else if (patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.b(Hzv.BAYERN_AOK.gnr("0001"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BAYERN_AOK.gnr("0002"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BAYERN_AOK.gnr("0004"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV AOK Doppelabrechnung von Betreuungspauschalen (0000, 0001*, 0002 oder 0004) im HzV-Schein und der Versichertenpauschale (0300*) im KV-Schein ist ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasHzvLeistungBeginntMit("0000|0001|0002|0004", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV AOK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String z(c c2, Patient patient) {
        if (!patient.hasHzvLeistungBeginntMit("0000|0001|0002|0004", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasHzvLeistungBeginntMit("0001", Hzv.BAYERN_AOK, Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose("Z51.5", true, c2.c)) {
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001A"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("G71.0|G71.2|G11.0|G11.1|G11.3|G11.4|G11.8|G11.9|G12.0|G12.1|G80.0|G80.1|G80.2|G80.3|G80.4|G80.8|G80.9|G93.1", "G", c2.c)) {
                    return "0001A";
                }
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001B"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G37.0|G37.1|G37.2|G37.3|G37.4|G37.5|G37.8|G37.9|G10|G11.2|G12.1|G12.2|G12.8|G13.0|G13.1|G13.2|G20.10|G20.11|G20.20|G20.21|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F03|J43.0|J43.1|J43.2|J43.8|J43.9|J44.80", "G", c2.c)) {
                    return "0001B";
                }
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001C"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("C78.0|C78.1|C78.2|C78.3|C78.4|C78.5|C78.6|C78.7|C78.8|C79.0|C79.1|C79.2|C79.3|C79.4|C79.5|C79.6|C79.7|C79.81|C79.82|C79.83|C79.84|C79.85|C79.86|C79.88", "G", c2.c)) {
                    return "0001C";
                }
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001D"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("G82.02|G82.03|G82.12|G82.13|G82.22|G82.23|G82.32|G82.33|G82.42|G82.43|G82.52|G82.53|G81.0|G81.1|G83.5", "G", c2.c)) {
                    return "0001D";
                }
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001E"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9", "G", c2.c) && patient.hasDiagnoseBeginntMit("G30.0|G30.1|G30.8|G30.9", "G", c2.c)) {
                    return "0001E";
                }
                if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001F"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnoseBeginntMit("F50.00|F50.01|F50.2|F50.3|R54|R63.0|R63.3|R63.4|R63.6|R63.8|R64", "G", c2.c)) {
                    return "0001F";
                }
                return "0001";
            }
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c)) {
                return "0002";
            }
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV AOK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV AOK {gnr} ist bei HzV eingeschriebenen Patienten \u00fcber den KV-Schein abzurechnen", action=ActionType.UEBERPRUEFEN, gnr="32026|32027|32128|32135|32150", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c);
    }

    @Rule(name="HzV AOK Inanspruchnahme zur Unzeit (01100.2) ist nicht neben dem Hausbesuch (1410) abrechenbar, es sei denn der Patient wurde mehrmals am gleichen Tag besucht", action=ActionType.ENTFERNEN, gnr="01100.2", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01100.2"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1410"), c2.c, date);
    }

    @Rule(name="HzV AOK Inanspruchnahme zur Unzeit (01100.2) ist nicht mehrfach am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01100.2", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_AOK.gnr("01100.2"), c2.c, date) > 1;
    }

    @Rule(name="HzV AOK im Hausbesuch (1410) kann auch eine Wegepauschale (4401, 4402, 4403) abgerechnet werden", action=ActionType.NACHTRAGEN, hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static String d(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1410"), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("4401|4402|4403"), c2.c, date)) {
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("4401"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4401";
            }
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("4402"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4402";
            }
            if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("4403"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4403";
            }
            return "4401";
        }
        return null;
    }

    @Rule(name="HzV AOK neben der Wegepauschale (4401, 4402, 4403) sollte auch immer ein Hausbesuch abgerechnet werden", action=ActionType.NACHTRAGEN, gnr="4401|4402|4403", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1410"), c2.c, date);
    }

    @Rule(name="HzV AOK verschiedene Wegeziffern bei dem gleichen Patienten abgerechnet", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static String A(c c2, Patient patient) {
        List list = patient.getLeistungen(c2.c).stream().filter(com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BAYERN_AOK.gnr("4401|4402|4403"))).map(ScheinLeistung::getGnr).distinct().collect(Collectors.toList());
        if (list.size() > 1) {
            return list.stream().map(string -> string.substring(0, 4)).collect(Collectors.joining("/"));
        }
        return null;
    }

    @Rule(name="HzV AOK im Mitbesuch (1413) ist keine Wegepauschale (4401, 4402, 4403) abrechenbar", action=ActionType.ENTFERNEN, gnr="4401|4402|4403", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1413"), c2.c, date);
    }

    @Rule(name="HzV AOK Mitbesuch (1413) ist nicht mehrfach am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="1413", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getAPK(false, c2.c, 2L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BAYERN_AOK.gnr("1413")), date) != null;
    }

    @Rule(name="HzV AOK am Tag eines Mitbesuches (1413) ist keine Vertreterpauschale (0004) abrechenbar", action=ActionType.ENTFERNEN, gnr="1413", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1413"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c, date);
    }

    @Rule(name="HzV AOK Zuschlag zur 1410 f\u00fcr Besuche bei Inanspruchnahme zu Unzeiten (1410Z) ist nicht neben der Inanspruchnahme zu Unzeiten (01100.2) abrechenbar", action=ActionType.ENTFERNEN, gnr="01100.2", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1410Z"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01100.2"), c2.c, date);
    }

    @Rule(name="HzV AOK VERAH-Besuch (1417) ist nur bei chronisch Kranken (0003), Palliativpatienten (0001*), Onko-Patienten (0002) oder bei geriatrischen Patienten m\u00f6glich", action=ActionType.UEBERPRUEFEN, gnr="1417", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1417"), c2.c) && !patient.hasHzvLeistungBeginntMit("0003|0001|0002", Hzv.BAYERN_AOK, c2.c) && !patient.hasDiagnoseBeginntMit(c, "G", c2.c) && !patient.hasDiagnoseBeginntMit(d, "G", c2.c);
    }

    @Rule(name="HzV AOK VERAH-Besuch (1417) ist nur maximal 3 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("1417"), c2.c) > 3;
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c) && !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist alle 2 Kalenderjahre abrechenbar", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean E(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit(Hzv.BAYERN_AOK.gnr("0000|0001|0002"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV AOK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist nur 1 Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), Quartal.getBisVorjahrOhneAq(c2.c));
    }

    @Rule(name="HzV AOK Zuschlag zur Gesundheitsuntersuchung ab 45 Jahren (1790) ist erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="1790", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV AOK Zuschlag zur Gesundheitsuntersuchung ab 45 Jahren (1790) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1790", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), c2.c);
    }

    @Rule(name="HzV AOK Zuschlag zur Gesundheitsuntersuchung ab 45 Jahren (1790) ist alle 2 Kalenderjahre abrechenbar", action=ActionType.NACHTRAGEN, gnr="1790", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    @SkipRuleInSingleMode
    public static boolean H(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return h && patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("01732"), 1L, c2.c).getDatum()) > 44 && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), c2.c);
    }

    @Rule(name="HzV AOK Zuschlag zur Gesundheitsuntersuchung ab 45 Jahren (1790) ist nur neben der Gesundheitsuntersuchung ab 35 Jahren (01732) abrechenbar", action=ActionType.ENTFERNEN, gnr="1790", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c, date);
    }

    @Rule(name="HzV AOK Zuschlag zur Gesundheitsuntersuchung ab 45 Jahren (1790) ist nur 1 Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="1790", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1790"), Quartal.getBisVorjahrOhneAq(c2.c));
    }

    @Rule(name="HzV AOK Beratung zum Ultraschallscreening Bauchaorta (1791A) ist erst ab einem Lebensalter von 65 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="1791A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("1791A"), 1L, c2.c).getDatum()) < 65;
    }

    @Rule(name="HzV AOK Ultraschallscreening Bauchaorta (1791B) ist erst ab einem Lebensalter von 65 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="1791B", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("1791B"), 1L, c2.c).getDatum()) < 65;
    }

    @Rule(name="HzV AOK Beratung zum Ultraschallscreening Bauchaorta (1791A)", action=ActionType.POTENTIAL, gnr="1791A", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean L(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasHzvLeistungBeginntMit("1791A", Hzv.BAYERN_AOK, Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 64 && "M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV AOK Ultraschallscreening Bauchaorta (1791B)", action=ActionType.POTENTIAL, gnr="1791B", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean M(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasHzvLeistungBeginntMit("1791B", Hzv.BAYERN_AOK, Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 64 && "M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV AOK Beratung zum Ultraschallscreening Bauchaorta (1791A) ist nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="1791A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A"), c2.c) && (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A"), Arrays.asList(c2.d, c2.e, c2.f, c2.g)) || patient.hasLeistung("01747", Arrays.asList(c2.d, c2.e, c2.f, c2.g)));
    }

    @Rule(name="HzV AOK Beratung zum Ultraschallscreening Bauchaorta (1791A) ist nicht neben 1791C abrechenbar", action=ActionType.ENTFERNEN, gnr="1791A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791C"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV AOK Ultraschallscreening Bauchaorta (1791B) ist nicht neben 1791C abrechenbar", action=ActionType.ENTFERNEN, gnr="1791B", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791C"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV AOK 1791C ist nicht neben 1791A/B abrechenbar", action=ActionType.ENTFERNEN, gnr="1791C", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791C"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A|1791B"), Arrays.asList(c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV AOK Ultraschallscreening Bauchaorta (1791B) ist nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="1791B", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), c2.c) && (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), Arrays.asList(c2.d, c2.e, c2.f, c2.g)) || patient.hasLeistung("01748", Arrays.asList(c2.d, c2.e, c2.f, c2.g)));
    }

    @Rule(name="HzV AOK Hautkrebsscreening ohne Gesundheitsuntersuchung (01745) ist alle 2 Kalenderjahre abrechenbar", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean S(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit(Hzv.BAYERN_AOK.gnr("0000|0001|0002"), 1L, c2.c).getDatum()) > 17 && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01746"), Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="HzV AOK Hautkrebsscreening zus\u00e4tzlich zur Gesundheitsuntersuchung (01746) ist alle 2 Kalenderjahre abrechenbar", action=ActionType.POTENTIAL, gnr="01746", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean T(c c2, Patient patient) {
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c) && patient.getAlterAnTag(patient.getLeistungBeginntMit(Hzv.BAYERN_AOK.gnr("0000|0001|0002"), 1L, c2.c).getDatum()) > 34 && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01745"), Quartal.getBisVorjahr(c2.c)) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01746"), Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="HzV AOK Zuschlag Hautkrebsscreening (01746) ohne Gesundheitsuntersuchung (01732), eventuell als 01745 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01746", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01746"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01732"), c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening und Zuschlag Hautkrebsscreening sind innerhalb von 2 Kalenderjahren nur 1 Mal und nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="01745|01746", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01745|01746"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Hautkrebsscreening ohne Gesundheitsuntersuchung (01745) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01745"), c2.c) && !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Beratung zum Bauchaortenaneurysmascreening (1791A) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1791A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791A"), c2.c) && !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Hautkrebsscreening zus\u00e4tzlich zur Gesundheitsuntersuchung (01746) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01746"), c2.c) && !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT_UROLOGIE)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && "M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) ist erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) ist nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Krebsvorsorge Mann (01731) ist nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), c2.c) && !"M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV AOK f\u00fcr die Krebsvorsorge Mann (01731) ist die Vorsorgediagnose Z12.5 gesichert zur Abrechung vorgesehen", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV AOK Vorsorgediagnose Z12.5 gesichert wurde abgerechnet, die Krebsvorsorge Mann (01731) in der Ansetzung vergessen", action=ActionType.NACHTRAGEN, gnr="01731", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ac(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01731"), c2.c) && patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ad(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01712"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 2 && patient.getAlterInTage() < 15;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ae(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01713"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 14 && patient.getAlterInTage() < 50;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean af(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01714"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 30 && patient.getAlterInTage() < 136;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ag(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01715"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 120 && patient.getAlterInTage() < 241;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ah(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01716"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 240 && patient.getAlterInTage() < 421;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7 (01717) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ai(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01717"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 570 && patient.getAlterInTage() < 811;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7a (01723) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aj(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01723"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 960 && patient.getAlterInTage() < 1141;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U8 (01718) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ak(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01718"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 1260 && patient.getAlterInTage() < 1501;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U9 (01719) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean al(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage() > 1710 && patient.getAlterInTage() < 1981;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U10 (1725) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1725", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean am(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1725"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 6 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 9;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U11 (1726) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1726", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean an(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1726"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 8 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 11;
    }

    @Rule(name="HzV AOK Jugendvorsorgeuntersuchung J1 (01720) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ao(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="HzV AOK Jugendvorsorgeuntersuchung J2 (1724) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1724", hzv=Hzv.BAYERN_AOK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean ap(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1724"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 15 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 18;
    }

    @Rule(name="HzV AOK Hautkrebsscreening zur Gesundheitsuntersuchung (01746) ist erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01746"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV AOK Hautkrebsscreening (01745) ist erst ab einem Alter von 18 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 18;
    }

    @Rule(name="HzV AOK U-Untersuchung {gnr} ohne Vorsorgediagnose Z00.1 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV AOK J-Untersuchung {gnr} ohne Vorsorgediagnose Z00.3 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01720|01724", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV AOK U-Vorsorgediagnose Z00.1 gesichert vorhanden und eventuell Abrechnungsziffer U-Untersuchung noch nicht angesetzt", gnr="01712/01713/01714/01715/01716/01717/01718/01719/1725/1726/01723", action=ActionType.NACHTRAGEN, hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV AOK J-Vorsorgediagnose Z00.3 gesichert vorhanden und eventuell Abrechnungsziffer J-Untersuchung noch nicht angesetzt", gnr="01720/01724", action=ActionType.NACHTRAGEN, hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01720|01724"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV AOK Vorsorgeuntersuchungen {gnr} sind nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723|01720|1724", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr(string), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV AOK Impfziffern ({gnr}) sind nur auf dem HzV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="89*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, String string) {
        if (Hzv.BAYERN_AOK.hasVertragsIdentifikator(string)) {
            return false;
        }
        return patient.hasLeistung(string, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK OP-Vorbereitungsziffer ({gnr}) ist in der Grundpauschalen (0000, 0001*, 0002) vorhanden und damit nicht zu Lasten der Kasse abrechenbar", action=ActionType.ENTFERNEN, gnr="31010|31011|31012|31013")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, String string) {
        return (patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) || patient.hasLeistung(string, c2.c)) && patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK postoperative Betreuung (31600) ist nicht \u00fcber den KV-Schein oder HzV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="31600", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("31600"), c2.c) || patient.hasLeistung("31600", c2.c);
    }

    @Rule(name="HzV AOK Aufzeichnung Langzeit-EKG (03322) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="03322", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("03322"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Auswertung Langzeit-EKG (03241) ist nur \u00fcber den KV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="03241", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean au(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03241"), c2.c);
    }

    @Rule(name="HzV AOK Langzeit-Blutdruckmessung (03324) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="03324", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("03324"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Sonographie Abdomen (33042) nicht am gleichen Tag wie das Bauchaortenaneurysmascreening (1791B) abrechenbar", action=ActionType.ENTFERNEN, gnr="1791B", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("33042"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), c2.c, date);
    }

    @Rule(name="HzV AOK 1791C ist nicht neben Sonographie Abdomen (33042/33042A) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="1791C", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("33042|33042A"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791C"), c2.c, date);
    }

    @Rule(name="HzV AOK Sonographie Abdomen (33042A) am gleichen Tag wie das Bauchaortenaneurysmascreening (1791B) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="33042A", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("33042A"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("1791B"), c2.c, date);
    }

    @Rule(name="HzV AOK Psychosomatik / Differentialdiagnostik (35100) ist nicht am gleichen Tag wie die verbale Intervention (35110) abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("35100"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV AOK psychosomatische verbale Intervention ({gnr}) ist maximal 3 Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="35110|35110B|35110C", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_AOK.gnr("35110|35110B|35110C"), c2.c, date) > 3;
    }

    @Rule(name="HzV AOK unidirektionaler Doppler (2000) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2000", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("2000"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Akupunktur Eingangs- und Schlussdiagnostik (30790) ist nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="30790", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ax(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("30790"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("30790"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV AOK Manualmedizin (30201) ist nur zwei Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="30201", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ay(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("30201"), c2.c) > 2;
    }

    @Rule(name="HzV AOK CW-Doppler extrakranielle Gef\u00e4\u00dfe (33060) ist nur zwei Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="33060", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("33060"), c2.c) > 2;
    }

    @Rule(name="HzV AOK CW-Doppler extrakranielle Gef\u00e4\u00dfe (33060) ist nicht am gleichen Tag wie der unidirektionale Doppler (2000) abrechenbar", action=ActionType.ENTFERNEN, gnr="2000", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("33060"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2000"), c2.c, date);
    }

    @Rule(name="HzV AOK CW-Doppler extremit\u00e4tenversorgende Gef\u00e4\u00dfe (33061) ist nicht am gleichen Tag wie der unidirektionale Doppler (2000) abrechenbar", action=ActionType.ENTFERNEN, gnr="2000", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("33061"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2000"), c2.c, date);
    }

    @Rule(name="HzV AOK Anzahl der abgerechneten psychosomatischen Ziffern (35100 und 35110) sollte 25% der Anzahl der Grundpauschalen (0000) nicht \u00fcbersteigen", action=ActionType.UEBERPRUEFEN, gnr="35100|35110", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    @SkipRuleInSingleMode
    public static boolean aA(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BAYERN_AOK.gnr("35100|35110"), c2.c)) {
            return false;
        }
        if (f <= 0) {
            return g > 0;
        }
        return (double)g / (double)f > 0.25;
    }

    @Rule(name="HzV AOK Akupunkturleistung ({gnr}) ohne Diagnose der Qualit\u00e4tssicherungsvereinbarung Akupunktur", action=ActionType.UEBERPRUEFEN, gnr="30790|30791", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && !patient.hasDiagnose(e, true, c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) ist nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03360", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean aB(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("03360"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="03360", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aC(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="03360", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aD(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) ist nur ab einem Alter von 70 Jahren abrechnungsf\u00e4hig, es sei denn, der Patient hat eine spezifische Diagnose (Alzheimer, Parkinson, Demenz\u2026)", action=ActionType.UEBERPRUEFEN, gnr="03360", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("03360"), 1L, c2.c).getDatum()) < 70 && !patient.hasDiagnoseBeginntMit(c, "G", c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) Patient \u00e4lter als 69 Jahre.", action=ActionType.POTENTIAL, gnr="03360", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aF(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 69 && (patient.hasDiagnoseBeginntMit(c, "G", c2.c) || patient.hasDiagnoseBeginntMit(d, "G", c2.c));
    }

    @Rule(name="HzV AOK haus\u00e4rztliches geriatrisches Basisassessment (03360) Patient j\u00fcnger als 70 Jahre, es liegt eine spezifische geriatrische Diagnose vor", action=ActionType.POTENTIAL, gnr="03360", hzv=Hzv.BAYERN_AOK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aG(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 70 && patient.hasDiagnoseBeginntMit(c, "G", c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aH(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("03362"), c2.c) > 1;
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ist nur mit geriatriespezifischer Diagnose m\u00f6glich", action=ActionType.UEBERPRUEFEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aI(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && !patient.hasDiagnoseBeginntMit(c, "G", c2.c) && !patient.hasDiagnoseBeginntMit(d, "G", c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ben\u00f6tigt 2 pers\u00f6nliche Arzt-Patienten-Kontakte im Quartal", action=ActionType.ENTFERNEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aJ(c c2, Patient patient) {
        return patient.getAPKCount(false, c2.c) < 2L && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) m\u00f6glich, da mehrere pers\u00f6nliche Arzt-Patienten-Kontakte im Quartal", action=ActionType.NACHTRAGEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aK(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && patient.getAPKCount(false, c2.c) > 1L && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && (patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) > 69 && (patient.hasDiagnoseBeginntMit(c, "G", c2.c) || patient.hasDiagnoseBeginntMit(d, "G", c2.c)) || patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c).getDatum()) < 70 && patient.hasDiagnoseBeginntMit(c, "G", c2.c));
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aL(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && !patient.hasHzvLeistungBeginntMit("0000|0001|0002", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aM(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ist nur abrechnungsf\u00e4hig wenn im aktuellen Quartal oder den 3 Vorquartalen ein geriatrisches Basisassessment druchgef\u00fchrt wurde", action=ActionType.ENTFERNEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aN(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03360"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && (patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("03362"), 1L, c2.c).getDatum()) > 69 && (patient.hasDiagnoseBeginntMit(c, "G", c2.c) || patient.hasDiagnoseBeginntMit(d, "G", c2.c)) || patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("03362"), 1L, c2.c).getDatum()) < 70 && patient.hasDiagnoseBeginntMit(c, "G", c2.c));
    }

    @Rule(name="HzV AOK haus\u00e4rztliche geriatrische Betreuung (03362) ist nur ab einem Alter von 70 Jahren abrechenbar es sei denn, der Patient hat eine spezifische Diagnose (Alzheimer, Parkinson, Demenz\u2026)", action=ActionType.UEBERPRUEFEN, gnr="03362", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aO(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("03362"), c2.c) && (patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("03362"), 1L, c2.c).getDatum()) < 70 && !patient.hasDiagnoseBeginntMit(c, "G", c2.c) || patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_AOK.gnr("03362"), 1L, c2.c).getDatum()) > 69 && !patient.hasDiagnoseBeginntMit(c, "G", c2.c) && !patient.hasDiagnoseBeginntMit(d, "G", c2.c));
    }

    @Rule(name="HzV AOK chronische Wunde (2310) ist maximal 6 mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2310", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aP(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("2310"), c2.c) > 6;
    }

    @Rule(name="HzV AOK chronische Wunden (2310) kann nicht am gleichen Tag wie andere Wundziffer (2301 oder 02311) abgerechnet werden", action=ActionType.ENTFERNEN, gnr="2310", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2310"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("2301|02311"), c2.c, date);
    }

    @Rule(name="HzV AOK Psychosomatik / Differentialdiagnostik (35100) und die verbale Intervention (35110) erfordern eine leitliniengerechte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="35100|35110|35110B|35110C", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="HzV AOK gesicherte leitliniengerechte Diagnose ohne psychosomatische Ziffer ({gnr})", action=ActionType.UEBERPRUEFEN, gnr="35100|35110", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, String string) {
        return !patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c) && patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="HzV AOK Zuschl\u00e4ge zu Hausbesuchen (37305) und dringenden Hausbesuchen (37306) sind nicht gegen\u00fcber der KVB abrechenbar", action=ActionType.ENTFERNEN, gnr="37305|37306")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.hasHzvLeistungBeginntMit("0000|0001", Hzv.BAYERN_AOK, c2.c);
    }

    @Rule(name="HzV AOK Behandlung diabetischer Fu\u00df (02311) ben\u00f6tigt Diabetesdiagnose", action=ActionType.UEBERPRUEFEN, gnr="02311", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aQ(c c2, Patient patient) {
        return !patient.hasDiagnose("E10.74|E10.75|E11.74|E11.75|E12.74|E12.75|E13.74|E13.75|E14.74|E14.75", true, c2.c) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr("02311"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale Palliativmedizin (0001) darf maximal 5 Quartale abgerechnet werden", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aR(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g, c2.h)) > 5;
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch juvenile Grunderkrankung begr\u00fcndet (0001A) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aS(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001A"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001A", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("G71.0|G71.2|G11.0|G11.1|G11.3|G11.4|G11.8|G11.9|G12.0|G12.1|G80.0|G80.1|G80.2|G80.3|G80.4|G80.8|G80.9|G93.1", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch adulte Grunderkrankung begr\u00fcndet (0001B) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001B", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aT(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001B"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001B", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G37.0|G37.1|G37.2|G37.3|G37.4|G37.5|G37.8|G37.9|G10|G11.2|G12.1|G12.2|G12.8|G13.0|G13.1|G13.2|G20.10|G20.11|G20.20|G20.21|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F03|J43.0|J43.1|J43.2|J43.8|J43.9|J44.80", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung bei onkologischer Grunderkrankung (0001C) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001C", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aU(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001C"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001C", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("C78.0|C78.1|C78.2|C78.3|C78.4|C78.5|C78.6|C78.7|C78.8|C79.0|C79.1|C79.2|C79.3|C79.4|C79.5|C79.6|C79.7|C79.81|C79.82|C79.83|C79.84|C79.85|C79.86|C79.88", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung bei Erkrankungen mit L\u00e4hmungserscheinungen (0001D) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001D", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aV(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001D"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001D", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("G82.02|G82.03|G82.12|G82.13|G82.22|G82.23|G82.32|G82.33|G82.42|G82.43|G82.52|G82.53|G81.0|G81.1|G83.5", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch Demenz begr\u00fcndet (0001E) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001E", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aW(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001E"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001E", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9", "G", c2.c) && patient.hasDiagnoseBeginntMit("G30.0|G30.1|G30.8|G30.9", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung mit Mangelern\u00e4hrung (0001F) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0001F", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean aX(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001F"), c2.c) && (patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001"), Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g)) == 5 || patient.hasLeistung("0001F", c2.d)) && patient.hasDiagnoseBeginntMit("Z51.5", "G", c2.c) && patient.hasDiagnoseBeginntMit("F50.00|F50.01|F50.2|F50.3|R54|R63.0|R63.3|R63.4|R63.6|R63.8|R64", "G", c2.c) && !patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch juvenile Grunderkrankung begr\u00fcndet (0001A) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001A", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aY(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001A"), c2.c) && !patient.hasDiagnoseBeginntMit("G71.0|G71.2|G11.0|G11.1|G11.3|G11.4|G11.8|G11.9|G12.0|G12.1|G80.0|G80.1|G80.2|G80.3|G80.4|G80.8|G80.9|G93.1", "G", c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch adulte Grunderkrankung begr\u00fcndet (0001B) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001B", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aZ(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001B"), c2.c) && !patient.hasDiagnoseBeginntMit("G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G37.0|G37.1|G37.2|G37.3|G37.4|G37.5|G37.8|G37.9|G10|G11.2|G12.1|G12.2|G12.8|G13.0|G13.1|G13.2|G20.10|G20.11|G20.20|G20.21|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F03|J43.0|J43.1|J43.2|J43.8|J43.9|J44.80", "G", c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung bei onkologischer Grunderkrankung (0001C) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001C", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ba(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001C"), c2.c) && !patient.hasDiagnoseBeginntMit("C78.0|C78.1|C78.2|C78.3|C78.4|C78.5|C78.6|C78.7|C78.8|C79.0|C79.1|C79.2|C79.3|C79.4|C79.5|C79.6|C79.7|C79.81|C79.82|C79.83|C79.84|C79.85|C79.86|C79.88", "G", c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung bei Erkrankungen mit L\u00e4hmungserscheinungen (0001D) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001D", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bb(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001D"), c2.c) && !patient.hasDiagnoseBeginntMit("G82.02|G82.03|G82.12|G82.13|G82.22|G82.23|G82.32|G82.33|G82.42|G82.43|G82.52|G82.53|G81.0|G81.1|G83.5", "G", c2.c);
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung durch Demenz begr\u00fcndet (0001E) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001E", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bc(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001E"), c2.c) && (!patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9", "G", c2.c) || !patient.hasDiagnoseBeginntMit("G30.0|G30.1|G30.8|G30.9", "G", c2.c));
    }

    @Rule(name="HzV AOK Pauschale l\u00e4ngere Palliativbehandlung mit Mangelern\u00e4hrung (0001F) ohne entsprechend gesichertes Krankheitsbild", action=ActionType.UEBERPRUEFEN, gnr="0001F", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bd(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0001F"), c2.c) && !patient.hasDiagnoseBeginntMit("F50.00|F50.01|F50.2|F50.3|R54|R63.0|R63.3|R63.4|R63.6|R63.8|R64", "G", c2.c);
    }

    @Rule(name="HzV AOK Pauschalen Palliativbehandlung nicht nebeneinander abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0001/0001A/0001B/0001C/0001D/0001E/0001F", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean be(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0001|0001A|0001B|0001C|0001D|0001E|0001F"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechnebar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bf(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Zielauftragspaushale DSP (Diabetologische Schwerpunktpraxis) (0005D) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date, String string) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0005D"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_AOK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV AOK Zielauftragspaushale DSP (Diabetologische Schwerpunktpraxis) (0005D) nur zwei Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0005D", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date, String string) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("0005D"), c2.c) > 2;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bg(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01711"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01711"), c2.c, date) && patient.getAlterAnTag(date) > 2;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) nur einmal zwischen 3. und 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bh(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01712"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag und nur bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01712"), c2.c, date) && (patient.getAlterAnTag(date) < 3 || patient.getAlterAnTag(date) > 14);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bi(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01713"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U3 (01713) nur zwischen 3. und 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01713"), c2.c, date) && (patient.getAlterAnTag(date) < 15 || patient.getAlterAnTag(date) > 49);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bj(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01714"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U4 (01714) nur zwischen 2. und 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01714"), c2.c, date) && (patient.getAlterAnTag(date) < 30 || patient.getAlterAnTag(date) > 136);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bk(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01715"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U5 (01715) nur zwischen 5. und 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01715"), c2.c, date) && (patient.getAlterAnTag(date) < 120 || patient.getAlterAnTag(date) > 241);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bl(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01716"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U6 (01716) nur zwischen 9. und 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01716"), c2.c, date) && (patient.getAlterAnTag(date) < 241 || patient.getAlterAnTag(date) > 420);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7 (01717) nur einmal bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bm(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01717"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7 (01717) nur zwischen 20. und 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01717"), c2.c, date) && (patient.getAlterAnTag(date) < 571 || patient.getAlterAnTag(date) > 810);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7a (01723) nur einmal bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bn(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01723"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U7a (01723) nur zwischen 34. und 36. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01723"), c2.c, date) && (patient.getAlterAnTag(date) < 960 || patient.getAlterAnTag(date) > 1141);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U8 (01718) nur einmal bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bo(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01718"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U8 (01718) nur zwischen 43. und 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01718"), c2.c, date) && (patient.getAlterAnTag(date) < 1260 || patient.getAlterAnTag(date) > 1501);
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U9 (01719) nur einmal bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BAYERN_AOK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean bp(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_AOK.gnr("01719"), c2.c) > 1;
    }

    @Rule(name="HzV AOK Kindervorsorgeuntersuchung U9 (01719) nur zwischen 58. und 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BAYERN_AOK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_AOK.gnr("01719"), c2.c, date) && (patient.getAlterAnTag(date) < 1711 || patient.getAlterAnTag(date) > 1980);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BAYERN_AOK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BAYERN_AOK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }

    static {
        i = new g("01", "02", "03", "34", "35", "36", "37", "38", "39");
    }
}

