/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.misc;

import com.nhochdrei.kvdt.model.ScheinLeistung;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Hzv {
    KEIN_HZV(""),
    BUNDESWEIT_IKK("SI_IKK_HZV"),
    BUNDESWEIT_TK("TK_HZV"),
    BUNDESWEIT_BKKGWQ("BKK_GWQ_HZV"),
    BUNDESWEIT_BKKSPECTRUM("BKK_SPECTRUM_HZV"),
    BUNDESWEIT_LKK("LKK_HZV"),
    BUNDESWEIT_HKK("HKK_HZV_NORD"),
    BUNDESWEIT_DAK("DAK_HZV"),
    BUNDESWEIT_BAHNBKK("BKK_BAHN_HZV"),
    BAYERN_AOK("AOK_BY_HZV_S15"),
    BAYERN_BKK("BKK_BY_HZV"),
    BAYERN_EK("EK_BY_HZV_S12"),
    BAYERN_LKK("LKK_BY_HZV"),
    BW_AOK("AWH_01"),
    BW_AOK_MODUL("AOK_BW_IV_P"),
    BW_BKK("BKK_BW_HZV"),
    BW_BKKVAG("BKK_VAG_BW"),
    BW_BOSCHBKK("BKK_BOSCH_BW"),
    BW_EK("EK_BW_HZV"),
    BW_IKK("IKK_CL_BW_HZV"),
    BW_KBS("RV_KBS_BW_HZV"),
    BW_LKK("LKK_BW_HZV"),
    BW_AOK_PNEUMOLOGIE("AOK_FA_PNEUMO_BW"),
    BW_AOK_GASTRO("AOK_FA_GASTRO_BW"),
    BW_AOK_KARDIO("AOK_FA_KARDIO_BW"),
    BW_AOK_ORTH_CHIR("AOK_FA_OC_BW"),
    BW_AOK_PSYCH("AOK_FA_NPPP_BW"),
    BW_AOK_UROLOGIE("AOK_FA_URO_BW"),
    BW_AOK_NEPHRO("AOK_FR_NEPHRO_BW"),
    BW_BOSCHBKK_GASTRO("BKK_FA_GASTRO_BW"),
    BW_BOSCHBKK_KARDIO("BKK_FA_KARDIO_BW"),
    BW_BOSCHBKK_ORTH_CHIR("BKK_FA_OC_BW"),
    BW_BOSCHBKK_PSYCH("BKK_BOSCH_FA_BW"),
    BW_BOSCHBKK_UROLOGIE("BKK_FA_URO_BW"),
    BW_BOSCHBKK_PNEUMOLOGIE("BKK_FA_PNEUMO_BW"),
    BW_BKKVAG_GASTRO("VAG_FA_GASTRO_BW"),
    BW_BKKVAG_KARDIO("VAG_FA_KARDIO_BW"),
    BW_PSYCH("MEDI_FA_PT_BW"),
    BW_EK_DIABETOLOGIE("EK_FA_DIA_BW"),
    HH_AOK("AOK_HH_HZV"),
    HH_EK("EK_HH_HZV"),
    SH_AOK("AOK_SH_HZV"),
    SH_EK("EK_SH_HZV"),
    ST_AOK("AOK_ST_HZV"),
    HB_EK("EK_HB_HZV"),
    HE_AOK("AOK_HE_HZV"),
    HE_BKKVAG("BKK_VAG_HE"),
    HE_EK("EK_HE_HZV"),
    RLP_AOK("AOK_RP_HZV"),
    RLP_EK("EK_RLP_HZV"),
    BE_AOKIKK("AOK_IKK_BLN_HZV"),
    BE_EK("EK_BLN_HZV"),
    SL_AOK("AOK_SL_HZV"),
    SL_EK("EK_SL_HZV"),
    SN_AOK("AOK_PLUS_HZV"),
    SN_EK("EK_SN_HZV"),
    SN_KBS("RV_KBS_SN_HZV"),
    WL_AOK("AOK_WL_HZV"),
    WL_BKK("BKK_WL_HZV"),
    WL_EK("EK_WL_HZV"),
    WL_KBS("RV_KBS_WL_HZV"),
    WL_LKK("LKK_WL_HZV"),
    NO_AOK("AOK_NO_HZV"),
    NO_BKK("BKK_NO_HZV"),
    NO_EK("EK_NO_HZV"),
    NO_KBS("RV_KBS_NO_HZV"),
    NO_LKK("LKK_NO_HZV");

    private final String a;
    private static final Map<String, Hzv> b;
    public static final Map<String, Set<Hzv>> ENUM_KV_MAP;

    private Hzv(String vertragsIdentifikator) {
        this.a = vertragsIdentifikator;
    }

    public String getVertragsIdentifikator() {
        return this.a;
    }

    public String toString() {
        return this.a;
    }

    public String gnr(String gnr) {
        return this.a(gnr, "|", string -> {
            if (string.contains("/")) {
                return this.a((String)string, "/", this::a);
            }
            return this.a((String)string);
        });
    }

    private String a(String string, String string2, Function<String, String> function) {
        if (this == KEIN_HZV) {
            return string;
        }
        return Stream.of(string.split("[" + string2 + "]")).map(function).collect(Collectors.joining(string2));
    }

    private String a(String string) {
        return String.format("%s-%s", string, this.a);
    }

    public String getPauschalen() {
        switch (this) {
            case BUNDESWEIT_TK: {
                return BUNDESWEIT_TK.gnr("0000|0001");
            }
            case BUNDESWEIT_IKK: {
                return BUNDESWEIT_IKK.gnr("0000");
            }
            case BUNDESWEIT_LKK: {
                return BUNDESWEIT_LKK.gnr("0000|0001");
            }
            case BUNDESWEIT_BKKGWQ: {
                return BUNDESWEIT_BKKGWQ.gnr("0000|0001");
            }
            case BUNDESWEIT_BKKSPECTRUM: {
                return BUNDESWEIT_BKKSPECTRUM.gnr("0000");
            }
            case BAYERN_AOK: {
                return BAYERN_AOK.gnr("0000|0001|0002");
            }
            case BAYERN_EK: {
                return BAYERN_EK.gnr("0000|0001|0002");
            }
            case BAYERN_BKK: {
                return BAYERN_BKK.gnr("0000|0001|0001Z");
            }
            case BAYERN_LKK: {
                return BAYERN_LKK.gnr("0000|0001|0002");
            }
            case BW_AOK: {
                return BW_AOK.gnr("0000|0000F");
            }
            case BW_IKK: {
                return BW_IKK.gnr("0000");
            }
            case BW_LKK: {
                return BW_LKK.gnr("P2a|P2b");
            }
            case BW_BKK: {
                return BW_BKK.gnr("0000");
            }
            case BW_BKKVAG: {
                return BW_BKKVAG.gnr("0000");
            }
            case BW_BOSCHBKK: {
                return BW_BOSCHBKK.gnr("0000");
            }
            case BW_EK: {
                return BW_EK.gnr("0000");
            }
            case BW_KBS: {
                return BW_KBS.gnr("0000");
            }
            case HE_AOK: {
                return HE_AOK.gnr("0000|0001");
            }
            case HE_EK: {
                return HE_EK.gnr("0000|0001");
            }
            case HE_BKKVAG: {
                return HE_BKKVAG.gnr("0000");
            }
            case SN_AOK: {
                return SN_AOK.gnr("0001|0002");
            }
            case SN_EK: {
                return SN_EK.gnr("0000|0001");
            }
            case SN_KBS: {
                return SN_KBS.gnr("0000|0001");
            }
        }
        return "";
    }

    public static boolean isPauschale(ScheinLeistung l2) {
        return Stream.of(Hzv.values()).map(Hzv::getPauschalen).flatMap(string -> Stream.of(string.split("[|]"))).anyMatch(string -> string.equals(l2.getGnr()));
    }

    public boolean hasVertragsIdentifikator(String gnr) {
        return gnr.endsWith(this.a);
    }

    public static Hzv get(String vertragsIdentifikator) {
        return b.getOrDefault(vertragsIdentifikator.toUpperCase(Locale.ROOT), KEIN_HZV);
    }

    static {
        b = Arrays.stream(Hzv.values()).collect(Collectors.toMap(hzv -> hzv.getVertragsIdentifikator().toUpperCase(Locale.ROOT), Function.identity()));
        HashMap hashMap = new HashMap();
        hashMap.put("Baden-W\u00fcrttemberg", Stream.of(BW_AOK, BW_AOK_MODUL, BW_BKK, BW_BKKVAG, BW_BOSCHBKK, BW_EK, BW_IKK, BW_KBS, BW_LKK, BUNDESWEIT_TK, BW_AOK_PNEUMOLOGIE, BW_AOK_GASTRO, BW_AOK_KARDIO, BW_AOK_ORTH_CHIR, BW_AOK_PSYCH, BW_AOK_UROLOGIE, BW_AOK_NEPHRO, BW_BOSCHBKK_GASTRO, BW_BOSCHBKK_KARDIO, BW_BOSCHBKK_ORTH_CHIR, BW_BOSCHBKK_PSYCH, BW_BOSCHBKK_UROLOGIE, BW_BOSCHBKK_PNEUMOLOGIE, BW_BKKVAG_GASTRO, BW_BKKVAG_KARDIO, BW_PSYCH, BW_EK_DIABETOLOGIE).collect(Collectors.toSet()));
        hashMap.put("Bayern", Stream.of(BAYERN_AOK, BAYERN_BKK, BAYERN_EK, BUNDESWEIT_IKK, BAYERN_LKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Berlin", Stream.of(BE_AOKIKK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, BE_EK, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Brandenburg", Stream.of(BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Bremen", Stream.of(BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, HB_EK, BUNDESWEIT_HKK, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Hamburg", Stream.of(HH_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, HH_EK, BUNDESWEIT_HKK, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Hessen", Stream.of(HE_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, HE_BKKVAG, HE_EK, BUNDESWEIT_IKK, BUNDESWEIT_LKK, BUNDESWEIT_TK, BUNDESWEIT_BAHNBKK).collect(Collectors.toSet()));
        hashMap.put("Mecklenburg-Vorpommern", Collections.emptySet());
        hashMap.put("Niedersachsen", Stream.of(BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Nordrhein", Stream.of(NO_AOK, NO_BKK, BUNDESWEIT_BKKSPECTRUM, NO_EK, BUNDESWEIT_IKK, NO_KBS, NO_LKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Rheinland-Pfalz", Stream.of(RLP_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, BUNDESWEIT_DAK, RLP_EK, BUNDESWEIT_IKK, BUNDESWEIT_LKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Saarland", Stream.of(SL_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, SL_EK, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Sachsen", Stream.of(SN_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, SN_EK, BUNDESWEIT_IKK, SN_KBS, BUNDESWEIT_TK, BUNDESWEIT_BAHNBKK).collect(Collectors.toSet()));
        hashMap.put("Sachsen-Anhalt", Collections.emptySet());
        hashMap.put("Schleswig-Holstein", Stream.of(SH_AOK, BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, SH_EK, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Th\u00fcringen", Stream.of(BUNDESWEIT_BKKGWQ, BUNDESWEIT_BKKSPECTRUM, BUNDESWEIT_IKK, BUNDESWEIT_TK).collect(Collectors.toSet()));
        hashMap.put("Westfalen-Lippe", Stream.of(WL_BKK, WL_EK, WL_KBS, WL_LKK, BUNDESWEIT_TK, WL_AOK).collect(Collectors.toSet()));
        ENUM_KV_MAP = Collections.unmodifiableMap(hashMap);
    }
}

