/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer;

import com.nhochdrei.kvdt.data.EBM;
import com.nhochdrei.kvdt.exporter.ActionConsumer;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.importer.KVDTData;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.RunType;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.PatientOptimizerSettings;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RuleConfigs;
import com.nhochdrei.kvdt.optimizer.RuleData;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.SkipRuleInSingleMode;
import com.nhochdrei.kvdt.optimizer.a;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.misc.j;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import com.nhochdrei.mod.licence.LicenceHelper;
import com.nhochdrei.mod.licence.model.CustomerLicence;
import com.nhochdrei.mod.licence.model.CustomerLicenceLanr;
import com.nhochdrei.mod.licence.model.LicenceError;
import com.nhochdrei.mod.licence.model.LicenceException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientOptimizer {
    private static final Logger a = LoggerFactory.getLogger(PatientOptimizer.class);
    private static final List<String> b = Arrays.asList("999999999", "999999900");
    private static ScanResult c;
    private final boolean d;
    private List<RuleData> e = new ArrayList<RuleData>();
    private c f;
    private boolean g = true;
    private ActionConsumer h;

    public PatientOptimizer(KVDTData kvdtData, PatientOptimizerSettings settings) throws LicenceException {
        this.a(kvdtData, settings);
        this.d = "1".equals(System.getProperty("n3.kvdt.optimizer.freeze"));
        com.nhochdrei.kvdt.data.a.a(this.getClass().getClassLoader().getResourceAsStream("Chroniker.csv"));
        com.nhochdrei.kvdt.data.a.b(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVBayernAOK.csv"));
        com.nhochdrei.kvdt.data.a.c(this.getClass().getClassLoader().getResourceAsStream("OnkologieHzVBayernAOK.csv"));
        com.nhochdrei.kvdt.data.a.d(this.getClass().getClassLoader().getResourceAsStream("OnkologieHzVBayernEK.csv"));
        com.nhochdrei.kvdt.data.a.e(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVBayernBKK.csv"));
        com.nhochdrei.kvdt.data.a.f(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVBayernIKK.csv"));
        com.nhochdrei.kvdt.data.a.g(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVBayernBoschBKK.csv"));
        com.nhochdrei.kvdt.data.a.h(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVHessenAOK.csv"));
        com.nhochdrei.kvdt.data.a.i(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVWestfalenLippeAOK.csv"));
        com.nhochdrei.kvdt.data.a.j(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVWLIKK.csv"));
        com.nhochdrei.kvdt.data.a.k(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVWLEK.csv"));
        com.nhochdrei.kvdt.data.a.l(this.getClass().getClassLoader().getResourceAsStream("ChronikerHzVSpectrumK.csv"));
        this.f = new c(settings, kvdtData);
        if (c == null) {
            c = new ClassGraph().enableAnnotationInfo().whitelistLibOrExtJars(new String[]{"*"}).whitelistPackages(new String[]{this.getClass().getPackage().getName()}).scan();
        }
        for (ClassInfo classInfo : c.getClassesWithAnnotation(Rules.class.getName())) {
            Class clazz = classInfo.loadClass();
            RuleCategory ruleCategory = clazz.getAnnotation(Rules.class).value();
            if (!settings.getEnabledCategories().contains((Object)ruleCategory)) {
                a.info("rules from {} disabled via settings", (Object)clazz);
                continue;
            }
            a.info("loading rules from {} -> {}", (Object)clazz, (Object)ruleCategory.getTitle());
            Method method = null;
            boolean bl = false;
            for (Method method2 : clazz.getMethods()) {
                if (!method2.isAnnotationPresent(RulePrerequisite.class)) continue;
                try {
                    if (method2.getParameterTypes().length == 1) {
                        bl = (Boolean)method2.invoke(null, this.f) == false;
                        continue;
                    }
                    method = method2;
                }
                catch (Exception exception) {
                    a.error("Fehler ausf\u00fchren der Voraussetzungspr\u00fcfung f\u00fcr Regel " + clazz, (Throwable)exception);
                }
            }
            if (bl) {
                a.info("  disabled because prerequesite not met");
                continue;
            }
            Object object = null;
            for (Method method3 : clazz.getMethods()) {
                if (!method3.isAnnotationPresent(RuleConfigs.class)) continue;
                try {
                    object = (List)method3.invoke(null, new Object[0]);
                    a.info("  enabled {} configurations", (Object)object.size());
                }
                catch (Exception exception) {
                    a.error("Fehler beim Ermitteln der Regelkonfigurationen f\u00fcr Regel" + clazz, (Throwable)exception);
                }
            }
            for (Method method3 : clazz.getMethods()) {
                Object object2;
                Object object3;
                String string;
                Rule rule;
                block24: {
                    if (!method3.isAnnotationPresent(Rule.class)) continue;
                    rule = method3.getAnnotation(Rule.class);
                    string = rule.name();
                    if (rule.disabled()) {
                        a.info("  disabled rule \"{}\"", (Object)string);
                        continue;
                    }
                    if (!settings.isShowPotential() && rule.action() == ActionType.POTENTIAL) {
                        a.info("  disabled rule \"{}\" via settings", (Object)string);
                        continue;
                    }
                    if (settings.getRunType() == RunType.SINGLE && method3.getAnnotation(SkipRuleInSingleMode.class) != null) {
                        a.info("  disabled rule \"{}\" via settings because single mode", (Object)string);
                        continue;
                    }
                    if (settings.getRunType() == RunType.MULTI && method3.getAnnotation(SkipRuleInSingleMode.class) == null) {
                        a.info("  disabled rule \"{}\" via settings because multi mode", (Object)string);
                        continue;
                    }
                    if (method3.isAnnotationPresent(RuleRequirement.class)) {
                        object3 = method3.getAnnotation(RuleRequirement.class);
                        object2 = Arrays.asList(object3.value()).stream().flatMap(quartale -> Quartale.a(quartale, kvdtData.getAbrechnungsquartal()).stream()).collect(Collectors.toSet());
                        if (!kvdtData.getQuartale().containsAll((Collection<?>)object2)) {
                            a.info("  disabled rule \"{}\" because not enough data", (Object)string);
                            continue;
                        }
                        try {
                            if (LocalDate.now().isBefore(LocalDate.of(object3.startDate().year(), object3.startDate().month(), object3.startDate().day()))) {
                                a.info("  disabled rule \"{}\" via requirement because start date in future", (Object)string);
                                continue;
                            }
                            if (LocalDate.now().isAfter(LocalDate.of(object3.endDate().year(), object3.endDate().month(), object3.endDate().day()))) {
                                a.info("  disabled rule \"{}\" via requirement because end date exceeded", (Object)string);
                                continue;
                            }
                            break block24;
                        }
                        catch (Exception exception) {
                            a.error("Fehler ausf\u00fchren der Rulerequirement Konvertierung Datumsfelder " + string, (Throwable)exception);
                            break block24;
                        }
                    }
                    a.warn("  !!! no requirements defined for \"{}\"", (Object)string);
                }
                a.info("  loading rule \"{}\"", (Object)string);
                if (object == null) {
                    this.e.add(new RuleData(rule, ruleCategory, method, method3));
                    continue;
                }
                object3 = object.iterator();
                while (object3.hasNext()) {
                    object2 = (j)object3.next();
                    this.e.add(new RuleData(rule, ruleCategory, method, method3, (j<?>)object2));
                }
            }
        }
    }

    public void setStoreData(boolean storeData) {
        this.g = storeData;
    }

    public void setActionConsumer(ActionConsumer actionConsumer) {
        this.h = actionConsumer;
    }

    private void a(KVDTData kVDTData, PatientOptimizerSettings patientOptimizerSettings) throws LicenceException {
        if (patientOptimizerSettings.getLicenceKey() == null) {
            throw new LicenceException(LicenceError.NO_LICENCE);
        }
        CustomerLicence customerLicence = LicenceHelper.getLicence((String)patientOptimizerSettings.getLicenceKey());
        if (customerLicence == null) {
            throw new LicenceException(LicenceError.NO_LICENCE);
        }
        if (customerLicence.getQuartal() == null || !kVDTData.getAbrechnungsquartal().equals(Quartal.get(customerLicence.getQuartal())) && !kVDTData.getAbrechnungsquartal().equals(Quartal.get(customerLicence.getQuartal()).getDelta(-1))) {
            throw new LicenceException(LicenceError.INVALID_QUARTER, kVDTData.getAbrechnungsquartal().toString());
        }
        if (customerLicence.isDemo()) {
            return;
        }
        if (kVDTData.getHauptbetriebsstaetten().isEmpty()) {
            throw new LicenceException(LicenceError.WRONG_BSNR, "keine BSNR in Datei gefunden");
        }
        if (customerLicence.isMvz() != null && customerLicence.isMvz().booleanValue()) {
            if (kVDTData.getHauptbetriebsstaetten().stream().noneMatch(string -> customerLicence.getBsnr().contains(string))) {
                throw new LicenceException(LicenceError.WRONG_BSNR, String.join((CharSequence)", ", kVDTData.getHauptbetriebsstaetten()));
            }
        } else {
            for (String string2 : kVDTData.getHauptbetriebsstaetten()) {
                if (customerLicence.getBsnr().contains(string2)) continue;
                throw new LicenceException(LicenceError.WRONG_BSNR, kVDTData.getHauptbetriebsstaetten().stream().filter(string -> !customerLicence.getBsnr().contains(string)).collect(Collectors.joining(", ")));
            }
        }
        if (customerLicence.isMvz() == null || !customerLicence.isMvz().booleanValue()) {
            List list = kVDTData.getPatients().stream().flatMap(patient -> patient.getLeistungen(kVDTData.getAbrechnungsquartal()).stream().map(ScheinLeistung::getLanr).filter(Objects::nonNull)).distinct().collect(Collectors.toList());
            list.removeAll(b);
            customerLicence.getLanrs().stream().map(CustomerLicenceLanr::getLanr).forEach(list::remove);
            if (!list.isEmpty()) {
                throw new LicenceException(LicenceError.WRONG_LANR, String.join((CharSequence)", ", list));
            }
        }
    }

    public void optimize(Patient patient) {
        if (this.d) {
            patient.freeze();
        }
        if (patient.getScheine(this.f.c).stream().noneMatch(schein -> schein.getArt() != ContainerType.NOTFALL)) {
            return;
        }
        for (RuleData object : this.e) {
            Rule rule;
            block12: {
                rule = object.getRule();
                try {
                    if (object.getPrerequisite() != null && !((Boolean)object.getPrerequisite().invoke(null, this.f, patient)).booleanValue()) {
                    }
                    break block12;
                }
                catch (Exception exception) {
                    a.error("Fehler ausf\u00fchren der Voraussetzungspr\u00fcfung f\u00fcr Regel " + object.getPrerequisite().getDeclaringClass(), (Throwable)exception);
                }
                continue;
            }
            Method method = object.getMethod();
            Object[] objectArray = new Object[method.getParameterCount()];
            this.a(method, objectArray, c.class, this.f);
            this.a(method, objectArray, Patient.class, patient);
            this.a(method, objectArray, j.class, object.getConfig());
            if (rule.daily()) {
                for (Date date : patient.getLeistungen(this.f.c).stream().map(ScheinLeistung::getDatum).distinct().collect(Collectors.toList())) {
                    this.a(method, objectArray, Date.class, date);
                    if (rule.gnr().contains("|") || rule.gnr().contains("*")) {
                        this.a(rule).forEach(string -> {
                            this.a(method, objectArray, String.class, string);
                            this.a(patient, object, method, objectArray, (Action action) -> action.setInput((String)string));
                        });
                        continue;
                    }
                    this.a(patient, object, method, objectArray, (Action action) -> action.setDatum(date));
                }
                continue;
            }
            if (rule.gnr().contains("|") || rule.gnr().contains("*")) {
                this.a(rule).forEach(string -> {
                    this.a(method, objectArray, String.class, string);
                    this.a(patient, object, method, objectArray, (Action action) -> action.setInput((String)string));
                });
                continue;
            }
            this.a(patient, object, method, objectArray);
        }
        for (Action action2 : patient.getActionsConsolidated()) {
            if (this.h == null || action2.isHidden()) continue;
            this.h.accept(action2);
        }
        if (!this.g) {
            patient.getActions().clear();
        }
    }

    private void a(Method method, Object[] objectArray, Class<?> clazz, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Class<?> clazz2 = method.getParameters()[i2].getType();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            objectArray[i2] = object;
        }
    }

    private void a(Patient patient, RuleData ruleData, Method method, Object[] objectArray) {
        this.a(patient, ruleData, method, objectArray, null);
    }

    private void a(Patient patient, RuleData ruleData, Method method, Object[] objectArray, Consumer<Action> consumer) {
        Object object;
        Object object2;
        Action action = new Action(patient, ruleData);
        this.a(method, objectArray, Action.class, action);
        try {
            object2 = method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof a) {
                return;
            }
            a.error("Fehler beim Ausf\u00fchren der Regel " + ruleData.getName(), (Throwable)invocationTargetException);
            return;
        }
        catch (Exception exception) {
            a.error("Fehler beim Ausf\u00fchren der Regel " + ruleData.getName(), (Throwable)exception);
            return;
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof Boolean && !((Boolean)object2).booleanValue()) {
            return;
        }
        if (object2 instanceof Float) {
            action.setPotential((Float)object2);
        } else if (object2 instanceof String) {
            action.setGnr((String)object2);
        } else if (object2 instanceof ScheinLeistung) {
            object = (ScheinLeistung)object2;
            action.setGnr(object.getGnr());
            action.setDatum(object.getDatum());
        }
        if (consumer != null) {
            consumer.accept(action);
        }
        if (ruleData.getRule().apk() != ApkModus.a) {
            switch (ruleData.getRule().apk()) {
                case j: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                    break;
                }
                case y: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                    break;
                }
                case B: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                    break;
                }
                case l: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("26")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("26")));
                    break;
                }
                case m: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, new g("26")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("26")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("26")) != null && patient.getGeschlecht().equals("M")) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("26")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("08")) == null || !patient.getGeschlecht().equals("W")) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("08")));
                    break;
                }
                case n: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, new g("23", "24", "26")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("23", "24", "26")));
                    break;
                }
                case p: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("13")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("13")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("26")) != null && patient.getGeschlecht().equals("M")) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("26")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("07")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("07")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("10")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("10")));
                    break;
                }
                case q: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("13")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("13")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("26")) != null && patient.getGeschlecht().equals("M")) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("26")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("07")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("07")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("08")) == null || !patient.getGeschlecht().equals("W")) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("08")));
                    break;
                }
                case h: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("08")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("08")));
                    break;
                }
                case r: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, new g("21")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("21")));
                    break;
                }
                case d: {
                    if (patient.getAPK(false, this.f.c, 1L, new g("21")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("21")));
                    break;
                }
                case C: {
                    if (patient.getAPK(false, this.f.c, 1L, i.a("01711|01712|01713|01714|01715|01716|01717|01723|01718|01719|81102|81120")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.a("01711|01712|01713|01714|01715|01716|01717|01723|01718|01719|81102|81120")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                    break;
                }
                case v: {
                    if (patient.getAPK(false, this.f.c, 1L, i.a("01720|81121")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.a("01720|81121")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                    break;
                }
                case D: {
                    if (patient.getAPK(false, this.f.c, 1L, i.a("01711|01712|01713|01714|01715|01716|01717|01723|01718|01719|81102|81120")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.a("01711|01712|01713|01714|01715|01716|01717|01723|01718|01719|81102|81120")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                    break;
                }
                case w: {
                    if (patient.getAPK(false, this.f.c, 1L, i.a("01720|81121")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.a("01720|81121")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                    break;
                }
                case z: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("21")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("21")));
                    break;
                }
                case t: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("16")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("16")));
                    break;
                }
                case i: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("13")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("13")));
                    break;
                }
                case o: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0400")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0400")));
                    break;
                }
                case f: {
                    if (patient.getAPK(false, this.f.c, 1L, new g("26")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("26")));
                    break;
                }
                case g: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("18")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("18")));
                    break;
                }
                case u: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("09")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("09")));
                    break;
                }
                case b: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("06")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("06")));
                    break;
                }
                case e: {
                    if (patient.getAPK(false, this.f.c, 1L, new g("04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99")));
                    break;
                }
                case c: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("07")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("07")));
                        break;
                    }
                    if (!this.f.a("Sachsen") || patient.getAPK(false, this.f.c, 1L, i.a("99990")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.a("99990")));
                    break;
                }
                case x: {
                    if (patient.getAPK(false, this.f.c, 1L, new g("28")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("28")));
                    break;
                }
                case k: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("03")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("03")));
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("10")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("10")));
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("1321")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("1321")));
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("1322")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("1322")));
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("1325")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("1325")));
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("1326")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("1326")));
                    break;
                }
                case E: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("26")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("26")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("25")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("25")));
                    break;
                }
                case s: {
                    if (patient.getAPK(false, this.f.c, 1L, new g("52")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, new g("52")));
                    }
                }
                case G: {
                    if (patient.getAPK(false, this.f.c, 1L, i.d("0300")) != null) {
                        action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("0300")));
                        break;
                    }
                    if (patient.getAPK(false, this.f.c, 1L, i.d("18")) == null) break;
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, i.d("18")));
                    break;
                }
            }
        }
        if (action.getAPK() == null && ruleData.getRule().apk() == ApkModus.a) {
            object = ruleData.getRule().action();
            if (object != ActionType.NACHTRAGEN) {
                if (ruleData.getRule().daily() && action.getAPK() == null) {
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, scheinLeistung -> scheinLeistung.getGnr().equals(action.getGnr()) && scheinLeistung.getDatum() == action.getDatum()));
                }
                if (action.getAPK() == null) {
                    action.setAPK(patient.getAPK(false, this.f.c, -1L, scheinLeistung -> scheinLeistung.getGnr().equals(action.getGnr())));
                }
            }
            if (object == ActionType.NACHTRAGEN || action.getAPK() == null && object != ActionType.POTENTIAL) {
                if (action.getAPK() == null) {
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, Hzv::isPauschale));
                }
                if (action.getAPK() == null) {
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, scheinLeistung -> scheinLeistung.getGnr().startsWith("0300")));
                }
                if (action.getAPK() == null) {
                    action.setAPK(patient.getAPK(false, this.f.c, 1L, scheinLeistung -> true));
                }
            }
        }
        patient.getActions().add(action);
    }

    private List<String> a(Rule rule) {
        List<String> list = Stream.of(rule.gnr().split("[|]")).flatMap(string -> string.contains("*") ? (rule.hzv() == Hzv.KEIN_HZV ? EBM.listGnrStartWith(string.replace("*", "")).stream() : EBM.listGnrStartWithHzv(string.replace("*", ""), rule.hzv().getVertragsIdentifikator()).stream()) : Stream.of(string)).collect(Collectors.toList());
        return list;
    }
}

