/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nhochdrei.kvdt.data.EBM;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.Freezable;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.model.Utilities;
import com.nhochdrei.kvdt.optimizer.a;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.misc.k;
import com.nhochdrei.kvdt.optimizer.misc.l;
import com.nhochdrei.kvdt.optimizer.misc.m;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Patient
implements Freezable {
    private static final Logger LOG = LoggerFactory.getLogger(Patient.class);
    private final UUID uuid;
    private Quartal qmax;
    private String name;
    private String vorname;
    private Date geburtsdatum;
    private String geschlecht;
    private String ikNr;
    private String versichertenArt;
    private String tsvg;
    private String patientNummer;
    private Map<Quartal, List<Schein>> scheine = new HashMap<Quartal, List<Schein>>();
    private Map<Quartal, Set<ContainerType>> scheinArten = new HashMap<Quartal, Set<ContainerType>>();
    private Map<Quartal, List<ScheinLeistung>> leistungen = new HashMap<Quartal, List<ScheinLeistung>>();
    private Map<Quartal, List<ScheinDiagnose>> diagnosen = new HashMap<Quartal, List<ScheinDiagnose>>();
    private Map<Quartal, List<ScheinDiagnose>> dauerdiagnosen = new HashMap<Quartal, List<ScheinDiagnose>>();
    private boolean frozen = false;
    private Set<Hzv> hzvVertraege = new HashSet<Hzv>();
    private List<Action> actions = new ArrayList<Action>();

    public Patient(Schein schein) {
        Quartal quartal = schein.getQuartal();
        this.uuid = UUID.randomUUID();
        this.qmax = quartal;
        this.ikNr = schein.getKostentraegerKennung();
        this.name = schein.getPatientName();
        this.vorname = schein.getPatientVorname();
        this.geburtsdatum = schein.getPatientGeburtsdatum();
        this.geschlecht = schein.getPatientGeschlecht();
        this.versichertenArt = schein.getPatientVersichertenArt();
        this.tsvg = schein.getTsvg();
        this.patientNummer = schein.getPatientNummer();
        if (this.name == null && this.vorname == null) {
            this.name = this.patientNummer;
        }
        if (this.name != null && this.name.trim().isEmpty() && this.vorname != null && this.vorname.trim().isEmpty()) {
            this.name = this.patientNummer;
        }
        this.merge(schein);
    }

    private static <K, T> BiFunction<K, List<T>, List<T>> freezeSortedMap(Comparator<T> comparator) {
        return (unused, list) -> Utilities.freezeSorted(comparator, list);
    }

    private List<Schein> ensureScheinList(Quartal quartal) {
        return this.scheine.computeIfAbsent(quartal, unused -> new ArrayList());
    }

    private Set<ContainerType> ensureArtSet(Quartal quartal) {
        return this.scheinArten.computeIfAbsent(quartal, unused -> new HashSet());
    }

    @JsonIgnore
    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVorname() {
        return this.vorname;
    }

    public void setVorname(String vorname) {
        this.vorname = vorname;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="Europe/Berlin")
    public Date getGeburtsdatum() {
        return this.geburtsdatum;
    }

    public void setGeburtsdatum(Date geburtsdatum) {
        this.geburtsdatum = geburtsdatum;
    }

    public String getGeschlecht() {
        return this.geschlecht;
    }

    public void setGeschlecht(String geschlecht) {
        this.geschlecht = geschlecht;
    }

    public String getIkNr() {
        return this.ikNr;
    }

    public void setIkNr(String ikNr) {
        this.ikNr = ikNr;
    }

    public String getPatientNummer() {
        return this.patientNummer;
    }

    public List<ScheinLeistung> getLeistungen(Quartal quartal) {
        return this.leistungen.getOrDefault(quartal, Collections.emptyList());
    }

    public List<ScheinLeistung> getLeistungen(List<Quartal> quartale) {
        return quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Action> getActions() {
        return this.actions;
    }

    @JsonIgnore
    public List<Action> getActionsConsolidated() {
        return this.actions.stream().collect(Collectors.groupingBy(Action::getKey)).values().stream().map(Action::new).sorted(Action::orderForReport).collect(Collectors.toList());
    }

    public void merge(Schein schein) {
        List<ScheinLeistung> list;
        Quartal quartal = schein.getQuartal();
        this.ensureScheinList(quartal).add(schein);
        this.ensureArtSet(quartal).add(schein.getArt());
        if (schein.getHzvVertrag() != null) {
            this.hzvVertraege.add(schein.getHzvVertrag());
        }
        if ((list = this.leistungen.get(quartal)) == null) {
            this.leistungen.put(quartal, new ArrayList<ScheinLeistung>(schein.getLeistungen()));
        } else {
            list.addAll(schein.getLeistungen());
        }
        List<ScheinDiagnose> list2 = this.diagnosen.get(quartal);
        if (list2 == null) {
            this.diagnosen.put(quartal, new ArrayList<ScheinDiagnose>(schein.getDiagnosen()));
        } else {
            list2.addAll(schein.getDiagnosen());
        }
        List<ScheinDiagnose> list3 = this.dauerdiagnosen.get(quartal);
        if (list3 == null) {
            this.dauerdiagnosen.put(quartal, new ArrayList<ScheinDiagnose>(schein.getDauerdiagnosen()));
        } else {
            list3.addAll(schein.getDauerdiagnosen());
        }
        if (quartal.after(this.qmax)) {
            this.qmax = quartal;
            this.ikNr = schein.getKostentraegerKennung();
        }
    }

    @Override
    public void freeze() {
        if (this.frozen) {
            return;
        }
        this.scheine.replaceAll(Patient.freezeSortedMap(Schein.DEFAULT_ORDER));
        this.scheine = Collections.unmodifiableMap(this.scheine);
        this.leistungen.replaceAll(Patient.freezeSortedMap(ScheinLeistung.DEFAULT_ORDER));
        this.leistungen = Collections.unmodifiableMap(this.leistungen);
        this.diagnosen.replaceAll(Patient.freezeSortedMap(ScheinDiagnose.DEFAULT_ORDER));
        this.dauerdiagnosen.replaceAll(Patient.freezeSortedMap(ScheinDiagnose.DEFAULT_ORDER));
        this.diagnosen = Collections.unmodifiableMap(this.diagnosen);
        this.dauerdiagnosen = Collections.unmodifiableMap(this.dauerdiagnosen);
        this.frozen = true;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(", ").append(this.vorname).append(" - ").append(simpleDateFormat.format(this.geburtsdatum)).append("\r\n");
        for (Map.Entry<Quartal, List<ScheinLeistung>> entry : this.leistungen.entrySet()) {
            long l3 = entry.getValue().stream().map(ScheinLeistung::getDatum).map(simpleDateFormat::format).distinct().count();
            stringBuilder.append("\tQuartal: ").append(entry.getKey()).append(" - ").append(l3).append("Tage\r\n");
            stringBuilder.append(entry.getValue().stream().map(l2 -> "\t" + l2).collect(Collectors.joining("\r\n"))).append("\r\n");
        }
        return stringBuilder.toString();
    }

    public boolean hasLeistung(String gnr, Quartal quartal) {
        gnr = gnr.replace("/", "|");
        gnr = "|" + gnr + "|";
        for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
            if (!gnr.contains("|" + scheinLeistung.getGnr() + "|")) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeistung(String gnr, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasLeistung(gnr, (Quartal)q2));
    }

    public boolean hasLeistung(String gnr, List<Quartal> quartal, Predicate<ScheinLeistung> filter) {
        return quartal.stream().anyMatch(q2 -> this.hasLeistung(gnr, (Quartal)q2, filter));
    }

    public boolean hasLeistung(String gnr, Quartal quartal, Date date) {
        return this.hasLeistung(gnr, quartal, date, l2 -> true);
    }

    public boolean hasLeistung(String gnr, Quartal quartal, Date date, Predicate<ScheinLeistung> filter) {
        gnr = "|" + gnr + "|";
        for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
            if (!filter.test(scheinLeistung) || !scheinLeistung.getDatum().equals(date) || !gnr.contains("|" + scheinLeistung.getGnr() + "|")) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeistung(String gnr, Quartal quartal, Predicate<ScheinLeistung> filter) {
        gnr = "|" + gnr + "|";
        for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
            if (!filter.test(scheinLeistung) || !gnr.contains("|" + scheinLeistung.getGnr() + "|")) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeistung(Predicate<ScheinLeistung> filter, Quartal quartal) {
        for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
            if (!filter.test(scheinLeistung)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeistungBeginntMit(String gnr, Quartal quartal) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!scheinLeistung.getGnr().startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasHzvLeistungBeginntMit(String gnr, Hzv hzv, Quartal quartal) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!scheinLeistung.getGnr().startsWith(string) || !scheinLeistung.getGnr().endsWith(hzv.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasHzvLeistungBeginntMit(String gnr, Hzv hzv, Quartal quartal, Date date) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!scheinLeistung.getDatum().equals(date) || !scheinLeistung.getGnr().startsWith(string) || !scheinLeistung.getGnr().endsWith(hzv.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSuffixLeistungBeginntMit(String gnr, AbrechnungType at, Quartal quartal) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!scheinLeistung.getGnr().startsWith(string) || !at.hasSuffix(scheinLeistung.getGnr())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLeistungBeginntMit(String gnr, Quartal quartal, Predicate<ScheinLeistung> filter) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!filter.test(scheinLeistung) || !scheinLeistung.getGnr().startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLeistungBeginntMit(String gnr, Quartal quartal, Date date) {
        gnr = gnr.replace("/", "|");
        for (String string : gnr.split("\\|")) {
            for (ScheinLeistung scheinLeistung : this.getLeistungen(quartal)) {
                if (!scheinLeistung.getDatum().equals(date) || !scheinLeistung.getGnr().startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLeistungBeginntMit(String gnr, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasLeistungBeginntMit(gnr, (Quartal)q2));
    }

    public boolean hasHzvLeistungBeginntMit(String gnr, Hzv hzv, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasHzvLeistungBeginntMit(gnr, hzv, (Quartal)q2));
    }

    public Map<Integer, List<APK>> getLeistungenInKw(String gnr, Quartal quartal) {
        HashMap<Integer, List<APK>> hashMap = new HashMap<Integer, List<APK>>();
        Calendar calendar = Calendar.getInstance(Locale.GERMANY);
        String string = "|" + gnr + "|";
        this.getLeistungen(quartal).stream().filter(g2 -> string.contains("|" + g2.getGnr() + "|")).forEach(l2 -> {
            calendar.set(l2.getDatum().getYear(), l2.getDatum().getMonth(), l2.getDatum().getDay());
            int n2 = calendar.get(3);
            hashMap.computeIfAbsent(n2, k2 -> new ArrayList()).add(new APK((ScheinLeistung)l2));
        });
        return hashMap;
    }

    public List<APK> getLeistungenInKw(String gnr, Quartal quartal, Date date) {
        Map<Integer, List<APK>> map = this.getLeistungenInKw(gnr, quartal);
        Calendar calendar = Calendar.getInstance(Locale.GERMANY);
        calendar.set(date.getYear(), date.getMonth(), date.getDay());
        int n2 = calendar.get(3);
        return map.getOrDefault(n2, new ArrayList());
    }

    public boolean hasSuffixLeistungBeginntMit(String gnr, AbrechnungType at, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasSuffixLeistungBeginntMit(gnr, at, (Quartal)q2));
    }

    public boolean hasDiagnose(String diagnose, Quartal quartal) {
        return this.hasDiagnose(diagnose, false, quartal);
    }

    public boolean hasDiagnose(String diagnose, boolean gesichert, Quartal quartal) {
        diagnose = "|" + diagnose + "|";
        if (this.diagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.diagnosen.get(quartal)) {
                if (gesichert && !scheinDiagnose.isGesichert() || !diagnose.contains("|" + scheinDiagnose.getIcdCodeClean() + "|")) continue;
                return true;
            }
        }
        if (this.dauerdiagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.dauerdiagnosen.get(quartal)) {
                if (gesichert && !scheinDiagnose.isGesichert() || !diagnose.contains("|" + scheinDiagnose.getIcdCodeClean() + "|")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDauerDiagnose(String diagnose, boolean gesichert, Quartal quartal) {
        diagnose = "|" + diagnose + "|";
        if (this.dauerdiagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.dauerdiagnosen.get(quartal)) {
                if (gesichert && !scheinDiagnose.isGesichert() || !diagnose.contains("|" + scheinDiagnose.getIcdCodeClean() + "|")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDiagnose(String diagnosenList, boolean gesichert, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasDiagnose(diagnosenList, gesichert, (Quartal)q2));
    }

    public boolean hasDiagnose(String diagnosenList, String sicherheit, Quartal quartal) {
        String[] stringArray = diagnosenList.split("[|]");
        if (this.diagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.diagnosen.get(quartal)) {
                if (sicherheit != null && !sicherheit.equals(scheinDiagnose.getSicherheit())) continue;
                for (String string : stringArray) {
                    if (!scheinDiagnose.getIcdCodeClean().equals(string)) continue;
                    return true;
                }
            }
        }
        if (this.dauerdiagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.dauerdiagnosen.get(quartal)) {
                if (sicherheit != null && !sicherheit.equals(scheinDiagnose.getSicherheit())) continue;
                for (String string : stringArray) {
                    if (!scheinDiagnose.getIcdCodeClean().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDiagnose(String diagnosenList, String sicherheit, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasDiagnose(diagnosenList, sicherheit, (Quartal)q2));
    }

    public int getDiagnosenCount(String diagnose, Quartal quartal) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(diagnose.split("[|]")));
        List list = Collections.emptyList();
        Stream stream = Stream.concat(this.diagnosen.getOrDefault(quartal, list).stream(), this.dauerdiagnosen.getOrDefault(quartal, list).stream());
        return (int)stream.filter(ScheinDiagnose::isGesichert).map(d2 -> d2.getIcdCodeClean()).filter(hashSet::contains).distinct().count();
    }

    public int getDiagnosenCount(String diagnose, List<Quartal> quartale) {
        int n2 = 0;
        for (Quartal quartal : quartale) {
            n2 += this.getDiagnosenCount(diagnose, quartal);
        }
        return n2;
    }

    public boolean hasDiagnoseBeginntMit(String diagnosenList, String sicherheit, Quartal quartal) {
        String[] stringArray = diagnosenList.split("[|]");
        if (this.diagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.diagnosen.get(quartal)) {
                if (sicherheit != null && !sicherheit.equals(scheinDiagnose.getSicherheit())) continue;
                for (String string : stringArray) {
                    if (!scheinDiagnose.getIcdCodeClean().startsWith(string)) continue;
                    return true;
                }
            }
        }
        if (this.dauerdiagnosen.containsKey(quartal)) {
            for (ScheinDiagnose scheinDiagnose : this.dauerdiagnosen.get(quartal)) {
                if (sicherheit != null && !sicherheit.equals(scheinDiagnose.getSicherheit())) continue;
                for (String string : stringArray) {
                    if (!scheinDiagnose.getIcdCodeClean().startsWith(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDiagnoseBeginntMit(String diagnosenList, Quartal quartal) {
        return this.hasDiagnoseBeginntMit(diagnosenList, null, quartal);
    }

    public boolean hasDiagnoseBeginntMit(String diagnosenList, String sicherheit, List<Quartal> quartal) {
        return quartal.stream().anyMatch(q2 -> this.hasDiagnoseBeginntMit(diagnosenList, sicherheit, (Quartal)q2));
    }

    public long getAPKCount(boolean persoenlich, Quartal quartal) {
        return this.getAPKCount(persoenlich, quartal, l2 -> true);
    }

    public long getAPKCount(boolean persoenlich, Quartal quartal, Predicate<ScheinLeistung> filter) {
        if (!this.leistungen.containsKey(quartal)) {
            return 0L;
        }
        return this.getAPKStream(persoenlich, quartal, filter).count();
    }

    public long getAPKCount(boolean persoenlich, List<Quartal> quartale) {
        long l2 = 0L;
        for (Quartal quartal : quartale) {
            if (!this.leistungen.containsKey(quartal)) continue;
            l2 += this.getAPKCount(persoenlich, quartal);
        }
        return l2;
    }

    public APK getAPK(boolean persoenlich, Quartal quartal, long index) {
        return this.getAPK(persoenlich, quartal, index, l2 -> true);
    }

    public APK getAPK(boolean persoenlich, Quartal quartal, long index, Predicate<ScheinLeistung> filter) {
        if (index == 0L) {
            throw new IllegalArgumentException("zero is not allowed");
        }
        if (!this.leistungen.containsKey(quartal)) {
            return null;
        }
        int n2 = index < 0L ? -1 : 1;
        return this.getAPKStream(persoenlich, quartal, filter).sorted((a1, a2) -> n2 * a1.compareTo((APK)a2)).skip(Math.abs(index) - 1L).findFirst().orElse(null);
    }

    public APK getAPK(boolean persoenlich, Quartal quartal, long index, Predicate<ScheinLeistung> filter, Date date) {
        return this.getAPK(persoenlich, quartal, index, l2 -> filter.test((ScheinLeistung)l2) && l2.getDatum().equals(date));
    }

    private Stream<APK> getAPKStream(boolean persoenlich, Quartal quartal, Predicate<ScheinLeistung> filter) {
        return this.leistungen.get(quartal).stream().filter(l2 -> !persoenlich || this.hasAPKZifferOnSameDay(quartal, (ScheinLeistung)l2)).filter(filter).map(APK::new).distinct();
    }

    public boolean hasAPK(boolean persoenlich, Quartal quartal) {
        return this.getAPKCount(persoenlich, quartal) > 0L;
    }

    private boolean hasAPKZifferOnSameDay(Quartal quartal, ScheinLeistung leistung) {
        return this.leistungen.get(quartal).stream().filter(l2 -> l2.getDatum().equals(leistung.getDatum()) && l2.getLanr().equals(leistung.getLanr())).map(ScheinLeistung::getGnr).anyMatch(EBM.getApks()::contains);
    }

    public long getAPKCountOnSameDay(boolean persoenlich, Quartal quartal, Predicate<ScheinLeistung> filter, Date date) {
        if (!this.leistungen.containsKey(quartal)) {
            return 0L;
        }
        return this.leistungen.get(quartal).stream().filter(l2 -> !persoenlich || l2.getDatum().equals(date) && l2.getLanr().equals(l2.getLanr())).filter(filter).map(ScheinLeistung::getGnr).filter(EBM.getApks()::contains).distinct().count();
    }

    @JsonIgnore
    public Integer getAlter(Quartal quartal) {
        if (!this.leistungen.containsKey(quartal)) {
            throw new a();
        }
        Date date = this.leistungen.get(quartal).stream().map(ScheinLeistung::getDatum).min(Date::compareTo).orElse(null);
        if (date == null) {
            throw new a();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.geburtsdatum);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n2 = calendar2.get(1) - calendar.get(1);
        calendar2.set(1, calendar.get(1));
        if (!calendar.before(calendar2)) {
            --n2;
        }
        return n2;
    }

    @JsonIgnore
    public Integer getAlterInTage() {
        return this.getAlterInTage(Calendar.getInstance().getTime());
    }

    @JsonIgnore
    public Integer getAlterInTage(Date date) {
        long l2 = date.getTime() - this.geburtsdatum.getTime();
        long l3 = l2 / 86400000L;
        return (int)l3;
    }

    @JsonIgnore
    public Integer getAlterInMonate() {
        return this.getAlterInMonate(Calendar.getInstance().getTime());
    }

    @JsonIgnore
    public Integer getAlterInMonate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.geburtsdatum);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n2 = calendar2.get(1) - calendar.get(1);
        calendar2.set(1, calendar.get(1));
        int n3 = calendar.get(5) > calendar2.get(5) ? 1 : 0;
        int n4 = n2 * 12 + calendar2.get(2) - calendar.get(2) - n3;
        return n4;
    }

    @JsonIgnore
    public Integer getAlterAnTag() {
        return this.getAlterAnTag(Calendar.getInstance().getTime());
    }

    public Integer getAlterAnTag(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.geburtsdatum);
        if (date == null) {
            date = new Date();
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n2 = calendar2.get(1) - calendar.get(1);
        calendar2.set(1, calendar.get(1));
        if (!calendar.before(calendar2)) {
            --n2;
        }
        return n2;
    }

    @JsonIgnore
    public boolean hasIk(String ikList) {
        for (String string : ikList.split("[|]")) {
            if (!string.equals(this.ikNr)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVknr(String vknrList, Quartal quartal) {
        for (String string : vknrList.split("[|]")) {
            if (!this.scheine.get(quartal).stream().anyMatch(s -> s.getAbrechnungsVknr().equals(string))) continue;
            return true;
        }
        return false;
    }

    public int getDiagnoseClusterCount(Quartal quartal, Map<String, String> cluster) {
        return (int)cluster.values().stream().filter(diagnose -> this.hasDiagnose((String)diagnose, true, quartal)).count();
    }

    public boolean hasScheinArt(ContainerType scheinArt, Quartal quartal) {
        Set set = this.scheinArten.getOrDefault(quartal, Collections.emptySet());
        return set.contains((Object)scheinArt);
    }

    public Map<Quartal, List<Schein>> getScheine() {
        return this.scheine;
    }

    public List<Schein> getScheine(Quartal quartal) {
        return this.scheine.getOrDefault(quartal, Collections.emptyList());
    }

    public List<Schein> getScheine(List<Quartal> quartal) {
        return quartal.stream().map(q2 -> this.scheine.getOrDefault(q2, Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean hasLeistungOnScheinArt(String gnr, Quartal quartal, ContainerType scheinArt) {
        return this.hasLeistungOnScheinArt(gnr, Arrays.asList(quartal), scheinArt);
    }

    public boolean hasLeistungOnScheinArt(String gnr, List<Quartal> quartale, ContainerType scheinArt) {
        gnr = gnr.replace("/", "|");
        for (Quartal quartal : quartale) {
            for (String string : gnr.split("\\|")) {
                if (!this.getScheine(quartal).stream().anyMatch(s -> s.getArt() == scheinArt && s.getLeistungen().stream().anyMatch(i.a(string)))) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public Collection<Quartal> getQuartale() {
        return this.scheine.keySet();
    }

    public ScheinLeistung getLeistung(String gnr, long index, Quartal quartal) {
        ScheinLeistung scheinLeistung = null;
        for (String string : gnr.split("[|]")) {
            scheinLeistung = this.getLeistungen(quartal).stream().filter(l2 -> l2.getGnr().equals(string)).skip(index - 1L).findFirst().orElse(null);
            if (scheinLeistung == null) continue;
            return scheinLeistung;
        }
        return null;
    }

    public ScheinLeistung getLeistungBeginntMit(String gnr, long index, Quartal quartal) {
        ScheinLeistung scheinLeistung = null;
        for (String string : gnr.split("[|]")) {
            scheinLeistung = this.getLeistungen(quartal).stream().filter(l2 -> l2.getGnr().startsWith(string)).skip(index - 1L).findFirst().orElse(null);
            if (scheinLeistung == null) continue;
            return scheinLeistung;
        }
        return null;
    }

    public ScheinLeistung getLeistungAnTag(String gnr, long index, Quartal quartal, Date date) {
        ScheinLeistung scheinLeistung = null;
        for (String string : gnr.split("[|]")) {
            scheinLeistung = this.getLeistungen(quartal).stream().filter(l2 -> l2.getGnr().equals(string) && l2.getDatum().equals(date)).skip(index - 1L).findFirst().orElse(null);
            if (scheinLeistung == null) continue;
            return scheinLeistung;
        }
        return null;
    }

    public ScheinLeistung getLeistungProSchein(String gnr, long index, Quartal quartal) {
        return this.getScheine(quartal).stream().filter(i.c(gnr)).collect(Collectors.groupingBy(Schein::getKostentraegerKennung)).values().stream().map(list -> list.stream().flatMap(s -> s.getLeistungen().stream()).filter(i.a(gnr)).skip(index - 1L).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    public boolean hasSchein(ContainerType art, Quartal quartal) {
        return this.hasSchein(art, Arrays.asList(quartal));
    }

    public boolean hasSchein(ContainerType art, List<Quartal> quartale) {
        for (Quartal quartal : quartale) {
            if (!this.getScheine(quartal).stream().anyMatch(s -> s.getArt() == art)) continue;
            return true;
        }
        return false;
    }

    public boolean hasScheinuntergruppe(k art, Quartal ... quartale) {
        for (Quartal quartal : quartale) {
            if (!this.getScheine(quartal).stream().noneMatch(s -> k.a(s.getUntergruppe()) == art)) continue;
            return false;
        }
        return true;
    }

    public int getLeistungCount(String gnr, Quartal ... quartale) {
        return this.getLeistungCount(gnr, Arrays.asList(quartale));
    }

    public int getLeistungCount(String gnr, List<Quartal> quartale) {
        String string = "|" + gnr + "|";
        return (int)quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> string.contains("|" + g2.getGnr() + "|")).count();
    }

    public int getLeistungCount(String gnr, List<Quartal> quartal, g filter) {
        String string = "|" + gnr + "|";
        return (int)quartal.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> filter.a((ScheinLeistung)g2)).filter(g2 -> string.contains("|" + g2.getGnr() + "|")).count();
    }

    public int getLeistungCountFromDate(String gnr, Quartal quartal, Date date) {
        if (this.leistungen.get(quartal) == null) {
            return 0;
        }
        String string = "|" + gnr + "|";
        return (int)this.leistungen.get(quartal).stream().filter(l2 -> l2.getDatum().equals(date)).filter(g2 -> string.contains("|" + g2.getGnr() + "|")).count();
    }

    public int getLeistungCountDaysAfter(String gnr, Quartal quartal, Date from, int days) {
        return this.getLeistungCountDaysAfter(gnr, Arrays.asList(quartal), from, days);
    }

    public int getLeistungCountDaysAfter(String gnr, List<Quartal> quartale, Date from, int days) {
        String string = "|" + gnr + "|";
        return (int)quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> string.contains("|" + g2.getGnr() + "|") && from.getTime() <= g2.getDatum().getTime() && this.getDaysBetween(g2.getDatum(), from) <= days).count();
    }

    public int getLeistungCountByLanr(String gnr, String lanr, Quartal quartal) {
        return (int)this.getLeistungen(quartal).stream().filter(s -> s.getGnr().equals(gnr) && s.getLanr().equals(lanr)).count();
    }

    public int getLeistungCountByLanr(String gnr, String lanr, List<Quartal> quartale) {
        return (int)quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(s -> s.getGnr().equals(gnr) && s.getLanr().equals(lanr)).count();
    }

    public int getLeistungBeginntMitCount(String gnr, Quartal ... quartale) {
        return this.getLeistungBeginntMitCount(gnr, Arrays.asList(quartale));
    }

    public int getLeistungBeginntMitCount(String gnr, List<Quartal> quartal) {
        return (int)quartal.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> g2.getGnr().startsWith(gnr)).count();
    }

    public String getFirstDiagnose(String diag, Quartal quartal) {
        return Stream.concat(this.dauerdiagnosen.get(quartal).stream(), this.diagnosen.get(quartal).stream()).filter(d2 -> diag.contains("|" + d2.getIcdCodeClean() + "|") && d2.isGesichert()).map(ScheinDiagnose::getIcdCodeClean).findFirst().orElse(null);
    }

    public ScheinDiagnose getDiagnose(String diag, Quartal quartal) {
        return Stream.concat(this.dauerdiagnosen.get(quartal).stream(), this.diagnosen.get(quartal).stream()).filter(d2 -> diag.contains("|" + d2.getIcdCodeClean() + "|") && d2.isGesichert()).findFirst().orElse(null);
    }

    public List<ScheinDiagnose> getDiagnosen(Quartal quartal) {
        return Stream.concat(this.dauerdiagnosen.get(quartal).stream(), this.diagnosen.get(quartal).stream()).collect(Collectors.toList());
    }

    public boolean isVersichertenArt(m versichertenArt) {
        return this.versichertenArt.equals(versichertenArt.toString());
    }

    public boolean isOverWeekCount(String gnr, Quartal quartal, int maxCount) {
        return this.isOverWeekCount(gnr, Arrays.asList(quartal), maxCount);
    }

    public boolean isOverWeekCount(String gnr, List<Quartal> quartale, int maxCount) {
        String string = "|" + gnr + "|";
        Stream<ScheinLeistung> stream = quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> string.contains("|" + g2.getGnr() + "|"));
        return stream.collect(Collectors.groupingBy(ScheinLeistung::getKW, Collectors.counting())).values().stream().anyMatch(c2 -> c2 > (long)maxCount);
    }

    public boolean hasDayInterval(String gnr, Quartal quartal, int days) {
        return this.hasDayInterval(gnr, Arrays.asList(quartal), days);
    }

    public boolean hasDayInterval(String gnr, List<Quartal> quartale, int days) {
        String string = "|" + gnr + "|";
        List list = quartale.stream().flatMap(q2 -> this.leistungen.getOrDefault(q2, Collections.emptyList()).stream()).filter(g2 -> string.contains("|" + g2.getGnr() + "|")).sorted((d1, d2) -> d1.getDatum().compareTo(d2.getDatum())).collect(Collectors.toList());
        if (list.size() < 2) {
            return true;
        }
        return IntStream.range(1, list.size()).map(i2 -> Math.round((((ScheinLeistung)list.get(i2)).getDatum().getTime() - ((ScheinLeistung)list.get(i2 - 1)).getDatum().getTime()) / 86400000L)).allMatch(i2 -> i2 > days);
    }

    public boolean hasPauschale(Quartal quartal) {
        return this.leistungen.get(quartal).stream().anyMatch(l2 -> l2.hasLeistungBeginntMit(EBM.getHausarztPauschalen()));
    }

    private int getDaysBetween(Date d1, Date d2) {
        return Math.round((d1.getTime() - d2.getTime()) / 86400000L);
    }

    public boolean hasLeistungInDaysAfter(Date to, Date from, int days) {
        return 0 <= this.getDaysBetween(to, from) && this.getDaysBetween(to, from) <= days;
    }

    public boolean hasLeistungInDaysBefore(Date till, Date from, int days) {
        return 0 <= this.getDaysBetween(till, from) && this.getDaysBetween(till, from) <= days;
    }

    public boolean hasOPSchluessel(String schluessel, Quartal quartal) {
        String[] stringArray;
        for (String string : stringArray = schluessel.split("[|]")) {
            if (!this.leistungen.getOrDefault(quartal, Collections.emptyList()).stream().anyMatch(l2 -> l2.getOpSchluessel().stream().anyMatch(o2 -> o2.getOpSchluessel().equals(string)))) continue;
            return true;
        }
        return false;
    }

    public boolean isTsvg(l tsvg) {
        if (this.tsvg == null) {
            return false;
        }
        return this.tsvg.equals(tsvg.toString());
    }

    public boolean hasScheinInQuartal(Quartal quartal) {
        return !this.getScheine(quartal).isEmpty();
    }

    public boolean hasGrundPauschale(Quartal quartal) {
        return this.leistungen.get(quartal).stream().anyMatch(l2 -> l2.hasLeistung(EBM.getGrundpauschalen()));
    }

    public ScheinLeistung getGrundPauschale(Quartal quartal) {
        ScheinLeistung scheinLeistung = null;
        if (this.hasGrundPauschale(quartal)) {
            scheinLeistung = this.getLeistungen(quartal).stream().filter(l2 -> l2.hasLeistung(EBM.getGrundpauschalen())).findFirst().orElse(null);
        }
        return scheinLeistung;
    }

    public boolean hasHzvVertrag(Hzv hzv) {
        return this.hzvVertraege.contains((Object)hzv);
    }
}

