/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.AxarisContext;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConFile;
import com.nhochdrei.kvdt.model.OPS;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AxarisImport
extends AbstractFileImporter {
    private static final Logger f = LoggerFactory.getLogger(AxarisImport.class);
    private final HashMap<String, ConFile> g = new HashMap();
    private final Set<Betriebssteatte> h = new HashSet<Betriebssteatte>();
    private final Set<Arzt> i = new HashSet<Arzt>();
    private final Map<String, Set<ScheinDiagnose>> j = new HashMap<String, Set<ScheinDiagnose>>();
    private final List<ScheinDiagnose> k = new ArrayList<ScheinDiagnose>();
    private final SimpleDateFormat l = new SimpleDateFormat("yyyy-MM-dd");
    private final a m = new a();
    protected File d;
    protected Map<String, String> e;
    private AxarisContext n = AxarisContext.UNKNOWN;
    private ConFile o;
    private Schein p;
    private ScheinLeistung q;
    private ScheinDiagnose r;
    private boolean s;
    private String t;
    private OPS u = null;
    private String v;
    private Betriebssteatte w;
    private boolean x;
    private StringBuilder y = new StringBuilder();
    private String z;
    private Date A;
    private String B;
    private String C;
    private String D;
    private String E;
    private String F;
    private String G;
    private Date H;
    private String I;
    private String J;
    private String K;
    private String L;
    private String M;
    private String N;
    private String O;
    private String P;
    private String Q;
    private Quartal R = Quartal.get("19001");
    private Charset S = StandardCharsets.ISO_8859_1;

    @Override
    public boolean canReadFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".xml")) {
            return false;
        }
        if (this.checkCharset(file, StandardCharsets.UTF_8)) {
            return true;
        }
        if (this.checkCharset(file, StandardCharsets.ISO_8859_1)) {
            return true;
        }
        return this.checkCharset(file, StandardCharsets.UTF_16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCharset(File file, Charset charset) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            boolean bl;
            bufferedReader.mark(4);
            int n2 = bufferedReader.read();
            if (n2 != 65279) {
                bl = bufferedReader.read();
                int n3 = bufferedReader.read();
                if (239 != n2 || 187 != 0 != bl || 191 != n3) {
                    bufferedReader.reset();
                }
            }
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string == null) {
                bl = false;
                return bl;
            }
            if (!string.startsWith("<extraxExport")) return false;
            this.S = charset;
            bl = true;
            return bl;
        }
        catch (IOException iOException) {
            f.error("Fehler beim Einlesen der Axaris Datei: " + file, (Throwable)iOException);
        }
        return false;
    }

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) {
        this.a();
        this.d = file;
        this.e = settings.getBetriebsstaettenMapping();
        this.a(file);
    }

    private void a() {
        this.z = null;
        this.A = null;
        this.B = null;
        this.C = null;
        this.D = null;
        this.E = null;
        this.F = null;
        this.G = null;
        this.H = null;
        this.I = null;
        this.J = null;
        this.K = null;
        this.L = null;
        this.g.clear();
        this.h.clear();
        this.i.clear();
        this.j.clear();
        this.k.clear();
        this.u = null;
        this.n = AxarisContext.UNKNOWN;
        this.M = null;
        this.O = null;
        this.P = null;
        this.v = null;
        this.t = null;
        this.w = null;
        this.x = false;
        this.Q = null;
    }

    private void b() {
        this.N = null;
        this.B = null;
        this.C = null;
        this.D = null;
        this.E = null;
        this.F = null;
        this.G = null;
        this.H = null;
        this.I = null;
        this.J = null;
        this.K = null;
        this.L = null;
        this.Q = null;
        this.j.clear();
        this.k.clear();
    }

    private void c() {
        this.s = false;
        this.t = null;
    }

    private void d() {
        this.O = null;
        this.P = null;
    }

    private void a(File file) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), this.S));
            bufferedReader.mark(4);
            int n2 = bufferedReader.read();
            if (n2 != 65279) {
                int n3 = bufferedReader.read();
                int n4 = bufferedReader.read();
                if (239 != n2 || 187 != n3 || 191 != n4) {
                    bufferedReader.reset();
                }
            }
            sAXParser.parse(new InputSource(bufferedReader), (DefaultHandler)this.m);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            f.error("Fehler beim Verarbeiten des Axaris-XML", (Throwable)exception);
        }
    }

    private void a(String string) {
        if (string.equals("ErstellungGestartet")) {
            this.A = this.parseDate(this.z);
        }
    }

    private void b(String string) {
        switch (string) {
            case "Nachname": {
                this.B = this.z;
                break;
            }
            case "Vorname": {
                this.D = this.z;
                break;
            }
            case "Geburtsdatum": {
                this.H = this.parseDate(this.z);
                break;
            }
            case "Geschlecht": {
                this.C = this.z;
                break;
            }
            case "Ort": {
                this.E = this.z;
                break;
            }
            case "PLZ": {
                this.F = this.z.length() == 4 ? "0".concat(this.z) : this.z;
                break;
            }
            case "Strasse": {
                this.G = this.z;
                break;
            }
        }
    }

    private void c(String string) {
        switch (string) {
            case "IKNummer": {
                this.I = this.z;
                break;
            }
            case "Versichertennummer": {
                this.J = this.z;
                break;
            }
            case "VKNR": {
                this.K = this.z;
                break;
            }
            case "BesonderePersonengruppe": {
                this.L = this.z;
                break;
            }
            case "Kassenart": {
                this.Q = this.z;
                break;
            }
        }
    }

    private void d(String string) {
        switch (string) {
            case "BSNR": {
                if (this.v == null) {
                    this.v = this.e.get(this.z);
                }
                Betriebssteatte betriebssteatte = new Betriebssteatte();
                betriebssteatte.setBsnr(this.z);
                this.h.add(betriebssteatte);
                if (!this.x) break;
                this.w = betriebssteatte;
                this.v = this.w.getBsnr();
                break;
            }
            case "LANR": {
                Arzt arzt = new Arzt();
                arzt.setLanr(this.z);
                this.i.add(arzt);
                break;
            }
        }
    }

    private void e(String string) {
        switch (string) {
            case "GueltigVon": 
            case "Datum": 
            case "Ausstellungsdatum": {
                this.p.setAusstellungsdatum(this.parseDate(this.z));
                this.p.setQuartal(this.parseQuartal(this.p.getAusstellungsdatum()));
                this.R = this.p.getQuartal();
                break;
            }
            case "Scheinart": {
                this.p.setArt(ContainerType.get(0 + this.z));
                break;
            }
            case "Rechnungsart": 
            case "ScheinUntergruppe": {
                this.p.setUntergruppe(this.z);
                break;
            }
            case "Versichertenart": {
                this.p.setPatientVersichertenArt(this.z);
                break;
            }
            case "VK_Nummer": {
                this.p.setAbrechnungsVknr(this.z);
                break;
            }
            case "IK_Nummer": {
                this.p.setKostentraegerKennung(this.z);
                break;
            }
            case "V_Nummer": {
                this.p.setPatientVersichertenId(this.z);
                break;
            }
            case "UberweisungAn": {
                this.p.setUeberweisungAn(this.z);
                break;
            }
            case "Kostentraegerabrechnungsbereich": {
                this.p.setKostentraegerAbrechnungsbereich(this.z);
                break;
            }
            case "UeberweiserLanr": {
                this.p.setUeberweiserLanr(this.z);
                break;
            }
            case "UeberweiserBsnr": {
                this.p.setUeberweiserBsnr(this.z);
                break;
            }
            case "IV": {
                if (!this.z.equals("true")) break;
                this.p.setArt(ContainerType.HZV);
                break;
            }
            case "IVArt": 
            case "VertragsID": {
                this.M = this.z;
                if (this.M.matches("^(\\d\\d\\d-).*$")) {
                    this.M = this.M.substring(4);
                }
                this.p.setHzvVertrag(Hzv.get(this.M));
                break;
            }
            case "TSVGVermittlungsart": {
                this.p.setTsvg(this.z);
                break;
            }
        }
    }

    private void f(String string) {
        switch (string) {
            case "Datum": {
                this.q.setDatum(this.parseDate(this.z));
                break;
            }
            case "Ziffer": {
                if (this.p.getArt() == ContainerType.HZV) {
                    this.q.setGnr(this.z + "-" + this.M);
                    this.q.setVertragsidentifikator(this.M);
                    break;
                }
                if (this.p.getArt() == ContainerType.PRIVAT) {
                    this.q.setGnr(AbrechnungType.PKV.gnr(this.z));
                    break;
                }
                this.q.setGnr(this.z);
                break;
            }
            case "Anzahl": {
                this.q.setMultiplikator(Integer.valueOf(this.z));
                break;
            }
            case "BSNR": 
            case "BSNummer": {
                this.q.setBsnr(this.z);
                break;
            }
            case "LANR": 
            case "LANummer": {
                this.q.setLanr(this.z);
                break;
            }
            case "OPS": {
                this.u = new OPS();
                this.q.getOpSchluessel().add(this.u);
                this.u.setOpSchluessel(this.O);
                this.u.setSeitenLokalisation(this.P);
                break;
            }
            case "Schluessel": {
                this.O = this.z;
                break;
            }
            case "Lokalisation": {
                this.P = this.z;
                break;
            }
            case "Steigerungsfaktor": {
                try {
                    this.q.setSteigerungsfaktor(Double.valueOf(this.z));
                }
                catch (NumberFormatException numberFormatException) {
                    f.warn("could not parse double " + this.z, (Throwable)numberFormatException);
                }
                break;
            }
            case "ASVTeamnummer": {
                this.q.setAsvteamnummer(this.z);
                break;
            }
        }
    }

    private void g(String string) {
        switch (string) {
            case "ICD": {
                this.r.setIcdCode(this.z.substring(0, this.z.length() - 1));
                this.r.setSicherheit(this.z.substring(this.z.length() - 1));
                break;
            }
            case "Lokalisation": {
                this.r.setLokalisation(this.z);
                break;
            }
            case "IstDauerDiagnose": {
                this.s = Boolean.parseBoolean(this.z);
                break;
            }
            case "Datum": {
                this.t = this.parseQuartal(this.parseDate(this.z)).toString();
                break;
            }
        }
    }

    private void h(String string) {
        switch (string) {
            case "ICD": {
                this.r.setIcdCode(this.z);
                break;
            }
            case "Sicherheit": {
                this.r.setSicherheit(this.z);
                break;
            }
            case "Lokalisation": {
                this.r.setLokalisation(this.z);
                break;
            }
            case "Datum": {
                this.t = this.parseQuartal(this.parseDate(this.z)).toString();
                break;
            }
        }
    }

    public Date parseDate(String d2) {
        if (d2.isEmpty()) {
            return null;
        }
        try {
            return this.l.parse(d2.substring(0, 10));
        }
        catch (ParseException parseException) {
            f.warn("Fehler Datum parse", (Throwable)parseException);
            return null;
        }
    }

    public Quartal parseQuartal(Date d2) {
        if (d2 == null) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d2);
            return Quartal.get(calendar.get(1), calendar.get(2) / 3 + 1);
        }
        catch (Exception exception) {
            f.warn("Fehler Quartal parse", (Throwable)exception);
            return null;
        }
    }

    private void a(Quartal quartal, AbrechnungType abrechnungType, String string) {
        this.o = null;
        this.o = this.g.get(quartal.toString() + (Object)((Object)abrechnungType) + string);
        if (this.o == null) {
            this.o = new ConFile();
            this.o.setFile(this.d);
            this.o.setAbrechnungsType(abrechnungType);
            this.o.setAbrechnungsquartal(quartal);
            this.o.setErstellungsdatum(this.A);
            this.o.setVertragsIdentifikator(string);
            this.g.put(quartal.toString() + (Object)((Object)abrechnungType) + string, this.o);
        }
    }

    public void fillSchein() {
        this.p.setPatientNummer(this.N);
        this.p.setPatientName(this.B);
        this.p.setPatientVorname(this.D);
        this.p.setPatientGeschlecht(this.C);
        this.p.setPatientOrt(this.E);
        this.p.setPatientPlz(this.F);
        this.p.setPatientStrasse(this.G);
        this.p.setPatientGeburtsdatum(this.H);
        this.p.setPatientVersichertenId(this.J);
        this.p.setAbrechnungsVknr(this.K);
        this.p.setKostentraegerKennung(this.I);
        this.p.setBesonderePersonengruppe(this.L);
        if (this.p.getArt() == ContainerType.PRIVAT && this.Q.equals("G")) {
            this.p.setIsIgel(true);
        }
        if (this.p.getQuartal() == null) {
            this.p.setQuartal(this.R);
        }
        if (!this.k.isEmpty()) {
            this.p.getDauerdiagnosen().addAll(this.k);
        }
        if (this.j.get(this.p.getQuartal().toString()) != null) {
            this.p.getDiagnosen().addAll((Collection<ScheinDiagnose>)this.j.get(this.p.getQuartal().toString()));
        }
    }

    class a
    extends DefaultHandler {
        a() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            AxarisImport.this.y.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AxarisImport.this.y = new StringBuilder();
            switch (localName) {
                case "Header": {
                    AxarisImport.this.n = AxarisContext.HEADER;
                    break;
                }
                case "Patient": {
                    AxarisImport.this.b();
                    AxarisImport.this.N = attributes.getValue("patnr");
                    break;
                }
                case "PersonendatenPatient": {
                    AxarisImport.this.n = AxarisContext.PATIENT;
                    break;
                }
                case "Kassendaten": {
                    AxarisImport.this.n = AxarisContext.KASSE;
                    break;
                }
                case "Praxisdaten": {
                    AxarisImport.this.n = AxarisContext.PRAXISDATEN;
                    break;
                }
                case "BSNR": {
                    if (AxarisImport.this.n != AxarisContext.PRAXISDATEN) break;
                    AxarisImport.this.x = Objects.equals(attributes.getValue("hauptbetriebsstaette"), "true");
                    break;
                }
                case "Abrechnung": 
                case "Kassenabrechnung": {
                    AxarisImport.this.M = "";
                    AxarisImport.this.n = AxarisContext.SCHEINGKV;
                    AxarisImport.this.p = new Schein();
                    AxarisImport.this.p.setAbrechnungBsnr(AxarisImport.this.v);
                    break;
                }
                case "Privatabrechnung": {
                    AxarisImport.this.M = "";
                    AxarisImport.this.n = AxarisContext.SCHEINPKV;
                    AxarisImport.this.p = new Schein();
                    AxarisImport.this.p.setAbrechnungBsnr(AxarisImport.this.v);
                    break;
                }
                case "AndereAbrechnung": {
                    AxarisImport.this.M = "";
                    AxarisImport.this.n = AxarisContext.SCHEIN;
                    AxarisImport.this.p = new Schein();
                    AxarisImport.this.p.setAbrechnungBsnr(AxarisImport.this.v);
                    break;
                }
                case "Abrechnungsziffer": {
                    AxarisImport.this.d();
                    AxarisImport.this.n = AxarisContext.LEISTUNG;
                    AxarisImport.this.q = new ScheinLeistung();
                    AxarisImport.this.q.setGnr("keineZiffer");
                    break;
                }
                case "Diagnose": {
                    AxarisImport.this.c();
                    AxarisImport.this.s = attributes.getValue("dauerdiagnose") != null;
                    AxarisImport.this.n = AxarisContext.DIAGNOSE;
                    AxarisImport.this.r = new ScheinDiagnose();
                    break;
                }
                case "Dauerdiagnose": 
                case "Akutdiagnose": {
                    AxarisImport.this.c();
                    AxarisImport.this.n = AxarisContext.AKUTDIAGNOSE;
                    AxarisImport.this.r = new ScheinDiagnose();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            AxarisImport.this.z = AxarisImport.this.y.toString();
            switch (AxarisImport.this.n) {
                case HEADER: {
                    AxarisImport.this.a(localName);
                    break;
                }
                case PATIENT: {
                    AxarisImport.this.b(localName);
                    break;
                }
                case KASSE: {
                    AxarisImport.this.c(localName);
                    break;
                }
                case PRAXISDATEN: {
                    AxarisImport.this.d(localName);
                    break;
                }
                case SCHEINGKV: 
                case SCHEINPKV: 
                case SCHEIN: {
                    AxarisImport.this.e(localName);
                    break;
                }
                case LEISTUNG: {
                    AxarisImport.this.f(localName);
                    break;
                }
                case DIAGNOSE: {
                    AxarisImport.this.g(localName);
                    break;
                }
                case AKUTDIAGNOSE: {
                    AxarisImport.this.h(localName);
                    break;
                }
            }
            switch (localName) {
                case "extraxExport": {
                    if (AxarisImport.this.c != null) {
                        for (ConFile conFile : AxarisImport.this.g.values()) {
                            AxarisImport.this.c.accept(conFile);
                            if (AxarisImport.this.w != null) {
                                AxarisImport.this.i.forEach(arzt -> AxarisImport.this.w.getAerzte().put(arzt.getLanr(), (Arzt)arzt));
                                conFile.addBetriebsstaette(AxarisImport.this.w.getBsnr(), AxarisImport.this.w);
                            }
                            for (Betriebssteatte betriebssteatte : AxarisImport.this.h) {
                                AxarisImport.this.i.forEach(arzt -> betriebssteatte.getAerzte().put(arzt.getLanr(), (Arzt)arzt));
                                conFile.addBetriebsstaette(betriebssteatte.getBsnr(), betriebssteatte);
                            }
                            for (Betriebssteatte betriebssteatte : conFile.getBetriebsstaetten().values()) {
                                AxarisImport.this.c.accept(betriebssteatte);
                            }
                            for (Schein schein : conFile.getScheine()) {
                                AxarisImport.this.c.accept(schein);
                            }
                        }
                    }
                    if (AxarisImport.this.b) {
                        for (ConFile conFile : AxarisImport.this.g.values()) {
                            AxarisImport.this.a(conFile);
                        }
                    }
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "PersonendatenPatient": 
                case "Kassendaten": {
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Abrechnung": 
                case "Kassenabrechnung": {
                    if (AxarisImport.this.p.getArt() == ContainerType.HZV) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.p.getQuartal(), AbrechnungType.HZV, AxarisImport.this.M);
                        AxarisImport.this.o.getScheine().add(AxarisImport.this.p);
                    } else {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.p.getQuartal(), AbrechnungType.GKV, AxarisImport.this.M);
                        AxarisImport.this.o.getScheine().add(AxarisImport.this.p);
                    }
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Privatabrechnung": {
                    AxarisImport.this.fillSchein();
                    AxarisImport.this.a(AxarisImport.this.p.getQuartal(), AbrechnungType.PKV, AxarisImport.this.M);
                    AxarisImport.this.o.getScheine().add(AxarisImport.this.p);
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "AndereAbrechnung": {
                    if (AxarisImport.this.p.getArt() == ContainerType.BG) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.p.getQuartal(), AbrechnungType.BG, AxarisImport.this.M);
                        AxarisImport.this.o.getScheine().add(AxarisImport.this.p);
                    } else if (AxarisImport.this.p.getArt() == ContainerType.HZV) {
                        AxarisImport.this.fillSchein();
                        AxarisImport.this.a(AxarisImport.this.p.getQuartal(), AbrechnungType.HZV, AxarisImport.this.M);
                        AxarisImport.this.o.getScheine().add(AxarisImport.this.p);
                    }
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Abrechnungsziffer": {
                    AxarisImport.this.p.getLeistungen().add(AxarisImport.this.q);
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Diagnose": {
                    if (AxarisImport.this.s) {
                        AxarisImport.this.k.add(AxarisImport.this.r);
                    } else {
                        AxarisImport.this.j.computeIfAbsent(AxarisImport.this.t, string -> new HashSet()).add(AxarisImport.this.r);
                    }
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Dauerdiagnose": {
                    AxarisImport.this.k.add(AxarisImport.this.r);
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
                case "Akutdiagnose": {
                    AxarisImport.this.j.computeIfAbsent(AxarisImport.this.t, string -> new HashSet()).add(AxarisImport.this.r);
                    AxarisImport.this.n = AxarisContext.UNKNOWN;
                    break;
                }
            }
        }
    }
}

